/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context;

import java.net.URI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.queuing.CarbonQueue;
import org.wso2.carbon.queuing.CarbonQueueManager;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class CarbonContext {
    private CarbonContextHolder carbonContextHolder = null;

    protected CarbonContext(CarbonContextHolder carbonContextHolder) {
        this.carbonContextHolder = carbonContextHolder;
    }

    protected CarbonContextHolder getCarbonContextHolder() {
        if (this.carbonContextHolder == null) {
            return CarbonContextHolder.getCurrentCarbonContextHolder();
        }
        return this.carbonContextHolder;
    }

    public static CarbonContext getCurrentContext() {
        return new CarbonContext(null);
    }

    public int getTenantId() {
        CarbonBaseUtils.checkSecurity();
        return this.getCarbonContextHolder().getTenantId();
    }

    public String getUsername() {
        return this.getCarbonContextHolder().getUsername();
    }

    public String getTenantDomain() {
        return this.getCarbonContextHolder().getTenantDomain();
    }

    public Registry getRegistry(RegistryType type) {
        switch (type) {
            case USER_CONFIGURATION: {
                return (Registry)this.getCarbonContextHolder().getProperty("configUserRegistry");
            }
            case SYSTEM_CONFIGURATION: {
                return (Registry)this.getCarbonContextHolder().getProperty("configSystemRegistry");
            }
            case USER_GOVERNANCE: {
                return (Registry)this.getCarbonContextHolder().getProperty("governanceUserRegistry");
            }
            case SYSTEM_GOVERNANCE: {
                return (Registry)this.getCarbonContextHolder().getProperty("governanceSystemRegistry");
            }
            case LOCAL_REPOSITORY: {
                return (Registry)this.getCarbonContextHolder().getProperty("localRepository");
            }
        }
        return null;
    }

    public UserRealm getUserRealm() {
        return (UserRealm)this.getCarbonContextHolder().getProperty("userRealm");
    }

    public Cache getCache() {
        return CacheManager.getInstance().getCache(null);
    }

    public CarbonQueue<?> getQueue(String name) {
        return CarbonQueueManager.getInstance().getQueue(name);
    }

    public Context getJNDIContext(Hashtable properties) throws NamingException {
        return new InitialContext(properties);
    }

    public Context getJNDIContext() throws NamingException {
        return new InitialContext();
    }

    public String[] discover(URI[] scopes) {
        try {
            return CarbonContextHolder.getDiscoveryServiceProvider().probe(null, scopes, null, this.getCarbonContextHolder().getTenantId());
        }
        catch (Exception ignored) {
            return new String[0];
        }
    }
}

