/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.i18n.Messages;

public class CryptoUtil {
    private static Log log = LogFactory.getLog(CryptoUtil.class);
    private String keyAlias;
    private String keyPass;
    private ServerConfigurationService serverConfigService;
    private RegistryService registryService;
    private static CryptoUtil instance = null;

    public static CryptoUtil getDefaultCryptoUtil() {
        return CryptoUtil.getDefaultCryptoUtil(CarbonCoreDataHolder.getInstance().getServerConfigurationService(), CryptoUtil.lookupRegistryService());
    }

    public static RegistryService lookupRegistryService() {
        try {
            return CarbonCoreDataHolder.getInstance().getRegistryService();
        }
        catch (Exception e) {
            log.error((Object)("Error in getting RegistryService from CarbonCoreDataHolder: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized CryptoUtil getDefaultCryptoUtil(ServerConfigurationService serverConfigService, RegistryService registryService) {
        if (instance == null) {
            instance = new CryptoUtil(serverConfigService, registryService);
        }
        return instance;
    }

    private CryptoUtil(ServerConfigurationService serverConfigService, RegistryService registryService) {
        this.serverConfigService = serverConfigService;
        this.registryService = registryService;
        this.keyAlias = this.serverConfigService.getFirstProperty("Security.KeyStore.KeyAlias");
        this.keyPass = this.serverConfigService.getFirstProperty("Security.KeyStore.KeyPassword");
    }

    public ServerConfigurationService getServerConfigService() {
        return this.serverConfigService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public byte[] encrypt(byte[] plainTextBytes) throws CryptoException {
        try {
            KeyStoreManager keyMan = KeyStoreManager.getInstance(-1234, this.getServerConfigService(), this.getRegistryService());
            KeyStore keyStore = keyMan.getPrimaryKeyStore();
            Certificate[] certs = keyStore.getCertificateChain(this.keyAlias);
            Cipher cipher = Cipher.getInstance("RSA", "BC");
            cipher.init(1, certs[0]);
            return cipher.doFinal(plainTextBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException(Messages.getMessage((String)"erorDuringEncryption"), e);
        }
    }

    public String encryptAndBase64Encode(byte[] plainText) throws CryptoException {
        return Base64.encode((byte[])this.encrypt(plainText));
    }

    public byte[] decrypt(byte[] cipherTextBytes) throws CryptoException {
        try {
            KeyStoreManager keyMan = KeyStoreManager.getInstance(-1234, this.getServerConfigService(), this.getRegistryService());
            KeyStore keyStore = keyMan.getPrimaryKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(this.keyAlias, this.keyPass.toCharArray());
            Cipher cipher = Cipher.getInstance("RSA", "BC");
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherTextBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptoException("errorDuringDecryption", e);
        }
    }

    public byte[] base64DecodeAndDecrypt(String base64CipherText) throws CryptoException {
        return this.decrypt(Base64.decode((String)base64CipherText));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

