/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.deployment.SynchronizeRepositoryRequest;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class CarbonDeploymentSchedulerTask
extends SchedulerTask {
    private static final Log log = LogFactory.getLog(CarbonDeploymentSchedulerTask.class);
    private int tenantId;
    private String tenantDomain;
    private AxisConfiguration axisConfig;
    private boolean isInitialUpdateDone;
    private boolean isRepoUpdateFailed;

    public CarbonDeploymentSchedulerTask(RepositoryListener listener, AxisConfiguration axisConfig, int tenantId, String tenantDomain) {
        super(listener, axisConfig);
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.axisConfig = axisConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAxisDeployment() {
        CarbonDeploymentSchedulerTask carbonDeploymentSchedulerTask = this;
        synchronized (carbonDeploymentSchedulerTask) {
            super.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.tenantId);
            SuperTenantCarbonContext.getCurrentContext().setTenantDomain(this.tenantDomain);
            this.deploymentSyncUpdate();
            CarbonDeploymentSchedulerTask carbonDeploymentSchedulerTask = this;
            synchronized (carbonDeploymentSchedulerTask) {
                super.run();
            }
            boolean isRepoChanged = this.deploymentSyncCommit();
            if (isRepoChanged) {
                this.sendRepositorySyncMessage();
            }
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentSyncUpdate() {
        BundleContext bundleContext;
        ServiceReference reference;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running deployment synchronizer update...");
        }
        if ((reference = (bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext()).getServiceReference(DeploymentSynchronizer.class.getName())) != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    if (this.isInitialUpdateDone && !this.isRepoUpdateFailed) continue;
                    depsync.update(this.tenantId);
                    this.isInitialUpdateDone = true;
                    this.isRepoUpdateFailed = false;
                }
            }
            catch (Exception e) {
                log.error((Object)("Deployment synchronization update for tenant " + this.tenantId + " failed"), (Throwable)e);
            }
            finally {
                serviceTracker.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deploymentSyncCommit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running deployment synchronizer commit...");
        }
        boolean isFilesCommitted = false;
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    isFilesCommitted = depsync.commit(this.tenantId);
                    if (!isFilesCommitted) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)("Deployment synchronization commit for tenant " + this.tenantId + " failed"), (Throwable)e);
            }
            finally {
                serviceTracker.close();
            }
        }
        return isFilesCommitted;
    }

    private void sendRepositorySyncMessage() {
        ClusteringAgent clusteringAgent = CarbonCoreDataHolder.getInstance().getMainServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)new SynchronizeRepositoryRequest(this.tenantId), true);
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Retry will be attempted in 2s."), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Several retries failed"), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {}
                }
            }
        }
    }

    public void setRepoUpdateFailed() {
        this.isRepoUpdateFailed = true;
    }
}

