/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ContextListener;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.OnDemandLogger;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationContext
extends AbstractContext {
    private static final OnDemandLogger log = new OnDemandLogger(ConfigurationContext.class);
    private final ConcurrentHashMap<String, OperationContext> operationContextMap = new ConcurrentHashMap();
    private final Hashtable<String, ServiceGroupContext> serviceGroupContextMap = new Hashtable();
    private Hashtable<String, ServiceGroupContext> applicationSessionServiceGroupContexts = new Hashtable();
    private AxisConfiguration axisConfiguration;
    private ThreadFactory threadPool;
    private ListenerManager listenerManager;
    private long serviceGroupContextTimeoutInterval = 30000L;
    private String contextRoot;
    private String servicePath;
    private String cachedServicePath = null;
    protected List<ContextListener> contextListeners;
    private boolean stopped = false;

    public ConfigurationContext(AxisConfiguration axisConfiguration) {
        super(null);
        this.axisConfiguration = axisConfiguration;
        this.initConfigContextTimeout(axisConfiguration);
    }

    private void initConfigContextTimeout(AxisConfiguration axisConfiguration) {
        Object value;
        Parameter parameter = axisConfiguration.getParameter("ConfigContextTimeoutInterval");
        if (parameter != null && (value = parameter.getValue()) != null && value instanceof String) {
            this.serviceGroupContextTimeoutInterval = Integer.parseInt((String)value);
        }
    }

    public void initCluster() throws AxisFault {
        ClusteringAgent clusteringAgent = this.axisConfiguration.getClusteringAgent();
        if (clusteringAgent != null) {
            NodeManager nodeManager;
            StateManager stateManaget = clusteringAgent.getStateManager();
            if (stateManaget != null) {
                stateManaget.setConfigurationContext(this);
            }
            if ((nodeManager = clusteringAgent.getNodeManager()) != null) {
                nodeManager.setConfigurationContext(this);
            }
            if (ConfigurationContext.shouldClusterBeInitiated(clusteringAgent)) {
                clusteringAgent.setConfigurationContext(this);
                clusteringAgent.init();
            }
        }
    }

    private static boolean shouldClusterBeInitiated(ClusteringAgent clusteringAgent) {
        Parameter param = clusteringAgent.getParameter("AvoidInitiation");
        return param == null || !JavaUtils.isTrueExplicitly(param.getValue());
    }

    void contextCreated(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        Iterator<ContextListener> i$ = this.contextListeners.iterator();
        while (i$.hasNext()) {
            ContextListener contextListener;
            ContextListener listener = contextListener = i$.next();
            listener.contextCreated(context);
        }
    }

    void contextRemoved(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        Iterator<ContextListener> i$ = this.contextListeners.iterator();
        while (i$.hasNext()) {
            ContextListener contextListener;
            ContextListener listener = contextListener = i$.next();
            listener.contextRemoved(context);
        }
    }

    public void addContextListener(ContextListener contextListener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList<ContextListener>();
        }
        this.contextListeners.add(contextListener);
    }

    public void removeContextListener(ContextListener contextListener) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(contextListener);
        }
    }

    public void fillServiceContextAndServiceGroupContext(MessageContext messageContext) throws AxisFault {
        ServiceContext serviceContext = messageContext.getServiceContext();
        AxisService axisService = messageContext.getAxisService();
        if (serviceContext == null) {
            String scope = axisService.getScope();
            if ("application".equals(scope)) {
                String serviceGroupName = axisService.getAxisServiceGroup().getServiceGroupName();
                ServiceGroupContext serviceGroupContext = this.applicationSessionServiceGroupContexts.get(serviceGroupName);
                if (serviceGroupContext == null) {
                    AxisServiceGroup axisServiceGroup = messageContext.getAxisServiceGroup();
                    if (axisServiceGroup == null) {
                        axisServiceGroup = axisService.getAxisServiceGroup();
                        messageContext.setAxisServiceGroup(axisServiceGroup);
                    }
                    ConfigurationContext cfgCtx = messageContext.getConfigurationContext();
                    serviceGroupContext = cfgCtx.createServiceGroupContext(axisServiceGroup);
                    this.applicationSessionServiceGroupContexts.put(serviceGroupName, serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("soapsession".equals(scope)) {
                ServiceGroupContext serviceGroupContext;
                this.cleanupServiceGroupContexts();
                String serviceGroupContextId = messageContext.getServiceGroupContextId();
                if (serviceGroupContextId != null) {
                    serviceGroupContext = this.getServiceGroupContextFromSoapSessionTable(serviceGroupContextId, messageContext);
                } else {
                    AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                    serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                    serviceContext = serviceGroupContext.getServiceContext(axisService);
                    serviceGroupContextId = UIDGenerator.generateURNString();
                    serviceGroupContext.setId(serviceGroupContextId);
                    messageContext.setServiceGroupContextId(serviceGroupContextId);
                    this.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("request".equals(scope)) {
                AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                ServiceGroupContext serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                messageContext.setServiceGroupContext(serviceGroupContext);
                serviceContext = serviceGroupContext.getServiceContext(axisService);
                messageContext.setServiceContext(serviceContext);
            }
        }
        if (messageContext.getOperationContext() != null) {
            messageContext.getOperationContext().setParent(serviceContext);
        }
    }

    public boolean registerOperationContext(String messageID, OperationContext operationContext) {
        return this.registerOperationContext(messageID, operationContext, false);
    }

    public boolean registerOperationContext(String messageID, OperationContext mepContext, boolean override) {
        if (messageID == null) {
            if (log.isDebugEnabled()) {
                log.debug("messageID is null. Returning false");
            }
            return false;
        }
        boolean alreadyInMap = false;
        mepContext.setKey(messageID);
        if (override) {
            this.operationContextMap.put(messageID, mepContext);
        } else {
            OperationContext previous = this.operationContextMap.putIfAbsent(messageID, mepContext);
            boolean bl = alreadyInMap = previous != null;
        }
        if (log.isDebugEnabled()) {
            log.debug("registerOperationContext (" + override + "): " + mepContext + " with key: " + messageID);
            HashMap<String, MessageContext> msgContextMap = mepContext.getMessageContexts();
            for (MessageContext msgContext : msgContextMap.values()) {
                log.debug("msgContext: " + msgContext + " action: " + msgContext.getWSAAction());
            }
        }
        return !alreadyInMap || override;
    }

    public void unregisterOperationContext(String messageID) {
        if (messageID == null) {
            if (log.isDebugEnabled()) {
                log.debug("messageID is null.");
            }
        } else {
            OperationContext opCtx = this.operationContextMap.remove(messageID);
            this.contextRemoved(opCtx);
        }
    }

    public boolean isAnyOperationContextRegistered() {
        return !this.operationContextMap.isEmpty();
    }

    public void addServiceGroupContextIntoSoapSessionTable(ServiceGroupContext serviceGroupContext) {
        String id = serviceGroupContext.getId();
        this.serviceGroupContextMap.put(id, serviceGroupContext);
        serviceGroupContext.touch();
        serviceGroupContext.setParent(this);
        this.cleanupServiceGroupContexts();
    }

    public void addServiceGroupContextIntoApplicationScopeTable(ServiceGroupContext serviceGroupContext) {
        if (this.applicationSessionServiceGroupContexts == null) {
            this.applicationSessionServiceGroupContexts = new Hashtable();
        }
        this.applicationSessionServiceGroupContexts.put(serviceGroupContext.getDescription().getServiceGroupName(), serviceGroupContext);
    }

    public void deployService(AxisService service) throws AxisFault {
        this.axisConfiguration.addService(service);
        if ("application".equals(service.getScope())) {
            ServiceGroupContext sgc = this.createServiceGroupContext(service.getAxisServiceGroup());
            DependencyManager.initService(sgc);
        }
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public OperationContext getOperationContext(String messageID) {
        return this.operationContextMap.get(messageID);
    }

    public OperationContext findOperationContext(String operationName, String serviceName, String serviceGroupName) {
        if (operationName == null) {
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        for (OperationContext value : this.operationContextMap.values()) {
            if (value == null) continue;
            String valueOperationName = value.getOperationName();
            String valueServiceName = value.getServiceName();
            String valueServiceGroupName = value.getServiceGroupName();
            if (valueOperationName == null || !valueOperationName.equals(operationName) || valueServiceName == null || !valueServiceName.equals(serviceName)) continue;
            if (valueServiceGroupName != null && serviceGroupName != null && valueServiceGroupName.equals(serviceGroupName)) {
                return value;
            }
            if (valueServiceGroupName != null || serviceGroupName != null) continue;
            return value;
        }
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext(this);
        this.contextCreated(msgCtx);
        return msgCtx;
    }

    public ServiceGroupContext createServiceGroupContext(AxisServiceGroup serviceGroup) {
        ServiceGroupContext sgCtx = new ServiceGroupContext(this, serviceGroup);
        this.contextCreated(sgCtx);
        return sgCtx;
    }

    public File getRealPath(String path) {
        URL repository = this.axisConfiguration.getRepository();
        if (repository != null) {
            File repo = new File(repository.getFile());
            return new File(repo, path);
        }
        return null;
    }

    public ServiceGroupContext getServiceGroupContextFromSoapSessionTable(String serviceGroupContextId, MessageContext msgContext) throws AxisFault {
        ServiceGroupContext serviceGroupContext = this.serviceGroupContextMap.get(serviceGroupContextId);
        if (serviceGroupContext != null) {
            serviceGroupContext.touch();
            return serviceGroupContext;
        }
        throw new AxisFault("Unable to find corresponding context for the serviceGroupId: " + serviceGroupContextId);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupCtxId) {
        if (serviceGroupCtxId == null) {
            return null;
        }
        ServiceGroupContext serviceGroupContext = null;
        if (this.serviceGroupContextMap != null) {
            serviceGroupContext = this.serviceGroupContextMap.get(serviceGroupCtxId);
            if (serviceGroupContext != null) {
                serviceGroupContext.touch();
            } else {
                serviceGroupContext = this.applicationSessionServiceGroupContexts.get(serviceGroupCtxId);
                if (serviceGroupContext != null) {
                    serviceGroupContext.touch();
                }
            }
        }
        return serviceGroupContext;
    }

    public String[] getServiceGroupContextIDs() {
        String o;
        String[] ids = new String[this.serviceGroupContextMap.size() + this.applicationSessionServiceGroupContexts.size()];
        int index = 0;
        Iterator<String> i$ = this.serviceGroupContextMap.keySet().iterator();
        while (i$.hasNext()) {
            ids[index] = o = i$.next();
            ++index;
        }
        i$ = this.applicationSessionServiceGroupContexts.keySet().iterator();
        while (i$.hasNext()) {
            ids[index] = o = i$.next();
            ++index;
        }
        return ids;
    }

    public Hashtable<String, ServiceGroupContext> getServiceGroupContexts() {
        return this.serviceGroupContextMap;
    }

    public ThreadFactory getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool();
        }
        return this.threadPool;
    }

    public void setAxisConfiguration(AxisConfiguration configuration) {
        this.axisConfiguration = configuration;
    }

    public void setThreadPool(ThreadFactory pool) throws AxisFault {
        if (this.threadPool != null) {
            throw new AxisFault(Messages.getMessage("threadpoolset"));
        }
        this.threadPool = pool;
    }

    public void removeServiceGroupContext(String serviceGroupContextId) {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        ServiceGroupContext serviceGroupContext = this.serviceGroupContextMap.get(serviceGroupContextId);
        this.serviceGroupContextMap.remove(serviceGroupContextId);
        this.cleanupServiceContexts(serviceGroupContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupServiceGroupContexts() {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        long currentTime = new Date().getTime();
        Hashtable<String, ServiceGroupContext> hashtable = this.serviceGroupContextMap;
        synchronized (hashtable) {
            Iterator<String> sgCtxtMapKeyIter = this.serviceGroupContextMap.keySet().iterator();
            while (sgCtxtMapKeyIter.hasNext()) {
                String sgCtxtId = sgCtxtMapKeyIter.next();
                ServiceGroupContext serviceGroupContext = this.serviceGroupContextMap.get(sgCtxtId);
                if (currentTime - serviceGroupContext.getLastTouchedTime() <= this.getServiceGroupContextTimeoutInterval()) continue;
                sgCtxtMapKeyIter.remove();
                this.cleanupServiceContexts(serviceGroupContext);
                this.contextRemoved(serviceGroupContext);
            }
        }
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setTransportManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        if (serviceGroupContext == null) {
            return;
        }
        Iterator<ServiceContext> serviceContextIter = serviceGroupContext.getServiceContexts();
        if (serviceContextIter == null) {
            return;
        }
        while (serviceContextIter.hasNext()) {
            ServiceContext serviceContext = serviceContextIter.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void cleanupContexts() {
        ServiceGroupContext serviceGroupContext;
        ServiceGroupContext o;
        Iterator<ServiceGroupContext> i$;
        if (this.applicationSessionServiceGroupContexts != null && this.applicationSessionServiceGroupContexts.size() > 0) {
            i$ = this.applicationSessionServiceGroupContexts.values().iterator();
            while (i$.hasNext()) {
                serviceGroupContext = o = i$.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.applicationSessionServiceGroupContexts.clear();
        }
        if (this.serviceGroupContextMap != null && this.serviceGroupContextMap.size() > 0) {
            i$ = this.serviceGroupContextMap.values().iterator();
            while (i$.hasNext()) {
                serviceGroupContext = o = i$.next();
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.serviceGroupContextMap.clear();
        }
    }

    public void shutdownModulesAndServices() throws AxisFault {
        if (this.stopped) {
            if (log.isDebugEnabled()) {
                log.debug("ConfigurationContext is stopped, modules and services not being shut down");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Invoke modules shutdown.");
        }
        if (this.axisConfiguration != null) {
            HashMap<String, AxisModule> modules = this.axisConfiguration.getModules();
            if (log.isDebugEnabled()) {
                log.debug("Modules to be shutdown from axisConfiguration: " + modules);
            }
            if (modules != null) {
                for (AxisModule axisModule : modules.values()) {
                    Module module = axisModule.getModule();
                    if (module == null) continue;
                    try {
                        module.shutdown(this);
                    }
                    catch (Exception e) {
                        log.warn("Could not shutdown module " + module.getClass().getName(), e);
                    }
                }
            }
        }
        this.cleanupContexts();
        if (log.isDebugEnabled()) {
            log.debug("Invoke services shutdown.");
        }
        if (this.axisConfiguration != null) {
            for (AxisService axisService : this.axisConfiguration.getServices().values()) {
                ServiceLifeCycle serviceLifeCycle = axisService.getServiceLifeCycle();
                if (serviceLifeCycle == null) continue;
                try {
                    serviceLifeCycle.shutDown(this, axisService);
                }
                catch (Exception e) {
                    log.warn("Could not shutdown service " + axisService.getName(), e);
                }
            }
        }
        this.stopped = true;
    }

    public void terminate() throws AxisFault {
        this.shutdownModulesAndServices();
        if (this.listenerManager != null) {
            this.listenerManager.destroy();
        }
        if (this.axisConfiguration != null) {
            this.axisConfiguration.cleanup();
            this.cleanupTemp();
            this.axisConfiguration = null;
        }
    }

    private void cleanupTemp() {
        File tempFile = (File)this.axisConfiguration.getParameterValue("artifactsDIR");
        if (tempFile == null) {
            String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            tempFile = new File(property, "_axis2");
        }
        this.deleteTempFiles(tempFile);
    }

    private void deleteTempFiles(final File dir) {
        Boolean isDir = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return dir.isDirectory();
            }
        });
        if (isDir.booleanValue()) {
            String[] children = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

                @Override
                public String[] run() {
                    return dir.list();
                }
            });
            for (int i = 0; children != null && i < children.length; ++i) {
                this.deleteTempFiles(new File(dir, children[i]));
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                dir.delete();
                return null;
            }
        });
    }

    public String getServiceContextPath() {
        if (this.cachedServicePath == null) {
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
        return this.cachedServicePath;
    }

    private String internalGetServiceContextPath() {
        String ctxRoot = this.getContextRoot();
        String path = "/";
        if (ctxRoot != null) {
            if (!ctxRoot.equals("/")) {
                path = ctxRoot + "/";
            }
            if (this.servicePath == null || this.servicePath.trim().length() == 0) {
                throw new IllegalArgumentException("service path cannot be null or empty");
            }
            path = path + this.servicePath.trim();
        }
        return path;
    }

    public String getServicePath() {
        if (this.servicePath == null || this.servicePath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        return this.servicePath.trim();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getContextRoot() {
        if (this.contextRoot == null) {
            this.contextRoot = (String)this.axisConfiguration.getParameter("contextRoot").getValue();
        }
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (contextRoot != null) {
            this.contextRoot = contextRoot.trim();
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
    }

    public long getServiceGroupContextTimoutInterval() {
        return this.getServiceGroupContextTimeoutInterval();
    }

    public long getServiceGroupContextTimeoutInterval() {
        Integer serviceGroupContextTimoutIntervalParam = (Integer)this.getProperty("ConfigContextTimeoutInterval");
        if (serviceGroupContextTimoutIntervalParam != null) {
            this.serviceGroupContextTimeoutInterval = serviceGroupContextTimoutIntervalParam.intValue();
        }
        return this.serviceGroupContextTimeoutInterval;
    }

    public void removeServiceGroupContext(AxisServiceGroup serviceGroup) {
        if (serviceGroup == null) {
            return;
        }
        String groupName = serviceGroup.getServiceGroupName();
        ServiceGroupContext obj = this.applicationSessionServiceGroupContexts.get(groupName);
        if (obj != null) {
            this.applicationSessionServiceGroupContexts.remove(serviceGroup.getServiceGroupName());
            return;
        }
        ArrayList<String> toBeRemovedList = new ArrayList<String>();
        for (ServiceGroupContext serviceGroupContext : this.serviceGroupContextMap.values()) {
            if (!serviceGroupContext.getDescription().equals(serviceGroup)) continue;
            toBeRemovedList.add(serviceGroupContext.getId());
        }
        Iterator i$ = toBeRemovedList.iterator();
        while (i$.hasNext()) {
            String aToBeRemovedList;
            String s = aToBeRemovedList = (String)i$.next();
            this.serviceGroupContextMap.remove(s);
        }
    }

    @Override
    public ConfigurationContext getRootContext() {
        return this;
    }
}

