/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.module.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class TenantAuthorizationHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(TenantAuthorizationHandler.class.getClass());
    public static final String TENANT_AUTHZ_FAULT_CODE = "WSO2CarbonTenantAuthorizationFailure";
    private static Log audit = CarbonConstants.AUDIT_LOG;

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (this.callToGeneralService(msgContext)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if ("local".equals(msgContext.getIncomingTransportName())) {
            return Handler.InvocationResponse.CONTINUE;
        }
        int tenantId = SuperTenantCarbonContext.getCurrentContext((MessageContext)msgContext).getTenantId();
        if (tenantId != -1234) {
            AxisService axisService = msgContext.getAxisService();
            AxisOperation axisOperation = msgContext.getAxisOperation();
            StringBuilder message = new StringBuilder("Un-authorized access to super tenant service - ");
            message.append(axisService.getName()).append(" operation - ").append(axisOperation.getName()).append(". Tenant domain - ").append(SuperTenantCarbonContext.getCurrentContext((MessageContext)msgContext).getTenantDomain(false)).append(", tenant id - ").append(tenantId);
            audit.warn((Object)message.toString());
            String errorMsg = "Denied accessing super tenant service.";
            log.error((Object)(errorMsg + " Accessed tenant id: " + tenantId + "."));
            throw new AxisFault(errorMsg, TENANT_AUTHZ_FAULT_CODE);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean callToGeneralService(MessageContext msgContext) {
        String parameterValue;
        boolean isGeneral = true;
        AxisOperation axisOperation = msgContext.getAxisOperation();
        Parameter param = axisOperation.getParameter("superTenantService");
        if (param != null && "true".equals((parameterValue = (String)param.getValue()).trim())) {
            isGeneral = false;
        }
        return isGeneral;
    }
}

