/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class ExcelUserBulkImport {
    private static Log log = LogFactory.getLog(ExcelUserBulkImport.class);
    private BulkImportConfig config;

    public ExcelUserBulkImport(BulkImportConfig config) {
        this.config = config;
    }

    public void addUserList(UserStoreManager userStore) throws UserAdminException {
        try {
            Workbook wb = this.createWorkbook();
            Sheet sheet = wb.getSheet(wb.getSheetName(0));
            String password = this.config.getDefaultPassword();
            if (sheet == null || sheet.getLastRowNum() == -1) {
                throw new UserAdminException("The first sheet is empty");
            }
            int limit = sheet.getLastRowNum();
            boolean isDuplicate = false;
            for (int i = 1; i < limit + 1; ++i) {
                Row row = sheet.getRow(i);
                Cell cell = row.getCell(0);
                String userName = cell.getStringCellValue();
                if (!userStore.isExistingUser(userName)) {
                    userStore.addUser(userName, (Object)password, null, null, null, true);
                    continue;
                }
                isDuplicate = true;
            }
            if (isDuplicate) {
                throw new UserAdminException("Detected duplicate usernames. Failed to import duplicate users. Non-duplicate user names were successfually imported.");
            }
        }
        catch (UserAdminException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public Workbook createWorkbook() throws Throwable {
        String filename = this.config.getFileName();
        InputStream ins = this.config.getInStream();
        XSSFWorkbook wb = null;
        try {
            if (filename.endsWith(".xlsx")) {
                wb = new XSSFWorkbook(ins);
            } else {
                POIFSFileSystem fs = new POIFSFileSystem(ins);
                wb = new HSSFWorkbook(fs);
            }
        }
        catch (Exception e) {
            log.error((Object)("Bulk import failed" + e.getMessage()), (Throwable)e);
            throw new UserAdminException("Bulk import failed" + e.getMessage(), e);
        }
        return wb;
    }
}

