/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RequestHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(RequestHostObject.class);
    private static final String hostObjectName = "Request";
    private HttpServletRequest request;
    private boolean isMultipart = false;
    private boolean isParsed = false;
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private Map<String, Scriptable> fileMap = new HashMap<String, Scriptable>();
    private Scriptable parameterFields = null;
    private Scriptable fileFields = null;
    private Object content = null;
    private Context context;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        if (!(args[0] instanceof HttpServletRequest)) {
            HostObjectUtil.getReservedHostObjectWarn((String)hostObjectName);
        }
        RequestHostObject rho = new RequestHostObject();
        rho.request = (HttpServletRequest)args[0];
        rho.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)rho.request);
        rho.context = cx;
        return rho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    public static Object jsFunction_getContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContent";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        try {
            if (rho.content != null) {
                return rho.content;
            }
            String data = HostObjectUtil.streamToString((InputStream)rho.request.getInputStream());
            String contentType = rho.request.getContentType();
            rho.content = contentType != null && (contentType.equals("application/json") || contentType.equals("application/json/badgerfish")) ? cx.evaluateString(thisObj, data, "wso2js", 1, null) : data;
            return rho.content;
        }
        catch (IOException e) {
            String msg = "Error occurred while reading Servlet InputStream";
            log.warn((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
    }

    public static String jsFunction_getMethod(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getMethod";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getMethod();
    }

    public static String jsFunction_getContextPath(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContextPath";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContextPath();
    }

    public static String jsFunction_getPathTranslated(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getPathTranslated";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getPathTranslated();
    }

    public static String jsFunction_getProtocol(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getProtocol";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getProtocol();
    }

    public static String jsFunction_getQueryString(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getQueryString";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getQueryString();
    }

    public static String jsFunction_getContentType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContentType";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContentType();
    }

    public static int jsFunction_getContentLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getContentLength";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getContentLength();
    }

    public static Scriptable jsFunction_getParameterMap(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getParameterMap";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        RequestHostObject.parse(rho);
        return rho.parameterFields;
    }

    public static Scriptable jsFunction_getFileMap(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getFileMap";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        RequestHostObject.parse(rho);
        return rho.fileFields;
    }

    public static String jsFunction_getRequestURI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRequestURI";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getRequestURI();
    }

    public static String jsFunction_getRequestURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRequestURL";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        String strURL = rho.request.getRequestURL().toString();
        return strURL;
    }

    public static boolean jsFunction_isSecure(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRequestURL";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.isSecure();
    }

    public static String jsFunction_getHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getHeader";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getHeader((String)args[0]);
    }

    public static String jsFunction_getRemoteAddr(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRemoteAddr";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getRemoteAddr();
    }

    public static String jsFunction_getPathInfo(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getPathInfo";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getPathInfo();
    }

    public static String jsFunction_getLocale(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLocale";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getLocale().getLanguage();
    }

    public static int jsFunction_getLocalPort(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getLocalPort";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getLocalPort();
    }

    public static String jsFunction_getParameter(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getParameter";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String parameter = (String)args[0];
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (rho.isMultipart) {
            RequestHostObject.parse(rho);
            return rho.parameterMap.get(parameter);
        }
        return rho.request.getParameter(parameter);
    }

    public static Scriptable jsFunction_getFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getFile";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String parameter = (String)args[0];
        RequestHostObject rho = (RequestHostObject)thisObj;
        if (rho.isMultipart) {
            RequestHostObject.parse(rho);
            return rho.fileMap.get(parameter);
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    private static void parse(RequestHostObject rho) throws ScriptException {
        if (rho.isParsed) {
            return;
        }
        if (rho.isMultipart) {
            try {
                RequestHostObject.parseMultipart(rho);
            }
            catch (FileUploadException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)((Object)e));
            }
        }
        try {
            RequestHostObject.parseParameters(rho);
        }
        catch (FileUploadException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)((Object)e));
        }
    }

    private static void parseMultipart(RequestHostObject rho) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(rho.request);
        ArrayList<String> paramsNames = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Object obj : items) {
            FileItem item = (FileItem)obj;
            String name = item.getFieldName();
            if (item.isFormField()) {
                rho.parameterMap.put(name, item.getString());
                paramsNames.add(name);
                continue;
            }
            rho.fileMap.put(item.getFieldName(), rho.context.newObject((Scriptable)rho, "File", new Object[]{item}));
            fileNames.add(name);
        }
        rho.parameterFields = rho.context.newArray((Scriptable)rho, paramsNames.toArray());
        rho.fileFields = rho.context.newArray((Scriptable)rho, fileNames.toArray());
        rho.isParsed = true;
    }

    private static void parseParameters(RequestHostObject rho) throws FileUploadException {
        ArrayList<String> paramsNames = new ArrayList<String>();
        Enumeration params = rho.request.getParameterNames();
        while (params.hasMoreElements()) {
            paramsNames.add((String)params.nextElement());
        }
        rho.parameterFields = rho.context.newArray((Scriptable)rho, paramsNames.toArray());
        rho.isParsed = true;
    }

    public static Cookie[] jsFunction_getCookies(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getCookies";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RequestHostObject rho = (RequestHostObject)thisObj;
        return rho.request.getCookies();
    }
}

