/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.axiom.c14n.utils.PropLoader;

public class C14NException
extends Exception {
    public static final String baseName = "exceptions";
    protected Exception e = null;
    protected String msgID;

    public C14NException() {
        super("Missing message ID");
        this.e = null;
        this.msgID = null;
    }

    public C14NException(String msgID) {
        super(PropLoader.getExceptionProperty(msgID, baseName));
        this.e = null;
        this.msgID = msgID;
    }

    public C14NException(String msgID, Object[] exArgs) {
        super(MessageFormat.format(PropLoader.getExceptionProperty(msgID, baseName), exArgs));
        this.e = null;
        this.msgID = msgID;
    }

    public C14NException(Exception e) {
        super(e.getMessage());
        this.e = e;
        this.msgID = null;
    }

    public C14NException(String msgID, Exception e) {
        super(MessageFormat.format(PropLoader.getExceptionProperty(msgID, baseName), e.getMessage()));
        this.e = e;
        this.msgID = msgID;
    }

    public C14NException(String msgID, Object[] exArgs, Exception e) {
        super(MessageFormat.format(PropLoader.getExceptionProperty(msgID, baseName), exArgs));
        this.e = e;
        this.msgID = msgID;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = super.getLocalizedMessage();
        message = message != null ? s + ": " + message : s;
        if (this.e != null) {
            message = message + "\nOriginal Exception was " + this.e.toString();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.e != null) {
                this.e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter printwriter) {
        super.printStackTrace(printwriter);
        if (this.e != null) {
            this.e.printStackTrace(printwriter);
        }
    }

    @Override
    public void printStackTrace(PrintStream printstream) {
        super.printStackTrace(printstream);
        if (this.e != null) {
            this.e.printStackTrace(printstream);
        }
    }

    public Exception getOriginalException() {
        return this.e;
    }
}

