/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.blob;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axiom.util.blob.WritableBlob;
import org.apache.commons.io.IOUtils;

public abstract class WritableBlobTestBase
extends TestCase {
    private static final Random random = new Random();

    protected abstract WritableBlob createBlob();

    protected abstract void releaseBlob(WritableBlob var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestRandomReadWrite(int size) throws IOException {
        byte[] data = new byte[size];
        random.nextBytes(data);
        WritableBlob blob = this.createBlob();
        try {
            int c;
            int bufferOffset;
            int read;
            int offset;
            int c2;
            BlobOutputStream out = blob.getOutputStream();
            for (offset = 0; offset < data.length; offset += c2) {
                c2 = Math.min(512 + random.nextInt(1024), data.length - offset);
                out.write(data, offset, c2);
            }
            out.close();
            WritableBlobTestBase.assertEquals((long)size, (long)blob.getLength());
            InputStream in = blob.getInputStream();
            offset = 0;
            byte[] data2 = new byte[data.length];
            byte[] buffer = new byte[2048];
            while ((read = in.read(buffer, bufferOffset = random.nextInt(512), c = 512 + random.nextInt(1024))) != -1) {
                int newOffset = offset + read;
                WritableBlobTestBase.assertTrue((newOffset <= data2.length ? 1 : 0) != 0);
                System.arraycopy(buffer, bufferOffset, data2, offset, read);
                offset = newOffset;
            }
            WritableBlobTestBase.assertEquals((int)data2.length, (int)offset);
            in.close();
            WritableBlobTestBase.assertTrue((boolean)Arrays.equals(data, data2));
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    public void testRandomReadWriteLength10000() throws IOException {
        this.doTestRandomReadWrite(10000);
    }

    public void testRandomReadWriteLength100000() throws IOException {
        this.doTestRandomReadWrite(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMarkReset() throws IOException {
        byte[] sourceData1 = new byte[2000];
        byte[] sourceData2 = new byte[2000];
        random.nextBytes(sourceData1);
        random.nextBytes(sourceData2);
        WritableBlob blob = this.createBlob();
        try {
            BlobOutputStream out = blob.getOutputStream();
            out.write(sourceData1);
            out.write(sourceData2);
            out.close();
            DataInputStream in = new DataInputStream(blob.getInputStream());
            byte[] data1 = new byte[sourceData1.length];
            byte[] data2 = new byte[sourceData2.length];
            in.readFully(data1);
            in.mark(sourceData2.length);
            in.readFully(data2);
            in.reset();
            in.readFully(data2);
            WritableBlobTestBase.assertTrue((boolean)Arrays.equals(sourceData1, data1));
            WritableBlobTestBase.assertTrue((boolean)Arrays.equals(sourceData2, data2));
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFrom(int size) throws IOException {
        byte[] data = new byte[size];
        random.nextBytes(data);
        WritableBlob blob = this.createBlob();
        try {
            blob.readFrom((InputStream)new ByteArrayInputStream(data), -1L);
            InputStream in = blob.getInputStream();
            try {
                WritableBlobTestBase.assertTrue((boolean)Arrays.equals(data, IOUtils.toByteArray((InputStream)in)));
            }
            finally {
                in.close();
            }
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    public void testReadFromLength10000() throws IOException {
        this.testReadFrom(10000);
    }

    public void testReadFromLength100000() throws IOException {
        this.testReadFrom(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetOutputStreamUncommitted() throws Exception {
        WritableBlob blob = this.createBlob();
        try {
            BlobOutputStream out = blob.getOutputStream();
            try {
                try {
                    blob.getOutputStream();
                    WritableBlobTestBase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetOutputStreamCommitted() throws Exception {
        WritableBlob blob = this.createBlob();
        try {
            BlobOutputStream out = blob.getOutputStream();
            out.close();
            try {
                blob.getOutputStream();
                WritableBlobTestBase.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInputStreamNew() throws Exception {
        WritableBlob blob = this.createBlob();
        try {
            if (blob.isSupportingReadUncommitted()) {
                InputStream in = blob.getInputStream();
                BlobOutputStream out = blob.getOutputStream();
                WritableBlobTestBase.assertEquals((int)-1, (int)in.read());
                byte[] data = new byte[1000];
                random.nextBytes(data);
                out.write(data);
                WritableBlobTestBase.assertTrue((boolean)Arrays.equals(data, IOUtils.toByteArray((InputStream)in)));
                random.nextBytes(data);
                out.write(data);
                WritableBlobTestBase.assertTrue((boolean)Arrays.equals(data, IOUtils.toByteArray((InputStream)in)));
            } else {
                try {
                    blob.getInputStream();
                    WritableBlobTestBase.fail((String)"Expected IllegalStateException");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.releaseBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetInputStreamUncommitted() throws Exception {
        block12: {
            WritableBlob blob = this.createBlob();
            try {
                BlobOutputStream out = blob.getOutputStream();
                try {
                    byte[] data = new byte[1000];
                    random.nextBytes(data);
                    out.write(data);
                    if (blob.isSupportingReadUncommitted()) {
                        InputStream in = blob.getInputStream();
                        try {
                            WritableBlobTestBase.assertTrue((boolean)Arrays.equals(data, IOUtils.toByteArray((InputStream)in)));
                            break block12;
                        }
                        finally {
                            in.close();
                        }
                    }
                    try {
                        blob.getInputStream();
                        WritableBlobTestBase.fail((String)"Expected IllegalStateException");
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.releaseBlob(blob);
            }
        }
    }
}

