/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.axiom.util.UIDGenerator;

public class UIDGeneratorTest
extends TestCase {
    public void testGenerateContentIdFormat() {
        UIDGeneratorTest.assertTrue((boolean)Pattern.matches("\\w+(\\.\\w+)*@\\w+(\\.\\w+)", UIDGenerator.generateContentId()));
    }

    public void testGenerateContentIdUniqueness() {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            UIDGeneratorTest.assertTrue((boolean)values.add(UIDGenerator.generateContentId()));
        }
    }

    public void testGenerateMimeBoundaryLength() {
        UIDGeneratorTest.assertTrue((UIDGenerator.generateMimeBoundary().length() <= 70 ? 1 : 0) != 0);
    }

    public void testThreadSafety() {
        int i;
        final Set generatedIds = Collections.synchronizedSet(new HashSet());
        final AtomicInteger errorCount = new AtomicInteger(0);
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 1000; ++i) {
                        String id = UIDGenerator.generateUID();
                        if (generatedIds.add(id)) continue;
                        System.out.println("ERROR - Same UID has been generated before. UID: " + id);
                        errorCount.incrementAndGet();
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        UIDGeneratorTest.assertEquals((int)0, (int)errorCount.get());
    }
}

