/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultTestCase;

public class SOAPFaultRoleTestBase
extends SOAPFaultTestCase {
    protected SOAPFaultRole soap11FaultRole;
    protected SOAPFaultRole soap12FaultRole;
    protected SOAPFaultRole soap11FaultRoleWithParser;
    protected SOAPFaultRole soap12FaultRoleWithParser;

    public SOAPFaultRoleTestBase(OMMetaFactory omMetaFactory) {
        super(omMetaFactory);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.soap11FaultRole = this.soap11Factory.createSOAPFaultRole(this.soap11Fault);
        this.soap12FaultRole = this.soap12Factory.createSOAPFaultRole(this.soap12Fault);
        this.soap11FaultRoleWithParser = this.soap11FaultWithParser.getRole();
        this.soap12FaultRoleWithParser = this.soap12FaultWithParser.getRole();
    }

    public void testSOAP11SetRoleValue() {
        this.soap11FaultRole.setRoleValue("This is only a test");
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.1 Fault Role Test : - After calling setRoleValue method, getRoleValue method returns incorrect value", (boolean)this.soap11FaultRole.getRoleValue().trim().equals("This is only a test"));
    }

    public void testSOAP11GetRoleValue() {
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.1 Fault Role Test : - After creating SOAPFaultRole, it has a value", (boolean)this.soap11FaultRole.getRoleValue().equals(""));
        this.soap11FaultRole.setRoleValue("This is only a test");
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.1 Fault Role Test : - After calling setRoleValue method, getRoleValue method returns incorrect value", (boolean)this.soap11FaultRole.getRoleValue().trim().equals("This is only a test"));
    }

    public void testSOAP12SetRoleValue() {
        this.soap12FaultRole.setRoleValue("This is only a test");
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.2 Fault Role Test : - After calling setRoleValue method, getRoleValue method returns incorrect value", (boolean)this.soap12FaultRole.getRoleValue().trim().equals("This is only a test"));
    }

    public void testSOAP12GetRoleValue() {
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.2 Fault Role Test : - After creating SOAPFaultRole, it has a value", (boolean)this.soap12FaultRole.getRoleValue().trim().equals(""));
        this.soap12FaultRole.setRoleValue("This is only a test");
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.2 Fault Role Test : - After calling setRoleValue method, getRoleValue method returns incorrect value", (boolean)this.soap12FaultRole.getRoleValue().trim().equals("This is only a test"));
    }

    public void testSOAP11GetRoleValueWithParser() {
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.1 Fault Role Test With Parser : - getRoleValue method returns incorrect value", (boolean)this.soap11FaultRoleWithParser.getRoleValue().trim().equals("http://schemas.xmlsoap.org/soap/envelope/actor/ultimateReceiver"));
    }

    public void testSOAP12GetRoleValueWithParser() {
        SOAPFaultRoleTestBase.assertTrue((String)"SOAP 1.2 Fault Role Test With Parser : - getRoleValue method returns incorrect value", (boolean)this.soap12FaultRoleWithParser.getRoleValue().trim().equals("ultimateReceiver"));
    }
}

