/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultTestCase;

public class SOAPFaultNodeTestBase
extends SOAPFaultTestCase {
    protected SOAPFaultNode soap12FaultNode;
    protected SOAPFaultNode soap12FaultNodeWithParser;

    public SOAPFaultNodeTestBase(OMMetaFactory omMetaFactory) {
        super(omMetaFactory);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.soap12FaultNode = this.soap12Factory.createSOAPFaultNode(this.soap12Fault);
        this.soap12FaultNodeWithParser = this.soap12FaultWithParser.getNode();
    }

    public void testSOAP11SetNodeValue() {
        try {
            this.soap11Factory.createSOAPFaultNode(this.soap11Fault);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        SOAPFaultNodeTestBase.fail((String)"Unsupported SOAP 1.1 node was created");
    }

    public void testSOAP12SetNodeValue() {
        this.soap12FaultNode.setNodeValue("This is only a test");
        SOAPFaultNodeTestBase.assertTrue((String)"SOAP 1.2 Fault Node Test : - After calling setNodeValue method, getNodeValue method returns incorrect value", (boolean)this.soap12FaultNode.getNodeValue().equals("This is only a test"));
    }

    public void testSOAP12GetNodeValue() {
        SOAPFaultNodeTestBase.assertTrue((String)"SOAP 1.2 Fault Node Test : - After creating SOAPFaultNode, it has a value", (boolean)this.soap12FaultNode.getNodeValue().equals(""));
        this.soap12FaultNode.setNodeValue("This is only a test");
        SOAPFaultNodeTestBase.assertTrue((String)"SOAP 1.2 Fault Node Test : - After calling setNodeValue method, getNodeValue method returns incorrect value", (boolean)this.soap12FaultNode.getNodeValue().equals("This is only a test"));
    }

    public void testSOAP12GetNodeValueWithParser() {
        SOAPFaultNodeTestBase.assertTrue((String)"SOAP 1.2 Fault Node Test With Parser : - getNodeValue method returns incorrect value", (boolean)this.soap12FaultNodeWithParser.getNodeValue().trim().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
    }
}

