/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPHeaderBlockTestBase;

public class SOAP12HeaderBlockTestBase
extends SOAPHeaderBlockTestBase {
    public SOAP12HeaderBlockTestBase(OMMetaFactory omMetaFactory) {
        super(omMetaFactory, "http://www.w3.org/2003/05/soap-envelope");
    }

    public void testSetMustUnderstandStringTrueFalse() {
        SOAPHeaderBlock soapHeaderBlock = this.createSOAPHeaderBlock();
        soapHeaderBlock.setMustUnderstand("true");
        SOAP12HeaderBlockTestBase.assertTrue((String)"SOAP HeaderBlock Test : - After setting MustUnderstand \"true\" calling setMustUnderstand method , getMustUnderstand method returns false", (boolean)soapHeaderBlock.getMustUnderstand());
        soapHeaderBlock.setMustUnderstand("false");
        SOAP12HeaderBlockTestBase.assertFalse((String)"SOAP HeaderBlock Test : - After setting MustUnderstand \"0\" calling setMustUnderstand method , getMustUnderstand method returns true", (boolean)soapHeaderBlock.getMustUnderstand());
    }

    public void testGetRoleWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineAllHeaderBlocks();
        SOAP12HeaderBlockTestBase.assertTrue((String)"SOAP HeaderBlock Test With Parser : - getRole method returns incorrect role value", (boolean)((SOAPHeaderBlock)iterator.next()).getRole().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
    }

    public void testGetMustUnderstandWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineAllHeaderBlocks();
        SOAP12HeaderBlockTestBase.assertTrue((String)"SOAP HeaderBlock Test With Parser : - getMustUnderstand method returns incorrect value", (boolean)((SOAPHeaderBlock)iterator.next()).getMustUnderstand());
        SOAP12HeaderBlockTestBase.assertFalse((String)"SOAP HeaderBlock Test With Parser : - getMustUnderstand method returns incorrect value", (boolean)((SOAPHeaderBlock)iterator.next()).getMustUnderstand());
        ((SOAPHeaderBlock)iterator.next()).getMustUnderstand();
    }

    public void testRelayAttributeWithParser() throws Exception {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineAllHeaderBlocks();
        SOAP12HeaderBlockTestBase.assertFalse((boolean)((SOAPHeaderBlock)iterator.next()).getRelay());
        SOAP12HeaderBlockTestBase.assertTrue((boolean)((SOAPHeaderBlock)iterator.next()).getRelay());
        SOAP12HeaderBlockTestBase.assertFalse((boolean)((SOAPHeaderBlock)iterator.next()).getRelay());
    }

    public void testRelayAttribute() throws Exception {
        SOAPEnvelope env = this.soapFactory.createSOAPEnvelope();
        SOAPHeader header = this.soapFactory.createSOAPHeader(env);
        this.soapFactory.createSOAPBody(env);
        OMNamespace ns = this.soapFactory.createOMNamespace("http://ns1", "ns1");
        SOAPHeaderBlock relayHeader = header.addHeaderBlock("foo", ns);
        relayHeader.setText("hey there");
        relayHeader.setRelay(true);
        String envString = env.toString();
        SOAP12HeaderBlockTestBase.assertTrue((String)"No relay header after setRelay(true)", (envString.indexOf("relay=\"true\"") >= 0 ? 1 : 0) != 0);
    }
}

