/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPHeaderTestBase;

public class SOAP11HeaderTestBase
extends SOAPHeaderTestBase {
    public SOAP11HeaderTestBase(OMMetaFactory omMetaFactory) {
        super(omMetaFactory, "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/actor/next");
    }

    public void testExamineHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineHeaderBlocks("http://schemas.xmlsoap.org/soap/actor/next");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertEquals((String)"SOAP Header Test With Parser : - headerBlock1 localname mismatch", (String)headerBlock1.getLocalName(), (String)"From");
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 role value mismatch", (boolean)headerBlock1.getRole().equals("http://schemas.xmlsoap.org/soap/actor/next"));
        iterator.hasNext();
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock2 localname mmismatch", (boolean)headerBlock2.getLocalName().equals("MessageID"));
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock2 role value mmismatch", (boolean)headerBlock2.getRole().equals("http://schemas.xmlsoap.org/soap/actor/next"));
        SOAP11HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineHeaderBlocks(String role) method returns an iterator with more than two objects", (boolean)iterator.hasNext());
    }

    public void testExamineMustUnderstandHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineMustUnderstandHeaderBlocks("http://schemas.xmlsoap.org/soap/actor/next");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock1.getLocalName().equals("MessageID"));
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 role value mmismatch", (boolean)headerBlock1.getRole().equals("http://schemas.xmlsoap.org/soap/actor/next"));
        SOAP11HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineMustUnderstandHeaderBlocks(String role) method returns an iterator with more than one objects", (boolean)iterator.hasNext());
    }

    public void testExamineAllHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineAllHeaderBlocks();
        iterator.hasNext();
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock1.getLocalName().equals("From"));
        SOAP11HeaderTestBase.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock2.getLocalName().equals("MessageID"));
        SOAP11HeaderTestBase.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock3 = (SOAPHeaderBlock)iterator.next();
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock3.getLocalName().equals("To"));
        SOAP11HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineAllHeaderBlocks method returns an iterator with more than three objects", (boolean)iterator.hasNext());
    }

    public void testGetHeaderBlocksWithNSURIWithParser() {
        ArrayList arrayList = this.getTestMessage("message.xml").getHeader().getHeaderBlocksWithNSURI("http://example.org/ts-tests");
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - getHeaderBlocksWithNSURI returns an arrayList of incorrect size", (arrayList.size() == 1 ? 1 : 0) != 0);
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock of given namespace uri, local name mismatch", (boolean)((SOAPHeaderBlock)arrayList.get(0)).getLocalName().equals("MessageID"));
        SOAP11HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock of given namespace uri, mismatch", (boolean)((SOAPHeaderBlock)arrayList.get(0)).getNamespace().getNamespaceURI().equals("http://example.org/ts-tests"));
    }
}

