/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.jaxp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;

public class OMSourceToStreamResultTestCase
extends AbstractTestCase {
    private final OMMetaFactory omMetaFactory;
    private final TransformerFactory transformerFactory;
    private final String file;

    private OMSourceToStreamResultTestCase(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory, String name, String file) {
        super(name);
        this.omMetaFactory = omMetaFactory;
        this.transformerFactory = transformerFactory;
        this.file = file;
    }

    protected void runTest() throws Throwable {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        StAXDialect dialect = StAXDialectDetector.getDialect(inputFactory.getClass());
        inputFactory = dialect.normalize(inputFactory);
        inputFactory = dialect.enableCDataReporting(inputFactory);
        XMLStreamReader reader = inputFactory.createXMLStreamReader(OMSourceToStreamResultTestCase.getTestResource(this.file));
        StAXOMBuilder builder = new StAXOMBuilder(this.omMetaFactory.getOMFactory(), reader);
        OMSource source = new OMSource(builder.getDocumentElement());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        this.transformerFactory.newTransformer().transform((Source)source, result);
        this.assertXMLIdentical(this.compareXML(OMSourceToStreamResultTestCase.toDocumentWithoutDTD(OMSourceToStreamResultTestCase.getTestResource(this.file)), OMSourceToStreamResultTestCase.toDocumentWithoutDTD(new ByteArrayInputStream(out.toByteArray()))), true);
    }

    public static TestSuite suite(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory) throws Exception {
        TestSuite suite = new TestSuite();
        String[] files = OMSourceToStreamResultTestCase.getConformanceTestFiles();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            int idx = file.lastIndexOf(47);
            String name = file.substring(idx + 1);
            suite.addTest((Test)new OMSourceToStreamResultTestCase(omMetaFactory, transformerFactory, name, file));
        }
        return suite;
    }
}

