/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;

public class OMStAXWrapperTestBase
extends TestCase {
    protected final OMMetaFactory omMetaFactory;

    public OMStAXWrapperTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void testCDATAEvent_FromParser() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("<test><![CDATA[hello world]]></test>".getBytes());
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (InputStream)is);
        OMElement element = this.omMetaFactory.createStAXOMBuilder(this.omMetaFactory.getOMFactory(), reader).getDocumentElement();
        element.build();
        XMLStreamReader reader2 = element.getXMLStreamReader();
        int event = reader2.next();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)event);
        while (reader2.hasNext() && event != 12) {
            event = reader2.next();
        }
        if (reader.toString().indexOf("wstx") != -1) {
            OMStAXWrapperTestBase.assertEquals((int)12, (int)event);
            OMStAXWrapperTestBase.assertEquals((String)"hello world", (String)reader2.getText());
            OMStAXWrapperTestBase.assertTrue((boolean)Arrays.equals("hello world".toCharArray(), reader2.getTextCharacters()));
            OMStAXWrapperTestBase.assertEquals((int)2, (int)reader2.next());
        }
    }

    public void testCDATAEvent_FromElement() throws Exception {
        OMFactory omfactory = this.omMetaFactory.getOMFactory();
        OMElement element = omfactory.createOMElement("test", null);
        OMText cdata = omfactory.createOMText("hello world", 12);
        element.addChild((OMNode)cdata);
        XMLStreamReader reader2 = element.getXMLStreamReader();
        int event = reader2.next();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)event);
        while (reader2.hasNext() && event != 12) {
            event = reader2.next();
        }
        OMStAXWrapperTestBase.assertEquals((int)12, (int)event);
        OMStAXWrapperTestBase.assertEquals((String)"hello world", (String)reader2.getText());
        OMStAXWrapperTestBase.assertTrue((boolean)Arrays.equals("hello world".toCharArray(), reader2.getTextCharacters()));
        OMStAXWrapperTestBase.assertEquals((int)2, (int)reader2.next());
    }

    public void testCommentEvent() throws Exception {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.omMetaFactory.getOMFactory(), (String)"<a><!--comment text--></a>");
        XMLStreamReader reader = element.getXMLStreamReader();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)reader.next());
        OMStAXWrapperTestBase.assertEquals((int)5, (int)reader.next());
        OMStAXWrapperTestBase.assertEquals((String)"comment text", (String)reader.getText());
        OMStAXWrapperTestBase.assertEquals((String)"comment text", (String)new String(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength()));
        StringBuffer text = new StringBuffer();
        char[] buf = new char[5];
        int sourceStart = 0;
        while (true) {
            int nCopied = reader.getTextCharacters(sourceStart, buf, 0, buf.length);
            text.append(buf, 0, nCopied);
            if (nCopied < buf.length) break;
            sourceStart += buf.length;
        }
        OMStAXWrapperTestBase.assertEquals((String)"comment text", (String)text.toString());
        element.close(false);
    }

    public void testGetElementText() throws Exception {
        OMFactory factory = this.omMetaFactory.getOMFactory();
        OMNamespace namespace = factory.createOMNamespace("http://testuri.org", "test");
        OMElement documentElement = factory.createOMElement("DocumentElement", namespace);
        factory.createOMText((OMContainer)documentElement, "this is a TEXT");
        factory.createOMComment((OMContainer)documentElement, "this is a comment");
        factory.createOMText((OMContainer)documentElement, "this is a TEXT block 2");
        XMLStreamReader xmlStreamReader = documentElement.getXMLStreamReader();
        while (xmlStreamReader.getEventType() != 1) {
            xmlStreamReader.next();
        }
        String elementText = xmlStreamReader.getElementText();
        OMStAXWrapperTestBase.assertEquals((String)"this is a TEXTthis is a TEXT block 2", (String)elementText);
    }

    private void testNonRootElement(boolean cache) throws Exception {
        OMElement root = AXIOMUtil.stringToOM((OMFactory)this.omMetaFactory.getOMFactory(), (String)"<a><b><c/></b></a>");
        OMElement child = (OMElement)root.getFirstOMChild();
        XMLStreamReader stream = cache ? child.getXMLStreamReader() : child.getXMLStreamReaderWithoutCaching();
        OMStAXWrapperTestBase.assertEquals((int)7, (int)stream.getEventType());
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.next());
        OMStAXWrapperTestBase.assertEquals((String)"b", (String)stream.getLocalName());
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.next());
        OMStAXWrapperTestBase.assertEquals((String)"c", (String)stream.getLocalName());
        OMStAXWrapperTestBase.assertEquals((int)2, (int)stream.next());
        OMStAXWrapperTestBase.assertEquals((int)2, (int)stream.next());
        OMStAXWrapperTestBase.assertEquals((int)8, (int)stream.next());
        root.close(false);
    }

    public void testNonRootElementWithCaching() throws Exception {
        this.testNonRootElement(true);
    }

    public void testNonRootElementWithoutCaching() throws Exception {
        this.testNonRootElement(false);
    }

    public void testNextTag() throws Exception {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.omMetaFactory.getOMFactory(), (String)"<a> <b> </b> <?pi?> <!--comment--> <c/> </a>");
        XMLStreamReader stream = element.getXMLStreamReaderWithoutCaching();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.next());
        stream.nextTag();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.getEventType());
        OMStAXWrapperTestBase.assertEquals((String)"b", (String)stream.getLocalName());
        stream.nextTag();
        OMStAXWrapperTestBase.assertEquals((int)2, (int)stream.getEventType());
        stream.nextTag();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.getEventType());
        OMStAXWrapperTestBase.assertEquals((String)"c", (String)stream.getLocalName());
        element.close(false);
    }

    private void testGetNamespaceContext(boolean cache) throws Exception {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.omMetaFactory.getOMFactory(), (String)"<a xmlns='urn:ns1' xmlns:ns2='urn:ns2'><b xmlns:ns3='urn:ns3'/></a>");
        XMLStreamReader stream = cache ? element.getXMLStreamReader() : element.getXMLStreamReaderWithoutCaching();
        stream.next();
        OMStAXWrapperTestBase.assertEquals((int)1, (int)stream.next());
        OMStAXWrapperTestBase.assertEquals((String)"b", (String)stream.getLocalName());
        NamespaceContext context = stream.getNamespaceContext();
        OMStAXWrapperTestBase.assertEquals((String)"urn:ns1", (String)context.getNamespaceURI(""));
        OMStAXWrapperTestBase.assertEquals((String)"urn:ns2", (String)context.getNamespaceURI("ns2"));
        OMStAXWrapperTestBase.assertEquals((String)"urn:ns3", (String)context.getNamespaceURI("ns3"));
        OMStAXWrapperTestBase.assertEquals((String)"ns2", (String)context.getPrefix("urn:ns2"));
        element.close(false);
    }

    public void testGetNamespaceContextWithCaching() throws Exception {
        this.testGetNamespaceContext(true);
    }

    public void testGetNamespaceContextWithoutCaching() throws Exception {
        this.testGetNamespaceContext(false);
    }
}

