/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.io.CloseSensorInputStream;
import org.apache.axiom.testutils.io.CloseSensorReader;

public class OMXMLParserWrapperTestBase
extends AbstractTestCase {
    private final OMMetaFactory omMetaFactory;

    public OMXMLParserWrapperTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseWithInputStream() throws Exception {
        CloseSensorInputStream in = new CloseSensorInputStream(OMXMLParserWrapperTestBase.getTestResource("soap/test.xml"));
        try {
            OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (InputStream)in);
            builder.getDocument().build();
            builder.close();
            OMXMLParserWrapperTestBase.assertFalse((boolean)in.isClosed());
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseWithReader() throws Exception {
        CloseSensorReader in = new CloseSensorReader((Reader)new StringReader("<root><child/></root>"));
        try {
            OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (Reader)in);
            builder.getDocument().build();
            builder.close();
            OMXMLParserWrapperTestBase.assertFalse((boolean)in.isClosed());
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseWithXMLStreamReader() throws Exception {
        InputStream in = OMXMLParserWrapperTestBase.getTestResource("soap/test.xml");
        try {
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)in);
            OMXMLParserWrapper builder = this.omMetaFactory.createStAXOMBuilder(this.omMetaFactory.getOMFactory(), reader);
            WeakReference<XMLStreamReader> readerWeakRef = new WeakReference<XMLStreamReader>(reader);
            reader = null;
            builder.getDocument().build();
            builder.close();
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(500L);
                if (readerWeakRef.get() == null) {
                    return;
                }
                System.gc();
            }
            OMXMLParserWrapperTestBase.fail((String)"Builder didn't release reference to the underlying parser");
        }
        finally {
            in.close();
        }
    }
}

