/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.commons.io.input.CountingInputStream;

public class OMDocumentTestBase
extends AbstractTestCase {
    private String sampleXML = "<?xml version='1.0' encoding='utf-8'?><!--This is some comments at the start of the document--><?PITarget PIData?><Axis2>    <ProjectName>The Apache Web Sevices Project</ProjectName></Axis2>";
    private final OMMetaFactory omMetaFactory;

    public OMDocumentTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void testParse() {
        OMDocument doc = this.getSampleOMDocument(this.sampleXML);
        this.checkSampleXML(doc);
        doc.close(false);
    }

    public void testSerializeAndConsume() throws XMLStreamException {
        OMDocument omDocument = this.getSampleOMDocument(this.sampleXML);
        String outXML = "";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        omDocument.serializeAndConsume((OutputStream)outStream);
        outXML = new String(outStream.toByteArray());
        OMDocument omDocument2 = this.getSampleOMDocument(outXML);
        this.checkSampleXML(omDocument2);
        omDocument.close(false);
        omDocument2.close(false);
    }

    private void checkSampleXML(OMDocument document) {
        boolean commentFound = false;
        boolean piFound = false;
        Iterator children = document.getChildren();
        while (children.hasNext()) {
            OMNode omNode = (OMNode)children.next();
            if (omNode.getType() == 5) {
                commentFound = true;
                continue;
            }
            if (omNode.getType() == 3) {
                piFound = true;
                continue;
            }
            if (omNode.getType() != 1 || commentFound || piFound) continue;
            OMDocumentTestBase.fail((String)"OMElement should come after Comment and PI");
        }
        OMDocumentTestBase.assertTrue((commentFound && piFound ? 1 : 0) != 0);
    }

    public void testMalformedDocument() {
        OMDocument document = this.getSampleOMDocument("<Root><Child attr='a' attr='a'/></Root>");
        try {
            document.serialize((OutputStream)new ByteArrayOutputStream());
            OMDocumentTestBase.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document.close(false);
    }

    private OMDocument getSampleOMDocument(String xml) {
        return OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (Reader)new StringReader(xml)).getDocument();
    }

    public void testBuild() throws Exception {
        CountingInputStream in = new CountingInputStream(OMDocumentTestBase.getTestResource("soap/reallyReallyBigMessage.xml"));
        OMDocument doc = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (InputStream)in).getDocument();
        OMDocumentTestBase.assertFalse((boolean)doc.isComplete());
        int countBeforeBuild = in.getCount();
        doc.build();
        OMDocumentTestBase.assertTrue((boolean)doc.isComplete());
        int countAfterBuild = in.getCount();
        OMDocumentTestBase.assertTrue((countAfterBuild > countBeforeBuild ? 1 : 0) != 0);
        for (OMNode node = doc.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
        }
        OMDocumentTestBase.assertEquals((int)countAfterBuild, (int)in.getCount());
    }
}

