/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.utils.BAAInputStream;
import org.apache.axiom.attachments.utils.BAAOutputStream;

public class BAATest
extends TestCase {
    static final int INPUT_SIZE = 102400;
    static final int ITERATIONS = 10;
    static final int PRIME = 1;
    static final int BAOS_SIZE = 4096;
    byte[] input;
    ByteArrayInputStream inputBAIS;

    public BAATest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.input = new byte[102400];
        for (int i = 0; i < 102400; ++i) {
            this.input[i] = 25;
        }
        this.inputBAIS = new ByteArrayInputStream(this.input);
    }

    public void test() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.normal();
            this.enhanced();
        }
    }

    public void normal() throws Exception {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 11; ++i) {
            if (i == 1) {
                time = System.currentTimeMillis();
            }
            this.inputBAIS.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            BufferUtils.inputStream2OutputStream((InputStream)this.inputBAIS, (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos = new ByteArrayOutputStream(4096);
            BufferUtils.inputStream2OutputStream((InputStream)bais, (OutputStream)baos);
            bais = new ByteArrayInputStream(baos.toByteArray());
            baos = new ByteArrayOutputStream(4096);
            for (int j = 1; j < 1000; ++j) {
                baos.write(bais.read());
            }
            BufferUtils.inputStream2OutputStream((InputStream)bais, (OutputStream)baos);
            BAATest.assertTrue((baos.toByteArray().length == 102400 ? 1 : 0) != 0);
        }
    }

    public void enhanced() throws Exception {
        long time = System.currentTimeMillis();
        for (int i = 0; i < 11; ++i) {
            if (i == 1) {
                time = System.currentTimeMillis();
            }
            this.inputBAIS.reset();
            BAAOutputStream baaos = new BAAOutputStream();
            BufferUtils.inputStream2OutputStream((InputStream)this.inputBAIS, (OutputStream)baaos);
            BAATest.assertTrue((String)("1: " + baaos.length() + " " + 102400), (baaos.length() == 102400 ? 1 : 0) != 0);
            BAAInputStream baais = new BAAInputStream(baaos.buffers(), baaos.length());
            baaos = new BAAOutputStream();
            BufferUtils.inputStream2OutputStream((InputStream)baais, (OutputStream)baaos);
            baais = new BAAInputStream(baaos.buffers(), baaos.length());
            baaos = new BAAOutputStream();
            for (int j = 1; j < 1000; ++j) {
                baaos.write(baais.read());
            }
            BufferUtils.inputStream2OutputStream((InputStream)baais, (OutputStream)baaos);
            BAATest.assertTrue((String)("" + baaos.length() + " " + 102400), (baaos.length() == 102400 ? 1 : 0) != 0);
        }
    }
}

