/*
 Copyright (c) 2009, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.net/yui/license.txt
 version: 2.8.0r4
 */
YAHOO.util.Connect = {_msxml_progid:["Microsoft.XMLHTTP","MSXML2.XMLHTTP.3.0","MSXML2.XMLHTTP"],_http_headers:{},_has_http_headers:false,_use_default_post_header:true,_default_post_header:"application/x-www-form-urlencoded; charset=UTF-8",_default_form_header:"application/x-www-form-urlencoded",_use_default_xhr_header:true,_default_xhr_header:"XMLHttpRequest",_has_default_headers:true,_default_headers:{},_poll:{},_timeOut:{},_polling_interval:50,_transaction_id:0,startEvent:new YAHOO.util.CustomEvent("start"),completeEvent:new YAHOO.util.CustomEvent("complete"),successEvent:new YAHOO.util.CustomEvent("success"),failureEvent:new YAHOO.util.CustomEvent("failure"),abortEvent:new YAHOO.util.CustomEvent("abort"),_customEvents:{onStart:["startEvent","start"],onComplete:["completeEvent","complete"],onSuccess:["successEvent","success"],onFailure:["failureEvent","failure"],onUpload:["uploadEvent","upload"],onAbort:["abortEvent","abort"]},setProgId:function(
        A) {
    this._msxml_progid.unshift(A);
},setDefaultPostHeader:function(A) {
    if (typeof A == "string") {
        this._default_post_header = A;
    } else {
        if (typeof A == "boolean") {
            this._use_default_post_header = A;
        }
    }
},setDefaultXhrHeader:function(A) {
    if (typeof A == "string") {
        this._default_xhr_header = A;
    } else {
        this._use_default_xhr_header = A;
    }
},setPollingInterval:function(A) {
    if (typeof A == "number" && isFinite(A)) {
        this._polling_interval = A;
    }
},createXhrObject:function(F) {
    var D,A,B;
    try {
        A = new XMLHttpRequest();
        D = {conn:A,tId:F,xhr:true};
    } catch(C) {
        for (B = 0; B < this._msxml_progid.length; ++B) {
            try {
                A = new ActiveXObject(this._msxml_progid[B]);
                D = {conn:A,tId:F,xhr:true};
                break;
            } catch(E) {
            }
        }
    } finally {
        return D;
    }
},getConnectionObject:function(A) {
    var C,D = this._transaction_id;
    try {
        if (!A) {
            C = this.createXhrObject(D);
        } else {
            C = {tId:D};
            if (A === "xdr") {
                C.conn = this._transport;
                C.xdr = true;
            } else {
                if (A === "upload") {
                    C.upload = true;
                }
            }
        }
        if (C) {
            this._transaction_id++;
        }
    } catch(B) {
    }
    return C;
},asyncRequest:function(G, D, F, A) {
    var E,C,B = (F && F.argument) ? F.argument : null;
    if (this._isFileUpload) {
        C = "upload";
    } else {
        if (F.xdr) {
            C = "xdr";
        }
    }
    E = this.getConnectionObject(C);
    if (!E) {
        return null;
    } else {
        if (F && F.customevents) {
            this.initCustomEvents(E, F);
        }
        if (this._isFormSubmit) {
            if (this._isFileUpload) {
                this.uploadFile(E, F, D, A);
                return E;
            }
            if (G.toUpperCase() == "GET") {
                if (this._sFormData.length !== 0) {
                    D += ((D.indexOf("?") == -1) ? "?" : "&") + this._sFormData;
                }
            } else {
                if (G.toUpperCase() == "POST") {
                    A = A ? this._sFormData + "&" + A : this._sFormData;
                }
            }
        }
        if (G.toUpperCase() == "GET" && (F && F.cache === false)) {
            D += ((D.indexOf("?") == -1) ? "?" : "&") + "rnd=" + new Date().valueOf().toString();
        }
        if (this._use_default_xhr_header) {
            if (!this._default_headers["X-Requested-With"]) {
                this.initHeader("X-Requested-With", this._default_xhr_header, true);
            }
        }
        if ((G.toUpperCase() === "POST" && this._use_default_post_header) && this._isFormSubmit === false) {
            this.initHeader("Content-Type", this._default_post_header);
        }
        if (E.xdr) {
            this.xdr(E, G, D, F, A);
            return E;
        }
        E.conn.open(G, D, true);
        if (this._has_default_headers || this._has_http_headers) {
            this.setHeader(E);
        }
        this.handleReadyState(E, F);
        E.conn.send(A || "");
        if (this._isFormSubmit === true) {
            this.resetFormState();
        }
        this.startEvent.fire(E, B);
        if (E.startEvent) {
            E.startEvent.fire(E, B);
        }
        return E;
    }
},initCustomEvents:function(A, C) {
    var B;
    for (B in C.customevents) {
        if (this._customEvents[B][0]) {
            A[this._customEvents[B][0]] = new YAHOO.util.CustomEvent(this._customEvents[B][1], (C.scope) ? C.scope : null);
            A[this._customEvents[B][0]].subscribe(C.customevents[B]);
        }
    }
},handleReadyState:function(C, D) {
    var B = this,A = (D && D.argument) ? D.argument : null;
    if (D && D.timeout) {
        this._timeOut[C.tId] = window.setTimeout(function() {
            B.abort(C, D, true);
        }, D.timeout);
    }
    this._poll[C.tId] = window.setInterval(function() {
        if (C.conn && C.conn.readyState === 4) {
            window.clearInterval(B._poll[C.tId]);
            delete B._poll[C.tId];
            if (D && D.timeout) {
                window.clearTimeout(B._timeOut[C.tId]);
                delete B._timeOut[C.tId];
            }
            B.completeEvent.fire(C, A);
            if (C.completeEvent) {
                C.completeEvent.fire(C, A);
            }
            B.handleTransactionResponse(C, D);
        }
    }, this._polling_interval);
},handleTransactionResponse:function(B, I, D) {
    var E,A,G = (I && I.argument) ? I.argument : null,C = (B.r && B.r.statusText === "xdr:success") ? true : false,H = (B.r && B.r.statusText === "xdr:failure") ? true : false,J = D;
    try {
        if ((B.conn.status !== undefined && B.conn.status !== 0) || C) {
            E = B.conn.status;
        } else {
            if (H && !J) {
                E = 0;
            } else {
                E = 13030;
            }
        }
    } catch(F) {
        E = 13030;
    }
    if ((E >= 200 && E < 300) || E === 1223 || C) {
        A = B.xdr ? B.r : this.createResponseObject(B, G);
        if (I && I.success) {
            if (!I.scope) {
                I.success(A);
            } else {
                I.success.apply(I.scope, [A]);
            }
        }
        this.successEvent.fire(A);
        if (B.successEvent) {
            B.successEvent.fire(A);
        }
    } else {
        switch (E) {case 12002:case 12029:case 12030:case 12031:case 12152:case 13030:A = this.createExceptionObject(B.tId, G, (D ? D : false));if (I && I.failure) {
            if (!I.scope) {
                I.failure(A);
            } else {
                I.failure.apply(I.scope, [A]);
            }
        }break;default:A = (B.xdr) ? B.response : this.createResponseObject(B, G);if (I && I.failure) {
            if (!I.scope) {
                I.failure(A);
            } else {
                I.failure.apply(I.scope, [A]);
            }
        }
        }
        this.failureEvent.fire(A);
        if (B.failureEvent) {
            B.failureEvent.fire(A);
        }
    }
    this.releaseObject(B);
    A = null;
},createResponseObject:function(A, G) {
    var D = {},I = {},E,C,F,B;
    try {
        C = A.conn.getAllResponseHeaders();
        F = C.split("\n");
        for (E = 0; E < F.length; E++) {
            B = F[E].indexOf(":");
            if (B != -1) {
                I[F[E].substring(0, B)] = YAHOO.lang.trim(F[E].substring(B + 2));
            }
        }
    } catch(H) {
    }
    D.tId = A.tId;
    D.status = (A.conn.status == 1223) ? 204 : A.conn.status;
    D.statusText = (A.conn.status == 1223) ? "No Content" : A.conn.statusText;
    D.getResponseHeader = I;
    D.getAllResponseHeaders = C;
    D.responseText = A.conn.responseText;
    D.responseXML = A.conn.responseXML;
    if (G) {
        D.argument = G;
    }
    return D;
},createExceptionObject:function(H, D, A) {
    var F = 0,G = "communication failure",C = -1,B = "transaction aborted",E = {};
    E.tId = H;
    if (A) {
        E.status = C;
        E.statusText = B;
    } else {
        E.status = F;
        E.statusText = G;
    }
    if (D) {
        E.argument = D;
    }
    return E;
},initHeader:function(A, D, C) {
    var B = (C) ? this._default_headers : this._http_headers;
    B[A] = D;
    if (C) {
        this._has_default_headers = true;
    } else {
        this._has_http_headers = true;
    }
},setHeader:function(A) {
    var B;
    if (this._has_default_headers) {
        for (B in this._default_headers) {
            if (YAHOO.lang.hasOwnProperty(this._default_headers, B)) {
                A.conn.setRequestHeader(B, this._default_headers[B]);
            }
        }
    }
    if (this._has_http_headers) {
        for (B in this._http_headers) {
            if (YAHOO.lang.hasOwnProperty(this._http_headers, B)) {
                A.conn.setRequestHeader(B, this._http_headers[B]);
            }
        }
        this._http_headers = {};
        this._has_http_headers = false;
    }
},resetDefaultHeaders:function() {
    this._default_headers = {};
    this._has_default_headers = false;
},abort:function(E, G, A) {
    var D,B = (G && G.argument) ? G.argument : null;
    E = E || {};
    if (E.conn) {
        if (E.xhr) {
            if (this.isCallInProgress(E)) {
                E.conn.abort();
                window.clearInterval(this._poll[E.tId]);
                delete this._poll[E.tId];
                if (A) {
                    window.clearTimeout(this._timeOut[E.tId]);
                    delete this._timeOut[E.tId];
                }
                D = true;
            }
        } else {
            if (E.xdr) {
                E.conn.abort(E.tId);
                D = true;
            }
        }
    } else {
        if (E.upload) {
            var C = "yuiIO" + E.tId;
            var F = document.getElementById(C);
            if (F) {
                YAHOO.util.Event.removeListener(F, "load");
                document.body.removeChild(F);
                if (A) {
                    window.clearTimeout(this._timeOut[E.tId]);
                    delete this._timeOut[E.tId];
                }
                D = true;
            }
        } else {
            D = false;
        }
    }
    if (D === true) {
        this.abortEvent.fire(E, B);
        if (E.abortEvent) {
            E.abortEvent.fire(E, B);
        }
        this.handleTransactionResponse(E, G, true);
    }
    return D;
},isCallInProgress:function(A) {
    A = A || {};
    if (A.xhr && A.conn) {
        return A.conn.readyState !== 4 && A.conn.readyState !== 0;
    } else {
        if (A.xdr && A.conn) {
            return A.conn.isCallInProgress(A.tId);
        } else {
            if (A.upload === true) {
                return document.getElementById("yuiIO" + A.tId) ? true : false;
            } else {
                return false;
            }
        }
    }
},releaseObject:function(A) {
    if (A && A.conn) {
        A.conn = null;
        A = null;
    }
}};
(function() {
    var G = YAHOO.util.Connect,H = {};

    function D(I) {
        var J = '<object id="YUIConnectionSwf" type="application/x-shockwave-flash" data="' + I + '" width="0" height="0">' + '<param name="movie" value="' + I + '">' + '<param name="allowScriptAccess" value="always">' + "</object>",K = document.createElement("div");
        document.body.appendChild(K);
        K.innerHTML = J;
    }

    function B(L, I, J, M, K) {
        H[parseInt(L.tId)] = {"o":L,"c":M};
        if (K) {
            M.method = I;
            M.data = K;
        }
        L.conn.send(J, M, L.tId);
    }

    function E(I) {
        D(I);
        G._transport = document.getElementById("YUIConnectionSwf");
    }

    function C() {
        G.xdrReadyEvent.fire();
    }

    function A(J, I) {
        if (J) {
            G.startEvent.fire(J, I.argument);
            if (J.startEvent) {
                J.startEvent.fire(J, I.argument);
            }
        }
    }

    function F(J) {
        var K = H[J.tId].o,I = H[J.tId].c;
        if (J.statusText === "xdr:start") {
            A(K, I);
            return;
        }
        J.responseText = decodeURI(J.responseText);
        K.r = J;
        if (I.argument) {
            K.r.argument = I.argument;
        }
        this.handleTransactionResponse(K, I, J.statusText === "xdr:abort" ? true : false);
        delete H[J.tId];
    }

    G.xdr = B;
    G.swf = D;
    G.transport = E;
    G.xdrReadyEvent = new YAHOO.util.CustomEvent("xdrReady");
    G.xdrReady = C;
    G.handleXdrResponse = F;
})();
(function() {
    var D = YAHOO.util.Connect,F = YAHOO.util.Event;
    D._isFormSubmit = false;
    D._isFileUpload = false;
    D._formNode = null;
    D._sFormData = null;
    D._submitElementValue = null;
    D.uploadEvent = new YAHOO.util.CustomEvent("upload"),D._hasSubmitListener = function() {
        if (F) {
            F.addListener(document, "click", function(J) {
                var I = F.getTarget(J),H = I.nodeName.toLowerCase();
                if ((H === "input" || H === "button") && (I.type && I.type.toLowerCase() == "submit")) {
                    D._submitElementValue = encodeURIComponent(I.name) + "=" + encodeURIComponent(I.value);
                }
            });
            return true;
        }
        return false;
    }();
    function G(T, O, J) {
        var S,I,R,P,W,Q = false,M = [],V = 0,L,N,K,U,H;
        this.resetFormState();
        if (typeof T == "string") {
            S = (document.getElementById(T) || document.forms[T]);
        } else {
            if (typeof T == "object") {
                S = T;
            } else {
                return;
            }
        }
        if (O) {
            this.createFrame(J ? J : null);
            this._isFormSubmit = true;
            this._isFileUpload = true;
            this._formNode = S;
            return;
        }
        for (L = 0,N = S.elements.length; L < N; ++L) {
            I = S.elements[L];
            W = I.disabled;
            R = I.name;
            if (!W && R) {
                R = encodeURIComponent(R) + "=";
                P = encodeURIComponent(I.value);
                switch (I.type) {case"select-one":if (I.selectedIndex > -1) {
                    H = I.options[I.selectedIndex];
                    M[V++] = R + encodeURIComponent((H.attributes.value && H.attributes.value.specified) ? H.value : H.text);
                }break;case"select-multiple":if (I.selectedIndex > -1) {
                    for (K = I.selectedIndex,U = I.options.length; K < U; ++K) {
                        H = I.options[K];
                        if (H.selected) {
                            M[V++] = R + encodeURIComponent((H.attributes.value && H.attributes.value.specified) ? H.value : H.text);
                        }
                    }
                }break;case"radio":case"checkbox":if (I.checked) {
                    M[V++] = R + P;
                }break;case"file":case undefined:case"reset":case"button":break;case"submit":if (Q === false) {
                    if (this._hasSubmitListener && this._submitElementValue) {
                        M[V++] = this._submitElementValue;
                    }
                    Q = true;
                }break;default:M[V++] = R + P;
                }
            }
        }
        this._isFormSubmit = true;
        this._sFormData = M.join("&");
        this.initHeader("Content-Type", this._default_form_header);
        return this._sFormData;
    }

    function C() {
        this._isFormSubmit = false;
        this._isFileUpload = false;
        this._formNode = null;
        this._sFormData = "";
    }

    function B(H) {
        var I = "yuiIO" + this._transaction_id,J;
        if (YAHOO.env.ua.ie) {
            J = document.createElement('<iframe id="' + I + '" name="' + I + '" />');
            if (typeof H == "boolean") {
                J.src = "javascript:false";
            }
        } else {
            J = document.createElement("iframe");
            J.id = I;
            J.name = I;
        }
        J.style.position = "absolute";
        J.style.top = "-1000px";
        J.style.left = "-1000px";
        document.body.appendChild(J);
    }

    function E(H) {
        var K = [],I = H.split("&"),J,L;
        for (J = 0; J < I.length; J++) {
            L = I[J].indexOf("=");
            if (L != -1) {
                K[J] = document.createElement("input");
                K[J].type = "hidden";
                K[J].name = decodeURIComponent(I[J].substring(0, L));
                K[J].value = decodeURIComponent(I[J].substring(L + 1));
                this._formNode.appendChild(K[J]);
            }
        }
        return K;
    }

    function A(K, V, L, J) {
        var Q = "yuiIO" + K.tId,R = "multipart/form-data",T = document.getElementById(Q),M = (document.documentMode && document.documentMode === 8) ? true : false,W = this,S = (V && V.argument) ? V.argument : null,U,P,I,O,H,N;
        H = {action:this._formNode.getAttribute("action"),method:this._formNode.getAttribute("method"),target:this._formNode.getAttribute("target")};
        this._formNode.setAttribute("action", L);
        this._formNode.setAttribute("method", "POST");
        this._formNode.setAttribute("target", Q);
        if (YAHOO.env.ua.ie && !M) {
            this._formNode.setAttribute("encoding", R);
        } else {
            this._formNode.setAttribute("enctype", R);
        }
        if (J) {
            U = this.appendPostData(J);
        }
        this._formNode.submit();
        this.startEvent.fire(K, S);
        if (K.startEvent) {
            K.startEvent.fire(K, S);
        }
        if (V && V.timeout) {
            this._timeOut[K.tId] = window.setTimeout(function() {
                W.abort(K, V, true);
            }, V.timeout);
        }
        if (U && U.length > 0) {
            for (P = 0; P < U.length; P++) {
                this._formNode.removeChild(U[P]);
            }
        }
        for (I in H) {
            if (YAHOO.lang.hasOwnProperty(H, I)) {
                if (H[I]) {
                    this._formNode.setAttribute(I, H[I]);
                } else {
                    this._formNode.removeAttribute(I);
                }
            }
        }
        this.resetFormState();
        N = function() {
            if (V && V.timeout) {
                window.clearTimeout(W._timeOut[K.tId]);
                delete W._timeOut[K.tId];
            }
            W.completeEvent.fire(K, S);
            if (K.completeEvent) {
                K.completeEvent.fire(K, S);
            }
            O = {tId:K.tId,argument:V.argument};
            try {
                O.responseText = T.contentWindow.document.body ? T.contentWindow.document.body.innerHTML : T.contentWindow.document.documentElement.textContent;
                O.responseXML = T.contentWindow.document.XMLDocument ? T.contentWindow.document.XMLDocument : T.contentWindow.document;
            } catch(X) {
            }
            if (V && V.upload) {
                if (!V.scope) {
                    V.upload(O);
                } else {
                    V.upload.apply(V.scope, [O]);
                }
            }
            W.uploadEvent.fire(O);
            if (K.uploadEvent) {
                K.uploadEvent.fire(O);
            }
            F.removeListener(T, "load", N);
            setTimeout(function() {
                document.body.removeChild(T);
                W.releaseObject(K);
            }, 100);
        };
        F.addListener(T, "load", N);
    }

    D.setForm = G;
    D.resetFormState = C;
    D.createFrame = B;
    D.appendPostData = E;
    D.uploadFile = A;
})();
YAHOO.register("connection", YAHOO.util.Connect, {version:"2.8.0r4",build:"2449"});