/*
 * Decompiled with CFR 0.152.
 */
package com.acme.shoppingcart.portal;

import com.acme.shoppingcart.portal.PortalUtils;
import com.acme.shoppingcart.portal.product.DataServiceFaultException;
import com.acme.shoppingcart.portal.product.ProductServiceStub;
import com.acme.shoppingcart.portal.product.types.Category;
import com.acme.shoppingcart.portal.product.types.Product;
import java.rmi.RemoteException;
import javax.activation.DataHandler;

public class ProductsClient {
    private ProductServiceStub stub;

    public ProductsClient() {
        try {
            this.stub = new ProductServiceStub(PortalUtils.getEndpoint((String)"products.proxy.service"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Product[] listProducts(String category) {
        try {
            Product[] products;
            for (Product product : products = this.stub.getProductsOfCategory(category)) {
                PortalUtils.addImage((String)product.getProductCode(), (DataHandler)product.getImage());
            }
            return products;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Category[] listProductCategories() {
        try {
            return this.stub.getAllCategories();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Product getProduct(String productCode) {
        try {
            Product product = this.stub.getProductByCode(productCode)[0];
            PortalUtils.addImage((String)product.getProductCode(), (DataHandler)product.getImage());
            return product;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (DataServiceFaultException e) {
            e.printStackTrace();
        }
        return null;
    }
}

