/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.io.File;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.wso2.wsf.ide.consumption.core.utils.ContentCopyUtils;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.messages.WSASCreationUIMessages;

public class WSASWebservicesServerCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private int scenario;

    public WSASWebservicesServerCommand(DataModel model, int scenario) {
        this.model = model;
        this.scenario = scenario;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        IStatusHandler statusHandler = environment.getStatusHandler();
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
        String webContainerDirString = FileUtils.addAnotherNodeToPath((String)currentDynamicWebProjectDir, (String)WSASCreationUIMessages.DIR_WEBCONTENT);
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
        if (this.model.getServerStatus()) {
            if (this.scenario == 0) {
                String webserviceTempDirString = this.model.getPathToWebServicesTempDir();
                String repositoryString = webContainerDirString + File.separator + WSASCreationUIMessages.DIR_WEB_INF + File.separator + WSASCreationUIMessages.DIR_SERVICES;
                status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(webserviceTempDirString, repositoryString, monitor, statusHandler);
                FileUtils.deleteDirectories((String)webserviceTempDirString);
            } else if (this.scenario == 1) {
                String webserviceTempDirString = this.model.getPathToWebServicesTempDir();
                String repositoryString = webContainerDirString + File.separator + WSASCreationUIMessages.DIR_WEB_INF + File.separator + WSASCreationUIMessages.DIR_SERVICES;
                status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(webserviceTempDirString, repositoryString, monitor, statusHandler);
                FileUtils.deleteDirectories((String)webserviceTempDirString);
            }
            status = Status.OK_STATUS;
        } else {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }
}

