/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.messages.WSASCreationUIMessages;

public class WSASTDServiceCreationCommand
extends AbstractDataModelOperation {
    private DataModel model;

    public WSASTDServiceCreationCommand(DataModel model, IWebService ws, String project) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        try {
            String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
            String matadataDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)WSASCreationUIMessages.DIR_DOT_METADATA);
            String matadataPluginsDir = FileUtils.addAnotherNodeToPath((String)matadataDir, (String)WSASCreationUIMessages.DIR_DOT_PLUGINS);
            String matadataWSASDir = FileUtils.addAnotherNodeToPath((String)matadataPluginsDir, (String)WSASCreationUIMessages.WSAS_PROJECT);
            String tempServicesDir = FileUtils.addAnotherNodeToPath((String)matadataWSASDir, (String)WSASCreationUIMessages.DIR_SERVICES);
            this.model.setPathToWebServicesTempDir(tempServicesDir);
            String currentservicesDirectory = FileUtils.addAnotherNodeToPath((String)tempServicesDir, (String)this.model.getServiceName());
            String metaInfDirectory = FileUtils.addAnotherNodeToPath((String)currentservicesDirectory, (String)WSASCreationUIMessages.DIR_META_INF);
            FileUtils.createDirectorys((String)currentservicesDirectory);
            FileUtils.createDirectorys((String)metaInfDirectory);
            String currentProjectResourcesDirString = FileUtils.addAnotherNodeToPath((String)currentDynamicWebProjectDir, (String)WSASCreationUIMessages.DIR_RESOURCES);
            File currentProjectResourcesDir = new File(currentProjectResourcesDirString);
            if (!currentProjectResourcesDir.exists()) {
                currentProjectResourcesDir.mkdir();
            }
            FileUtils.copyDirectory((File)currentProjectResourcesDir, (File)new File(metaInfDirectory));
            String defaultClassesSubDirectory = WSASCreationUIMessages.DIR_BUILD + File.separator + WSASCreationUIMessages.DIR_CLASSES;
            String classesDirectory = currentDynamicWebProjectDir + File.separator + defaultClassesSubDirectory;
            FileUtils.copyDirectory((File)new File(classesDirectory), (File)new File(currentservicesDirectory));
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCreationUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCreationUIMessages.ERROR_INVALID_SERVICE_CREATION, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

