/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.net.MalformedURLException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.messages.WSASCreationUIMessages;
import org.wso2.wsf.ide.creation.core.utils.CommonUtils;

public class WSASSkelImplCommand
extends AbstractDataModelOperation {
    private WebServiceInfo webServiceInfo;
    private DataModel model;

    public WSASSkelImplCommand(WebServiceInfo webServiceInfo, DataModel model) {
        this.webServiceInfo = webServiceInfo;
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
        String projectSrcDir = FileUtils.addAnotherNodeToPath((String)currentDynamicWebProjectDir, (String)WSASCreationUIMessages.DIR_SRC);
        String packagePath = CommonUtils.packgeName2PathName(this.model.getPackageText());
        String packageDir = FileUtils.addAnotherNodeToPath((String)projectSrcDir, (String)packagePath);
        String serviceSkeletonImpl = FileUtils.addAnotherNodeToPath((String)packageDir, (String)this.model.getServiceName());
        String serviceSkeletonImplURL = serviceSkeletonImpl + WSASCreationUIMessages.SKELETON_SUFFIX;
        Path serviceSkeletonImplURLPath = new Path(serviceSkeletonImplURL);
        try {
            String serviceSkeletonImplURLString = serviceSkeletonImplURLPath.toFile().toURL().toString();
            this.webServiceInfo.setImplURL(serviceSkeletonImplURLString);
            String[] implURLArray = new String[]{serviceSkeletonImplURLString};
            this.webServiceInfo.setImplURLs(implURLArray);
        }
        catch (MalformedURLException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCreationUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

