/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.wso2.wsf.ide.core.plugin.data.ServerModel;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.WSASCoreUtils;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.utils.CommonUtils;

public class WSASServiceInstallCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IWebService ws;
    private int scenario;

    public WSASServiceInstallCommand(DataModel model, IWebService ws, String project, int scenario) {
        this.model = model;
        this.ws = ws;
        this.scenario = scenario;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(WSASCoreUtils.tempWSASWebappFileLocation()));
            String wsasHomeLocation = null;
            if (properties.containsKey(WSASCoreUIMessages.PROPERTY_KEY_PATH)) {
                wsasHomeLocation = ServerModel.getWsasServerPath() != null ? ServerModel.getWsasServerPath() : properties.getProperty(WSASCoreUIMessages.PROPERTY_KEY_PATH);
            }
            String serviceName = null;
            if (this.scenario == 0) {
                serviceName = CommonUtils.classNameFromQualifiedName(this.ws.getWebServiceInfo().getImplURL());
            } else if (this.scenario == 1) {
                serviceName = this.model.getServiceName();
            }
            String[] repoNodes = new String[]{"repository", "services", serviceName};
            String wsasRepoLocationOfService = FileUtils.addNodesToPath((String)wsasHomeLocation, (String[])repoNodes);
            File wsasRepoLocationOfServiceFile = new File(wsasRepoLocationOfService);
            if (!wsasRepoLocationOfServiceFile.exists()) {
                FileUtils.createDirectorys((String)wsasRepoLocationOfService);
            }
            String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
            String[] newNodes = new String[]{"WebContent", "WEB-INF", "services", serviceName};
            String servicesDirectory = FileUtils.addNodesToPath((String)currentDynamicWebProjectDir, (String[])newNodes);
            FileUtils.copyDirectory((File)new File(servicesDirectory), (File)new File(wsasRepoLocationOfService));
        }
        catch (IOException e) {
            // empty catch block
        }
        return status;
    }
}

