/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsf.ide.creation.core.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.wso2.wsf.ide.core.plugin.messages.WSASCoreUIMessages;
import org.wso2.wsf.ide.core.utils.FileUtils;
import org.wso2.wsf.ide.core.utils.ServiceImplFilterUtil;
import org.wso2.wsf.ide.creation.core.data.DataModel;
import org.wso2.wsf.ide.creation.core.messages.WSASCreationUIMessages;
import org.wso2.wsf.ide.creation.core.utils.CommonUtils;
import org.wso2.wsf.ide.creation.core.utils.ServiceXMLCreator;

public class WSASBUServiceCreationCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IWebService ws;
    private Map<String, String[]> serviceIncludeClassList = new HashMap<String, String[]>();

    public WSASBUServiceCreationCommand(DataModel model, IWebService ws, String project) {
        this.model = model;
        this.ws = ws;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        String serviceClass = this.ws.getWebServiceInfo().getImplURL();
        try {
            String[] includeLibList;
            File serviceXMLFile;
            String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
            String matadataDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)WSASCreationUIMessages.DIR_DOT_METADATA);
            String matadataPluginsDir = FileUtils.addAnotherNodeToPath((String)matadataDir, (String)WSASCreationUIMessages.DIR_DOT_PLUGINS);
            String matadataWSASDir = FileUtils.addAnotherNodeToPath((String)matadataPluginsDir, (String)WSASCreationUIMessages.WSAS_PROJECT);
            String webservicesDir = FileUtils.addAnotherNodeToPath((String)matadataWSASDir, (String)WSASCreationUIMessages.DIR_WEBSERVICES);
            this.model.setPathToWebServicesTempDir(webservicesDir);
            String serviceName = CommonUtils.classNameFromQualifiedName(serviceClass);
            String servicesDirectory = FileUtils.addAnotherNodeToPath((String)webservicesDir, (String)serviceName);
            String serviceXMLDirectory = FileUtils.addAnotherNodeToPath((String)servicesDirectory, (String)WSASCreationUIMessages.DIR_META_INF);
            FileUtils.createDirectorys((String)servicesDirectory);
            FileUtils.createDirectorys((String)serviceXMLDirectory);
            if (this.model.isGenerateServicesXML()) {
                ServiceXMLCreator serviceXMLCreator = new ServiceXMLCreator(serviceName, serviceClass, null);
                serviceXMLFile = new File(serviceXMLDirectory + File.separator + WSASCreationUIMessages.FILE_SERVICES_XML);
                FileWriter serviceXMLFileWriter = new FileWriter(serviceXMLFile, false);
                BufferedWriter writer = new BufferedWriter(serviceXMLFileWriter);
                writer.write(serviceXMLCreator.toString());
                writer.close();
            } else {
                String pathToServicesXML = this.model.getPathToServicesXML();
                if (pathToServicesXML == null) {
                    status = StatusUtils.errorStatus((String)WSASCreationUIMessages.ERROR_INVALID_SERVICES_XML);
                    environment.getStatusHandler().reportError(status);
                } else {
                    serviceXMLFile = new File(pathToServicesXML);
                    File targetServicesXMLFile = new File(serviceXMLDirectory + File.separator + WSASCreationUIMessages.FILE_SERVICES_XML);
                    FileUtils.copy((File)serviceXMLFile, (File)targetServicesXMLFile);
                }
            }
            String defaultClassesSubDirectory = WSASCreationUIMessages.DIR_BUILD + File.separator + WSASCreationUIMessages.DIR_CLASSES;
            String classesDirectory = currentDynamicWebProjectDir + File.separator + defaultClassesSubDirectory;
            File[] matchingPossibleServiceFiles = ServiceImplFilterUtil.getMatchingFiles((String)classesDirectory, (String)serviceName, (String)".class");
            if (this.model.isIncludeExtLibs() && (includeLibList = this.model.getExternalLibFileSet()) != null) {
                for (int i = 0; i < includeLibList.length; ++i) {
                    Path serviceLibDirectory = new Path(servicesDirectory);
                    File serviceLibDir = new File((serviceLibDirectory = serviceLibDirectory.append(WSASCoreUIMessages.DIR_LIB)).toOSString());
                    if (!serviceLibDir.exists()) {
                        serviceLibDir.mkdirs();
                    }
                    File actualJARFile = new File(includeLibList[i]);
                    Path newLibFile = new Path(serviceLibDir.getAbsolutePath());
                    newLibFile = newLibFile.append(actualJARFile.getName());
                    File newJARFile = new File(newLibFile.toOSString());
                    newJARFile.createNewFile();
                    FileUtils.copy((File)actualJARFile, (File)newJARFile);
                }
            }
            String classFileDestination = null;
            String mainPackage = null;
            String packageString = null;
            for (int i = 0; i < matchingPossibleServiceFiles.length; ++i) {
                if (!matchingPossibleServiceFiles[i].getName().toString().equals(serviceName + ".class")) continue;
                String[] result = new String[2];
                if (matchingPossibleServiceFiles[i].getAbsolutePath().contains("\\")) {
                    result[0] = matchingPossibleServiceFiles[i].getAbsolutePath().substring(classesDirectory.length());
                    packageString = result[0];
                } else {
                    result = matchingPossibleServiceFiles[i].getAbsolutePath().split(classesDirectory);
                    packageString = result[1];
                }
                classFileDestination = FileUtils.addAnotherNodeToPath((String)servicesDirectory, (String)packageString);
                String[] packageDestination = classFileDestination.split(serviceName + ".class");
                mainPackage = packageDestination[0];
                this.serviceIncludeClassList.put(serviceName, new String[]{mainPackage, matchingPossibleServiceFiles[i].getAbsolutePath()});
                break;
            }
            Path servicePacakeDirLocation = new Path(classesDirectory);
            servicePacakeDirLocation = servicePacakeDirLocation.append(packageString);
            String[] servicePacakeDir = servicePacakeDirLocation.toOSString().split(serviceName + ".class");
            File[] matchingPossibleRelatedFiles = ServiceImplFilterUtil.getMatchingFiles((String)servicePacakeDir[0], null, (String)".class");
            for (int i = 0; i < matchingPossibleRelatedFiles.length; ++i) {
                if (matchingPossibleRelatedFiles[i].getName().toString().equals(serviceName + ".class")) continue;
                this.serviceIncludeClassList.put(matchingPossibleRelatedFiles[i].getName(), new String[]{mainPackage, matchingPossibleRelatedFiles[i].getAbsolutePath()});
            }
            if (!this.serviceIncludeClassList.isEmpty()) {
                for (Map.Entry<String, String[]> pairs : this.serviceIncludeClassList.entrySet()) {
                    String[] value = pairs.getValue();
                    String PackageNewLocation = value[0].toString();
                    Path classFileNewLocation = new Path(PackageNewLocation);
                    File newClassFile = new File((classFileNewLocation = classFileNewLocation.append(pairs.getKey().toString().endsWith(".class") ? pairs.getKey().toString() : pairs.getKey().toString() + ".class")).toOSString());
                    if (newClassFile.exists()) continue;
                    new File(PackageNewLocation).mkdirs();
                    newClassFile.createNewFile();
                    FileUtils.copy((File)new File(value[1].toString()), (File)newClassFile);
                }
            }
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCreationUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)WSASCreationUIMessages.ERROR_INVALID_SERVICE_CREATION, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

