/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.menu.stratos;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.stratos.common.config.CloudServiceConfig;
import org.wso2.carbon.stratos.common.config.CloudServiceConfigParser;
import org.wso2.carbon.stratos.common.exception.StratosException;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);
    private static String managerHomepageURL = "https://stratoslive.wso2.com";
    private static final String STRATOS_MANAGER = "WSO2 Stratos Manager";

    public static void readManagerURLFromConfig() throws StratosException {
        try {
            Map cloudServiceConfigs = CloudServiceConfigParser.loadCloudServicesConfiguration().getCloudServiceConfigs();
            managerHomepageURL = ((CloudServiceConfig)cloudServiceConfigs.get(STRATOS_MANAGER)).getLink() + "/carbon/sso-acs/redirect_ajaxprocessor.jsp";
        }
        catch (Exception e) {
            String errorMsg = "Error while reading the Manager Homepage URL from cloud service configuration.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new StratosException(errorMsg, (Throwable)e);
        }
    }

    public static String getManagerHomepageURL() {
        return managerHomepageURL;
    }

    private static String getTextValue(Element element, String tagName) {
        String textVal = null;
        NodeList nl = element.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }
}

