/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.generic.ui.utils.GenericUIGenerator;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.resource.stub.beans.xsd.CollectionContentBean;
import org.wso2.carbon.registry.resource.ui.Utils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.deployment.ComponentBuilder;
import org.wso2.carbon.ui.deployment.beans.Component;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class GenericUtil {
    private static final Log log = LogFactory.getLog(GenericUtil.class);
    private static final String DEFAULT_LIFECYCLE_GENERATOR_CLASS = "org.wso2.carbon.governance.generic.ui.utils.LifecycleListPopulator";

    public static void buildMenuItems(HttpServletRequest request, String s, String s1, String s2) {
        int menuOrder = 50;
        if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
            HttpSession session = request.getSession();
            String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
            try {
                WSRegistryServiceClient registry = new WSRegistryServiceClient(s2, cookie);
                List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry);
                LinkedHashMap customAddUIMap = new LinkedHashMap();
                LinkedHashMap customViewUIMap = new LinkedHashMap();
                LinkedList userCustomMenuItemsList = new LinkedList();
                for (GovernanceArtifactConfiguration configuration : configurations) {
                    Component component = new Component();
                    OMElement uiConfigurations = configuration.getUIConfigurations();
                    String key = configuration.getKey();
                    String configurationPath = "/_system/config/repository/components/org.wso2.carbon.governance/configuration/";
                    String layoutStoragePath = configurationPath + key;
                    RealmService realmService = registry.getRegistryContext().getRealmService();
                    if (!realmService.getTenantUserRealm(realmService.getTenantManager().getTenantId(s1)).getAuthorizationManager().isUserAuthorized(s, configurationPath, "http://www.wso2.org/projects/registry/actions/add") && !registry.resourceExists(layoutStoragePath)) continue;
                    List menuList = component.getMenusList();
                    if (uiConfigurations != null) {
                        ComponentBuilder.processMenus((String)"artifactType", (OMElement)uiConfigurations, (Component)component);
                        ComponentBuilder.processCustomUIs((OMElement)uiConfigurations, (Component)component);
                    }
                    if (menuList.size() == 0) {
                        menuOrder = GenericUtil.buildMenuList(request, configuration, menuList, key, menuOrder);
                    }
                    userCustomMenuItemsList.addAll(menuList);
                    customAddUIMap.putAll(component.getCustomAddUIMap());
                    Map viewUIMap = component.getCustomViewUIMap();
                    if (viewUIMap.isEmpty()) {
                        GenericUtil.buildViewUI(configuration, viewUIMap, key);
                    }
                    customViewUIMap.putAll(viewUIMap);
                    OMElement layout = configuration.getContentDefinition();
                    if (layout == null || registry.resourceExists(layoutStoragePath)) continue;
                    Resource resource = registry.newResource();
                    resource.setContent((Object)RegistryUtils.encodeString((String)layout.toString()));
                    resource.setMediaType("application/xml");
                    registry.put(layoutStoragePath, resource);
                }
                session.setAttribute("UserCustomMenuItems", (Object)userCustomMenuItemsList.toArray(new Menu[userCustomMenuItemsList.size()]));
                session.setAttribute("customAddUI", customAddUIMap);
                session.setAttribute("customViewUI", customViewUIMap);
            }
            catch (RegistryException e) {
                log.error((Object)"unable to create connection to registry");
            }
            catch (UserStoreException e) {
                log.error((Object)"unable to realm service");
            }
        }
    }

    private static void buildViewUI(GovernanceArtifactConfiguration configuration, Map<String, String> viewUIMap, String key) {
        String singularLabel = configuration.getSingularLabel();
        String pluralLabel = configuration.getPluralLabel();
        String lifecycleAttribute = key + "Lifecycle_lifecycleName";
        lifecycleAttribute = GenericUtil.BuilLifecycleAttribute(configuration, DEFAULT_LIFECYCLE_GENERATOR_CLASS, lifecycleAttribute);
        if (singularLabel == null || pluralLabel == null) {
            log.error((Object)("The singular label and plural label have not been defined for the artifact type: " + key));
        } else {
            String contentURL = configuration.getContentURL();
            if (contentURL != null) {
                if (!contentURL.toLowerCase().equals("default")) {
                    viewUIMap.put(configuration.getMediaType(), contentURL);
                }
            } else {
                String path = "../generic/edit_ajaxprocessor.jsp?hideEditView=true&key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&add_edit_breadcrumb=" + singularLabel + "&add_edit_region=region3&add_edit_item=governance_add_" + key + "_menu&breadcrumb=" + singularLabel;
                viewUIMap.put(configuration.getMediaType(), path);
            }
        }
    }

    private static String BuilLifecycleAttribute(GovernanceArtifactConfiguration configuration, String defaultLifecycleGeneratorClass, String lifecycleAttribute) {
        try {
            OMElement configurationElement = configuration.getContentDefinition();
            String xpathExpression = "//@class";
            AXIOMXPath xpath = new AXIOMXPath(xpathExpression);
            List resultNodes = xpath.selectNodes((Object)configurationElement);
            if (resultNodes != null && resultNodes.size() > 0) {
                String lifecycleParentName = null;
                String lifecycleName = null;
                for (Object resultNode : resultNodes) {
                    OMElement parentElement = ((OMAttribute)resultNode).getOwner();
                    if (parentElement.getAttributeValue(new QName("class")).equals(defaultLifecycleGeneratorClass)) {
                        Iterator childrenIterator = parentElement.getParent().getChildrenWithLocalName("name");
                        while (childrenIterator.hasNext()) {
                            OMElement next = (OMElement)childrenIterator.next();
                            lifecycleName = next.getAttributeValue(new QName("label"));
                        }
                        OMElement rootElement = (OMElement)((OMElement)parentElement.getParent()).getParent();
                        lifecycleParentName = rootElement.getAttributeValue(new QName("name"));
                        break;
                    }
                    if (parentElement.getAttributeValue(new QName("isLifecycle")) == null || !parentElement.getAttributeValue(new QName("isLifecycle")).equals("true")) continue;
                    Iterator childrenIterator = parentElement.getParent().getChildrenWithLocalName("name");
                    while (childrenIterator.hasNext()) {
                        OMElement next = (OMElement)childrenIterator.next();
                        lifecycleName = next.getAttributeValue(new QName("label"));
                    }
                    OMElement rootElement = (OMElement)((OMElement)parentElement.getParent()).getParent();
                    lifecycleParentName = rootElement.getAttributeValue(new QName("name"));
                    break;
                }
                if (lifecycleParentName != null && lifecycleName != null) {
                    return GenericUtil.convertName(lifecycleParentName.split(" ")) + "_" + GenericUtil.convertName(lifecycleName.split(" "));
                }
            }
        }
        catch (OMException e) {
            log.error((Object)("Governance artifact configuration of configuration key:" + configuration.getKey() + " is invalid"), (Throwable)e);
        }
        catch (JaxenException e) {
            log.error((Object)"Error in getting the lifecycle attribute", (Throwable)e);
        }
        return null;
    }

    private static String convertName(String[] nameParts) {
        String convertedName = null;
        for (String namePart : nameParts) {
            char c;
            int i;
            for (i = 0; i < namePart.length() && Character.isLetter(c = namePart.charAt(i)) && !Character.isLowerCase(c); ++i) {
            }
            if (namePart.equals(nameParts[0])) {
                namePart = namePart.substring(0, i).toLowerCase() + namePart.substring(i);
            }
            convertedName = convertedName == null ? namePart : convertedName + namePart;
        }
        return convertedName;
    }

    private static int buildMenuList(HttpServletRequest request, GovernanceArtifactConfiguration configuration, List<Menu> menuList, String key, int menuOrder) {
        String singularLabel = configuration.getSingularLabel();
        String pluralLabel = configuration.getPluralLabel();
        boolean hasNamespace = configuration.hasNamespace();
        String lifecycleAttribute = key + "Lifecycle_lifecycleName";
        lifecycleAttribute = GenericUtil.BuilLifecycleAttribute(configuration, DEFAULT_LIFECYCLE_GENERATOR_CLASS, lifecycleAttribute);
        if (singularLabel == null || pluralLabel == null) {
            log.error((Object)("The singular label and plural label have not been defined for the artifact type: " + key));
        } else {
            int iconSet = configuration.getIconSet();
            if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)("/permission/admin/manage/resources/govern/" + key + "/add")) && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/browse") && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
                Menu addMenu = new Menu();
                addMenu.setId("governance_add_" + key + "_menu");
                addMenu.setI18nKey(singularLabel);
                addMenu.setParentMenu("add_sub_menu");
                if (configuration.getExtension() == null) {
                    addMenu.setLink("../generic/add_edit.jsp");
                    addMenu.setUrlParameters("key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&breadcrumb=" + singularLabel);
                } else {
                    addMenu.setLink("../generic/add_content.jsp");
                    addMenu.setUrlParameters("key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&breadcrumb=" + singularLabel + "&mediaType=" + configuration.getMediaType() + "&extension=" + configuration.getExtension() + "&singularLabel=" + singularLabel + "&pluralLabel=" + pluralLabel + "&hasNamespace" + hasNamespace);
                }
                addMenu.setRegion("region3");
                addMenu.setOrder(String.valueOf(menuOrder));
                addMenu.setStyleClass("manage");
                if (iconSet > 0) {
                    addMenu.setIcon("../generic/images/add" + iconSet + ".png");
                } else {
                    addMenu.setIcon("../images/add.gif");
                }
                addMenu.setAllPermissionsRequired(true);
                addMenu.setRequirePermission(new String[]{"/permission/admin/manage/resources/govern/" + key + "/add", "/permission/admin/manage/resources/browse", "/permission/admin/manage/resources/ws-api"});
                menuList.add(addMenu);
            }
            if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)("/permission/admin/manage/resources/govern/" + key + "/list")) && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
                Menu listMenu = new Menu();
                listMenu.setId("governance_list_" + key + "_menu");
                listMenu.setI18nKey(pluralLabel);
                listMenu.setParentMenu("list_sub_menu");
                if (configuration.getExtension() == null) {
                    listMenu.setLink("../generic/list.jsp");
                    listMenu.setUrlParameters("key=" + key + "&breadcrumb=" + pluralLabel + "&singularLabel=" + singularLabel + "&pluralLabel=" + pluralLabel);
                } else {
                    listMenu.setLink("../generic/list_content.jsp");
                    listMenu.setUrlParameters("key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&breadcrumb=" + singularLabel + "&mediaType=" + configuration.getMediaType() + "&singularLabel=" + singularLabel + "&pluralLabel=" + pluralLabel + "&hasNamespace=" + hasNamespace);
                }
                listMenu.setRegion("region3");
                listMenu.setOrder(String.valueOf(menuOrder));
                listMenu.setStyleClass("manage");
                if (iconSet > 0) {
                    listMenu.setIcon("../generic/images/list" + iconSet + ".png");
                } else {
                    listMenu.setIcon("../images/list.gif");
                }
                listMenu.setAllPermissionsRequired(true);
                listMenu.setRequirePermission(new String[]{"/permission/admin/manage/resources/govern/" + key + "/list", "/permission/admin/manage/resources/ws-api"});
                menuList.add(listMenu);
            }
            ++menuOrder;
        }
        return menuOrder;
    }

    public static String getGreatestChildVersion(ServletConfig config, HttpSession session, String path) throws Exception {
        String[] nodes = Utils.getSortedChildNodes((CollectionContentBean)new ResourceServiceClient(config, session).getCollectionContent(path));
        String last = "";
        for (String node : nodes) {
            String name = RegistryUtils.getResourceName((String)node);
            try {
                Integer.parseInt(name);
                last = name;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return last;
    }

    public static int[] getAdjacentVersions(ServletConfig config, HttpSession session, String path, int current) throws Exception {
        String[] nodes = Utils.getSortedChildNodes((CollectionContentBean)new ResourceServiceClient(config, session).getCollectionContent(path));
        int[] versions = new int[]{-1, -1};
        int previous = -1;
        for (String node : nodes) {
            String name = RegistryUtils.getResourceName((String)node);
            try {
                int temp = Integer.parseInt(name);
                if (previous == current) {
                    versions[1] = temp;
                    break;
                }
                if (temp == current) {
                    versions[0] = previous;
                }
                previous = temp;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return versions;
    }

    public static String getUniqueNameForNamespaceToRedirect(String commonSchemaLocation, String targetNamespace1) {
        String targetNamespace = targetNamespace1.replaceAll("\\s+$", "");
        targetNamespace = targetNamespace.replace("://", "/");
        targetNamespace = targetNamespace.replace(".", "/");
        String resourcePath = commonSchemaLocation.endsWith("/") ? commonSchemaLocation + targetNamespace : commonSchemaLocation + "/" + targetNamespace;
        if (!targetNamespace.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        return resourcePath;
    }

    public static String getNamespaceFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        overview = head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
        }
        return null;
    }

    public static String getNameFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        overview = head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getUIConfiguration(String filePath) {
        InputStream stream = GenericUIGenerator.class.getResourceAsStream(filePath);
        try {
            StAXOMBuilder builder = null;
            OMElement omElement = null;
            try {
                builder = new StAXOMBuilder(stream);
                omElement = builder.getDocumentElement();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            OMElement oMElement = omElement;
            return oMElement;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignore) {}
        }
    }

    public static OMElement addExtraElements(OMElement data, HttpServletRequest request) {
        String namespace;
        String name;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement operation = fac.createOMElement("operation", null);
        OMElement currentName = fac.createOMElement("currentName", null);
        OMElement currentNamespace = fac.createOMElement("currentNamespace", null);
        String operationValue = request.getParameter("operation");
        if (operationValue != null) {
            operation.setText(operationValue);
            data.addChild((OMNode)operation);
        }
        if ((name = request.getParameter("currentname")) != null) {
            currentName.setText(name);
            data.addChild((OMNode)currentName);
        }
        if ((namespace = request.getParameter("currentnamespace")) != null) {
            currentNamespace.setText(namespace);
            data.addChild((OMNode)currentNamespace);
        }
        return data;
    }

    public static OMElement loadAddedServiceContent(String xmlContent) throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xmlContent));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static String getDataElementName(String widgetName) {
        if (widgetName == null || widgetName.length() == 0) {
            return null;
        }
        String[] nameParts = widgetName.split("_");
        String convertedName = null;
        for (String namePart : nameParts) {
            char c;
            int i;
            for (i = 0; i < namePart.length() && Character.isLetter(c = namePart.charAt(i)) && !Character.isLowerCase(c); ++i) {
            }
            namePart = namePart.substring(0, i).toLowerCase() + namePart.substring(i);
            convertedName = convertedName == null ? namePart : convertedName + "_" + namePart;
        }
        if (convertedName == null) {
            return null;
        }
        return convertedName.replaceAll(" ", "").replaceAll("-", "");
    }

    public static OMElement getChildWithName(OMElement head, String widgetName, String namespace) {
        String adjustedName = GenericUtil.getDataElementName(widgetName);
        if (adjustedName == null) {
            return null;
        }
        OMElement child = head.getFirstChildWithName(new QName(namespace, adjustedName));
        if (child == null) {
            child = head.getFirstChildWithName(new QName(null, widgetName.replaceAll(" ", "-")));
        }
        return child;
    }

    public static List<OMElement> getChildsWithName(OMElement head, String widgetName, String namespace) {
        String adjustedName = GenericUtil.getDataElementName(widgetName);
        if (adjustedName == null) {
            return null;
        }
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        Iterator headingList = head.getChildrenWithName(new QName(namespace, adjustedName));
        while (headingList.hasNext()) {
            OMElement subheading = (OMElement)headingList.next();
            list.add(subheading);
        }
        return list;
    }

    public static String decorateVersionElement(String version, String basicVersionElement, String path, String type, String append, String screenWidth, ServletConfig config, HttpSession session, HttpServletRequest request) {
        String hrefPrefix = "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=";
        String hrefPostfix = screenWidth != null ? "&screenWidth=" + screenWidth : "";
        String patchPath = RegistryUtils.getParentPath((String)path);
        String minorPath = RegistryUtils.getParentPath((String)patchPath);
        String majorPath = RegistryUtils.getParentPath((String)minorPath);
        String servicePath = RegistryUtils.getParentPath((String)majorPath);
        String[] versions = version.split("[.]");
        StringBuffer sb = new StringBuffer("$1type=\"hidden\"$2");
        if (type.equals("collection")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
        } else if (type.equals("patch")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"javascript:void(0)\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                int[] adjacentVersions = GenericUtil.getAdjacentVersions(config, session, minorPath, Integer.parseInt(versions[2]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(versions[1]).append(".").append(adjacentVersions[0]).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(versions[1]).append(".").append(adjacentVersions[1]).append("\"/>");
                }
            }
            catch (Exception ignore) {}
        } else if (type.equals("minor")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"javascript:void(0)\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                String latestPatch;
                int[] adjacentVersions = GenericUtil.getAdjacentVersions(config, session, majorPath, Integer.parseInt(versions[1]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    latestPatch = GenericUtil.getGreatestChildVersion(config, session, majorPath + "/" + adjacentVersions[0]);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(adjacentVersions[0]).append(".").append(latestPatch).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    latestPatch = GenericUtil.getGreatestChildVersion(config, session, majorPath + "/" + adjacentVersions[1]);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(adjacentVersions[1]).append(".").append(latestPatch).append("\"/>");
                }
            }
            catch (Exception ignore) {}
        } else if (type.equals("major")) {
            sb.append("<a href=\"javascript:void(0)\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                String latestPatch;
                String latestMinor;
                int[] adjacentVersions = GenericUtil.getAdjacentVersions(config, session, servicePath, Integer.parseInt(versions[0]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    latestMinor = GenericUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[0]);
                    latestPatch = GenericUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[0] + "/" + latestMinor);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(servicePath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(adjacentVersions[0]).append(".").append(latestMinor).append(".").append(latestPatch).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    latestMinor = GenericUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[1]);
                    latestPatch = GenericUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[1] + "/" + latestMinor);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(servicePath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(adjacentVersions[1]).append(".").append(latestMinor).append(".").append(latestPatch).append("\"/>");
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return basicVersionElement.replaceAll("(<input[^>]*)type=\"text\"([^>]*id=\"id_Overview_Version\"[^>]*>)", sb.toString());
    }
}

