/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.common.dataobjects;

import org.apache.commons.lang.StringEscapeUtils;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.UIComponent;

public class TextArea
extends UIComponent {
    private String value;
    private int height;
    private int width;
    private boolean isRichText;
    private boolean isSkipName;

    public TextArea(String label, String name, String id, String mandatory, String widget, String value, int height, int width, boolean isReadOnly, boolean isRichText, String tooltip, boolean isSkipName, boolean isJSGenerating) {
        super(label, name, id, mandatory, widget, isReadOnly, tooltip, isJSGenerating);
        this.value = value;
        this.height = height;
        this.width = width;
        this.isRichText = isRichText;
        this.isSkipName = isSkipName;
    }

    @Override
    public String generate() {
        StringBuilder element = new StringBuilder();
        String partialName = this.widget.replaceAll(" ", "") + "_" + this.name.replaceAll(" ", "");
        String id = this.id == null ? "id_" + partialName : this.id;
        StringBuilder size = new StringBuilder("style=\"");
        this.value = StringEscapeUtils.escapeHtml((String)this.value);
        if (this.height > 0) {
            size.append("height:").append(this.height).append("px;");
        }
        if (this.width > 0) {
            size.append("width:").append(this.width).append("px\"");
        } else {
            size.append("width:").append("400").append("px\"");
        }
        if (this.isSkipName) {
            element.append("<td><textarea  name=\"").append(partialName).append("\" title=\"").append(this.tooltip).append("\" id=\"id_").append(partialName).append("\" ").append((CharSequence)size).append(this.isReadOnly ? " readonly" : "").append(" >").append(this.value != null ? StringEscapeUtils.escapeHtml((String)this.value) : "").append("</textarea></td>");
            return element.toString();
        }
        if ("true".equals(this.mandatory)) {
            if (this.isRichText) {
                element.append("<td class=\"leftCol-big\">").append(this.label).append("<span class=\"required\">*</span></td>").append(" <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"").append(partialName).append("\" title=\"").append(this.tooltip).append("\" id=\"").append(id).append("\" ").append((CharSequence)size).append(this.isReadOnly ? " readonly" : "").append(" >").append(this.value != null ? this.value : "").append("</textarea>");
                element = this.appendRichTextScript(element, this.width, this.height, this.widget, this.name, partialName);
                element.append("</td></tr>");
            } else {
                element.append("<tr><td class=\"leftCol-big\">").append(this.label).append("<span class=\"required\">*</span></td> <td><textarea  name=\"").append(partialName).append("\" title=\"").append(this.tooltip).append("\" id=\"").append(id).append("\" ").append((CharSequence)size).append(this.isReadOnly ? " readonly" : "").append(" >").append(this.value != null ? this.value : "").append("</textarea>");
                element.append("</td></tr>");
            }
        } else if (this.isRichText) {
            element.append("<tr><td class=\"leftCol-big\">").append(this.label).append("<span class=\"required\">*</span></td>").append(" <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"").append(partialName).append("\" title=\"").append(this.tooltip).append("\" id=\"").append(id).append("\" ").append((CharSequence)size).append(this.isReadOnly ? " readonly" : "").append(" >").append(this.value != null ? this.value : "").append("</textarea>");
            element = this.appendRichTextScript(element, this.width, this.height, this.widget, this.name, partialName);
            element.append("</td></tr>");
        } else {
            if (this.label != null) {
                element.append("<tr><td class=\"leftCol-big\">").append(this.label).append("</td>");
            }
            element.append("<td><textarea  name=\"").append(partialName).append("\" title=\"").append(this.tooltip).append("\" id=\"").append(id).append("\" ").append((CharSequence)size).append(this.isReadOnly ? " readonly" : "").append(" >").append(this.value != null ? this.value : "").append("</textarea>");
            if (this.label != null) {
                element.append("</td></tr>");
            }
        }
        return element.toString();
    }

    private StringBuilder appendRichTextScript(StringBuilder element, int width, int height, String widget, String name, String attrName) {
        String eleName = "id_" + attrName;
        String ele_id = "_id_" + attrName;
        String fun_name = "set_" + eleName;
        String richTextAttrName = "yui_txt_" + eleName;
        element.append("<script>\n").append("\n").append("var ").append(richTextAttrName).append(";\n").append("(function() {\n").append("    var Dom = YAHOO.util.Dom,\n").append("        Event = YAHOO.util.Event;\n").append("    \n").append("    var myConfig = {\n").append("        height: '").append("120px',\n").append("        width: '").append("400px',\n").append("        dompath: true,\n").append("        focusAtStart: true\n").append("    };\n").append("\n").append("    YAHOO.log('Create the Editor..', 'info', 'example');\n").append("    ").append(richTextAttrName).append(" = new YAHOO.widget.SimpleEditor('").append(eleName).append("', myConfig);\n").append("    ").append(richTextAttrName).append(".render();\n").append("\n").append("})();\n");
        element.append("function ").append(fun_name).append("(){\n").append("        var form1 = document.getElementById('CustomUIForm');\n").append("        var newInput = document.createElement('input');\n").append("        newInput.setAttribute('type','hidden');\n").append("        newInput.setAttribute('name','").append(attrName).append("');\n").append("        newInput.setAttribute('id','").append(ele_id).append("');\n").append("        form1.appendChild(newInput);").append("    var contentText=\"\";\n").append("    ").append(richTextAttrName).append(".saveHTML();\n").append("    contentText = ").append(richTextAttrName).append(".get('textarea').value;\n").append("    document.getElementById(\"").append(ele_id).append("\").value = contentText;\n").append("}");
        element.append("</script>");
        return element;
    }

    private StringBuilder appendEmptyScript(StringBuilder element, String widget, String name, String partialName) {
        String eleName = "id_" + partialName;
        String fun_name = "set_" + eleName;
        element.append("<script>\n");
        element.append("function ").append(fun_name).append("(){}");
        element.append("</script>");
        return element;
    }
}

