/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.common.dataobjects;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.UIComponent;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OptionText
extends UIComponent {
    private String originalName;
    private int index;
    private String[] values;
    private String option;
    private String text;
    private boolean isURL;
    private String urlTemplate;
    private boolean isPath;
    private String startsWith;
    private HttpServletRequest request;

    public OptionText(String originalName, int index, String label, String name, String id, String[] values, String widget, String option, String text, boolean isURL, String urlTemplate, boolean isPath, String tooltip, String startsWith, HttpServletRequest request, boolean isJSGenerating) {
        super(label, name, id, null, widget.replaceAll(" ", ""), false, tooltip, isJSGenerating);
        this.originalName = originalName;
        this.index = index;
        this.values = values;
        this.option = option;
        this.text = text;
        this.isURL = isURL;
        this.urlTemplate = urlTemplate;
        this.isPath = isPath;
        this.startsWith = startsWith;
        this.request = request;
    }

    @Override
    public String generate() {
        if (this.name == null) {
            this.name = this.originalName + this.index;
        }
        this.name = this.name.replaceAll(" ", "");
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol\"><select name=\"").append(this.widget).append("_").append(this.name).append("\" title=\"").append(this.tooltip).append("\">");
        String id = this.id == null ? "id_" + this.widget + "_" + this.name : this.id;
        for (int i = 0; i < this.values.length; ++i) {
            dropDown.append("<option value=\"").append(StringEscapeUtils.escapeHtml((String)this.values[i])).append("\"");
            if (this.values[i].equals(this.option)) {
                dropDown.append(" selected");
            }
            dropDown.append(">");
            dropDown.append(StringEscapeUtils.escapeHtml((String)this.values[i]));
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        if (this.isURL && this.text != null) {
            String selectResource = " <input style=\"display:none\" id=\"" + id + "_button\" type=\"button\" " + "class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)this.request.getLocale()) + "\" ";
            String selectResourceButton = "$('" + id + "_button').style.display='';";
            StringBuilder selectResourceSb = new StringBuilder(selectResource);
            if (this.isPath) {
                if (this.startsWith != null) {
                    selectResourceSb.append("onclick=\"showGovernanceResourceTreeWithCustomPath('").append(id).append("','").append(this.startsWith).append("');\"/>");
                } else {
                    selectResourceSb.append("onclick=\"showGovernanceResourceTree('").append(id).append("');\"/>");
                }
            }
            String browsePath = "/_system/governance";
            String div = "<div id=\"" + id + "_link\"><a target=\"_blank\" href=\"" + (this.isPath ? "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=" + browsePath : "") + StringEscapeUtils.escapeHtml((String)(this.urlTemplate != null ? this.urlTemplate.replace("@{value}", this.text) : this.text)) + "\">" + StringEscapeUtils.escapeHtml((String)this.text) + "</a>" + "&nbsp;<a onclick=\"$('" + id + "_link').style.display='none';$('" + id + "')." + "style.display='';" + (this.isPath ? selectResourceButton : "") + "\" title=\"" + CarbonUIUtil.geti18nString((String)"edit", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)this.request.getLocale()) + "\" class=\"icon-link\" style=\"background-image: url('../admin/images/edit.gif');float: none\"></a></div>";
            dropDown.append("<td>").append(div).append("<input style=\"display:none\" type=\"text\" name=\"").append(this.widget).append("text").append("_").append(this.name).append("\" title=\"").append(this.tooltip).append("\" value=\"").append(StringEscapeUtils.escapeHtml((String)this.text)).append("\" id=\"").append(id).append("\" style=\"width:400px\"/>").append(this.isPath ? selectResourceSb.toString() : "").append("</td>");
        } else {
            String selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.generic.ui.i18n.Resources", (Locale)this.request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            dropDown.append("<td width=500px><input type=\"text\" name=\"").append(this.widget).append("text").append("_").append(this.name).append("\"  title=\"").append(this.tooltip).append("\" ").append(this.text != null ? " value=\"" + StringEscapeUtils.escapeHtml((String)this.text) : "").append("\" id=\"").append(id).append("\" style=\"width:400px\"/>").append(this.isPath ? selectResource : "").append("</td>");
        }
        if (this.originalName != null && this.widget != null) {
            dropDown.append("<td><a class=\"icon-link\" title=\"delete\" onclick=\"").append("delete").append(this.originalName.replaceAll(" ", "")).append("_").append(this.widget).append("(this.parentNode.parentNode.rowIndex)\" ").append("style=\"background-image:url(../admin/images/delete.gif);\">Delete</a></td>");
        }
        dropDown.append("</tr>");
        return dropDown.toString();
    }
}

