/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.common.dataobjects;

import org.apache.commons.lang.StringEscapeUtils;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.UIComponent;

public class DropDown
extends UIComponent {
    private String[] values;
    private String value;

    public DropDown(String label, boolean markReadonly, String name, String id, String mandatory, String[] values, String widget, String value, String tooltip, boolean isJSGenerating) {
        super(label, name, id, mandatory, widget, markReadonly, tooltip, isJSGenerating);
        this.values = values;
        this.value = value;
    }

    @Override
    public String generate() {
        String id = this.id == null ? "id_" + this.widget.replaceAll(" ", "") + "_" + this.name.replaceAll(" ", "") : this.id;
        StringBuilder dropDown = new StringBuilder();
        if ("true".equals(this.mandatory)) {
            dropDown.append(this.label != null ? "<tr><td class=\"leftCol-big\">" + this.label + "<span class=\"required\">*</span></td>" : "").append("<td><select id=\"").append(id).append("\" name=\"").append(this.widget.replaceAll(" ", "")).append("_").append(this.name.replaceAll(" ", "")).append("\" title=\"").append(this.tooltip).append("\"").append(this.isReadOnly ? " disabled" : "").append("\">");
        } else {
            dropDown.append(this.label != null ? "<tr><td class=\"leftCol-big\">" + this.label + "</td>" : "").append("<td><select id=\"").append(id).append("\" ").append("name=\"").append(this.widget.replaceAll(" ", "")).append("_").append(this.name.replaceAll(" ", "")).append("\" title=\"").append(this.tooltip).append("\"").append(this.isReadOnly ? " disabled" : "").append(">");
        }
        for (int i = 0; i < this.values.length; ++i) {
            dropDown.append("<option value=\"").append(StringEscapeUtils.escapeHtml((String)this.values[i])).append("\"");
            if (this.values[i].equals(this.value)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(StringEscapeUtils.escapeHtml((String)this.values[i]));
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        if (this.label != null) {
            dropDown.append("</tr>");
        }
        return dropDown.toString();
    }
}

