/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.clients;

import java.rmi.RemoteException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.generic.stub.ManageGenericArtifactServiceStub;
import org.wso2.carbon.governance.generic.stub.beans.xsd.ArtifactsBean;
import org.wso2.carbon.governance.generic.stub.beans.xsd.ContentArtifactsBean;
import org.wso2.carbon.governance.generic.stub.beans.xsd.StoragePathBean;
import org.wso2.carbon.governance.generic.ui.utils.GenericUtil;
import org.wso2.carbon.governance.generic.ui.utils.InstalledRxt;
import org.wso2.carbon.governance.generic.ui.utils.ManageGenericArtifactUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ManageGenericArtifactServiceClient {
    private static final Log log = LogFactory.getLog(ManageGenericArtifactServiceClient.class);
    private ManageGenericArtifactServiceStub stub;
    private String epr;
    private HttpSession session;

    public ManageGenericArtifactServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ManageGenericArtifactService";
        try {
            this.stub = new ManageGenericArtifactServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ManageGenericArtifactServiceClient. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ManageGenericArtifactServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        this.session = session;
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ManageGenericArtifactService";
        try {
            this.stub = new ManageGenericArtifactServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ManageGenericArtifactServiceClient. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String addArtifact(String key, String info, String lifecycleAttribute) throws Exception {
        return this.stub.addArtifact(key, info, lifecycleAttribute);
    }

    public String editArtifact(String path, String key, String info, String lifecycleAttribute) throws Exception {
        return this.stub.editArtifact(path != null ? path : "", key, info, lifecycleAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactsBean listArtifacts(String key, String criteria) throws Exception {
        ArtifactsBean artifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ArtifactsBean artifactsBean2 = this.stub.listArtifacts(key, criteria);
                return artifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            artifactsBean = this.stub.listArtifacts(key, criteria);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return artifactsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactsBean listArtifactsByName(String key, String name) throws Exception {
        ArtifactsBean artifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ArtifactsBean artifactsBean2 = this.stub.listArtifactsByName(key, name);
                return artifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            artifactsBean = this.stub.listArtifactsByName(key, name);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return artifactsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactsBean listArtifactsByLC(String key, String LCName, String LCState, String LCInOut, String LCStateInOut) throws Exception {
        ArtifactsBean artifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ArtifactsBean artifactsBean2 = this.stub.listArtifactsByLC(key, LCName, LCState, LCInOut, LCStateInOut);
                return artifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            artifactsBean = this.stub.listArtifactsByLC(key, LCName, LCState, LCInOut, LCStateInOut);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return artifactsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentArtifactsBean listContentArtifacts(String mediaType) throws Exception {
        ContentArtifactsBean contentArtifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ContentArtifactsBean contentArtifactsBean2 = this.stub.listContentArtifacts(mediaType);
                return contentArtifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            contentArtifactsBean = this.stub.listContentArtifacts(mediaType);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return contentArtifactsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentArtifactsBean listContentArtifactsByLC(String mediaType, String LCName, String LCState, String LCInOut, String LCStateInOut) throws Exception {
        ContentArtifactsBean contentArtifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ContentArtifactsBean contentArtifactsBean2 = this.stub.listContentArtifactsByLC(mediaType, LCName, LCState, LCInOut, LCStateInOut);
                return contentArtifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            contentArtifactsBean = this.stub.listContentArtifactsByLC(mediaType, LCName, LCState, LCInOut, LCStateInOut);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return contentArtifactsBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentArtifactsBean listContentArtifactsByName(String mediaType, String criteria) throws Exception {
        ContentArtifactsBean contentArtifactsBean;
        try {
            if (PaginationContext.getInstance() == null) {
                ContentArtifactsBean contentArtifactsBean2 = this.stub.listContentArtifactsByName(mediaType, criteria);
                return contentArtifactsBean2;
            }
            PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
            contentArtifactsBean = this.stub.listContentArtifactsByName(mediaType, criteria);
            int rowCount = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            this.session.setAttribute("row_count", (Object)Integer.toString(rowCount));
        }
        finally {
            PaginationContext.destroy();
        }
        return contentArtifactsBean;
    }

    public StoragePathBean getStoragePath(String key) throws Exception {
        return this.stub.getStoragePath(key);
    }

    public String getArtifactContent(String path) throws Exception {
        return this.stub.getArtifactContent(path);
    }

    public String getArtifactUIConfiguration(String key) throws Exception {
        return this.stub.getArtifactUIConfiguration(key);
    }

    public boolean setArtifactUIConfiguration(String key, String content) throws Exception {
        return this.stub.setArtifactUIConfiguration(key, content);
    }

    public boolean canChange(String path) throws Exception {
        return this.stub.canChange(path);
    }

    public String[] getAvailableAspects() throws Exception {
        return this.stub.getAvailableAspects();
    }

    public boolean addRXTResource(HttpServletRequest request, String config, String path) throws Exception {
        boolean result = this.stub.addRXTResource(config, path);
        HttpSession session = request.getSession();
        if (session != null) {
            GenericUtil.buildMenuItems(request, this.getSessionParam(session, "logged-user"), this.getSessionParam(session, "tenantDomain"), this.getSessionParam(session, "ServerURL"));
        }
        return result;
    }

    private String getSessionParam(HttpSession session, String name) {
        return (String)session.getAttribute(name);
    }

    public List<InstalledRxt> getInstalledRXTs(String cookie, ServletConfig config, HttpSession session) throws Exception {
        return ManageGenericArtifactUtil.getInstalledRxts(cookie, config, session);
    }

    public String getRxtAbsPathFromRxtName(String name) throws Exception {
        return this.stub.getRxtAbsPathFromRxtName(name);
    }

    public String getArtifactViewRequestParams(String key) throws Exception {
        return this.stub.getArtifactViewRequestParams(key);
    }

    public String[] getAllLifeCycleState(String LCName) throws RemoteException {
        return this.stub.getAllLifeCycleState(LCName);
    }
}

