/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

import java.io.Reader;

/**
 * JavaScriptEngine processes the javascript source and evaluates a given function
 */
public class JavascriptEngine {

    private Scriptable scope;

    /**
     * Returns the evaluated XML string object from the javascript.
     *
     * @param method The name of the method to call.
     * @param reader The JS script file stream.
     * @param args   The arguments to the function.
     * @return The result after evaluating the javascript function.
     */

    public Object call(String method, Reader reader, String args) throws Exception {

        Object result = null;

        Context cx = Context.enter();
        try {
            scope = cx.initStandardObjects();

            //evaluates the javascript file and returns an object
            cx.evaluateReader(scope, reader, "<cmd>", 0, null);

            //get the function from the scope the javascript object is in
            Object fObj = scope.get(method, scope);

            if (!(fObj instanceof Function) || (fObj == Scriptable.NOT_FOUND)) {
                System.out.println("Method " + method + " is undefined or not a function.");
            } else {
                Object functionArgs[] = {args};
                Function f = (Function) fObj;
                result = f.call(cx, scope, scope, functionArgs);
            }

        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return result;

    }
}

