/*
 * Copyright 2005-2007 WSO2, Inc. (http://wso2.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.wsas.sample.javascript;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerConstants;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.*;
import java.util.Properties;

/**
 * Simple Java client to test the functionality of the JavaScriptMessageReceiver
 */
public class Client {

    private static String serviceEPR =
            "http://localhost:9762/" + ServerConstants.SERVICE_PATH + "/JavascriptService/echo";
    private static final String wso2wsasHome = System.getProperty("wso2wsas.home");

    public static void main(String[] args) {

        Properties props = new Properties();
        try {
            String defEPRProperties = wso2wsasHome + File.separator + "samples" +
                                      File.separator + "JavascriptService" + File.separator +
                                      "conf" + File.separator + "default_epr.properties";
            props.load(new FileInputStream(defEPRProperties));
            serviceEPR = props.getProperty("js.epr").replaceAll("@hostname@",
                                                                NetworkUtils.getLocalHostname());
        } catch (IOException e) {
            System.err.println("[WARN] default_epr.properties not found in conf directory");
        }

        try {
            //Create the payload to be sent to the JavaScriptService
            OMElement payload = getEchoOMElement();
            StringWriter writer1 = new StringWriter();
            payload.serialize(XMLOutputFactory.newInstance().createXMLStreamWriter(writer1));
            writer1.flush();

            System.out.println("\nWe send the following xml to the JavaScriptService:");
            System.out.println(writer1.toString());

            Options options = new Options();
            options.setTo(new EndpointReference(serviceEPR));
            options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
            options.setUseSeparateListener(false);

            ServiceClient serviceClient = new ServiceClient();
            serviceClient.setOptions(options);

            //Invoke the question function from the JavaScriptService
            OMElement result = serviceClient.sendReceive(payload);
            StringWriter writer2 = new StringWriter();
            result.serialize(XMLOutputFactory.newInstance().createXMLStreamWriter(writer2));
            writer2.flush();

            System.out.println("\nAnd this is the response from the JavaScriptService:");
            System.out.println(writer2.toString());

        } catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        } catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static OMElement getEchoOMElement() throws XMLStreamException {

        String str = "<PEOPLE>" +
                     "<PERSON>" +
                     "<NAME>person1</NAME>" +
                     "<OCCUPATION>student</OCCUPATION>" +
                     "<ADDRESS>address1</ADDRESS>" +
                     "<GENDER>male</GENDER>" +
                     "</PERSON>" +
                     "<PERSON>" +
                     "<NAME>person2</NAME>" +
                     "<OCCUPATION>student</OCCUPATION>" +
                     "<ADDRESS>address2</ADDRESS>" +
                     "<GENDER>female</GENDER>" +
                     "</PERSON>" +
                     "<PERSON>" +
                     "<NAME>person3</NAME>" +
                     "<OCCUPATION>student</OCCUPATION>" +
                     "<ADDRESS>address3</ADDRESS>" +
                     "<GENDER>male</GENDER>" +
                     "</PERSON>" +
                     "</PEOPLE>";

        XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new
                ByteArrayInputStream(str.getBytes()));
        OMFactory fac = OMAbstractFactory.getOMFactory();

        StAXOMBuilder staxOMBuilder = new
                StAXOMBuilder(fac, xmlReader);
        return staxOMBuilder.getDocumentElement();
    }
}

