/**
 * This js has the tools related js functions
 */

if (typeof wso2 == "undefined") {
    var wso2 = {};
}
if (typeof wso2.wsas == "undefined") {
    wso2.wsas = {};
}

var codegenFileUploadOption = "";
var codegenParentTextId = "";

// static tools methods 
wso2.wsas.Tools = {

    renderHelper :function(thisObj, index) {
        if (thisObj && index) {
            renderSelectedMenuItem(thisObj, index);
            gatherHistoryObject(thisObj.id, index);
        }
    },

    avAARTool : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        wso2.tool.AV.showValidatorServicesXML();
    },

    avMARTool : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        wso2.tool.AV.showValidatorModuleXML();
    },

    wcTool : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        wso2.tool.WC.showWC();
    },

    tryitTool : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        wso2.tool.WC.showTryit();
    },

    wsdlview : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        wso2.tool.WSDLView.showWSDLView();
    },

    wsdl2code2 : function(thisObj, index) {
        this.renderHelper(thisObj, index);
        var body_xml = '<req:getCodegenOptions xmlns:req="http://org.wso2.wsf/tools">\n' +
                       '</req:getCodegenOptions>\n';

        var callURL = wso2.wsf.Util.getServerURL() + "/WSDL2Code" ;
        new wso2.wsf.WSRequest(callURL, "urn:getCodegenOptions", body_xml, wsdl2code2Callback);
    },

    startCodegen : function(options) {
        var bodyXML = '<req:codegen xmlns:req="http://org.wso2.wsf/tools">\n';
        for (var o in options) {
            bodyXML += '<options><![CDATA[' + o + ']]></options>\n';
            var oVal = options[o];
            if (oVal != null && oVal.length != 0) {
                bodyXML += '<options><![CDATA[' + oVal + ']]></options>\n';
            }
        }
        bodyXML += '</req:codegen>';
        var buttonObj = document.getElementById('genericCodegenButtonId');
        if (buttonObj != null) {
            buttonObj.disabled = true;
        }
        var callURL = wso2.wsf.Util.getServerURL() + "/WSDL2Code" ;
        wso2.wsf.Util.cursorWait();
        new wso2.wsf.WSRequest(callURL, "urn:codegen", bodyXML, startCodegenCallback, [buttonObj], this.onError);

    },

    onError : function() {
        this.defaultError.call(this);
        var buttonObj = this.params[0];
        if (buttonObj != null) {
            buttonObj.disabled = false;
        }
    },

    wsdl2code : function(thisObj, index) {

        this.renderHelper(thisObj, index);
        var tmpTransformationNode;

        /* The checking for the existance for window.XMLHttpRequest to figure out
        the browser and the functionality was dropped since the new version of
        IE has this object. */
        if (wso2.wsf.Util.isIE()) {
            tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
            var sXml = "<wsdl2code></wsdl2code>";
            tmpTransformationNode.loadXML(sXml);
        } else {
            tmpTransformationNode =
            document.implementation.createDocument("", "wsdl2code", null);
        }

        var divObject = document.getElementById("divWSDL2Code");
        var xsltHelperObj = new wso2.wsf.XSLTHelper();
        xsltHelperObj.transform(divObject, tmpTransformationNode, "wsdl2code.xsl", false, "tools");
        wso2.wsf.Util.showOnlyOneMain(document.getElementById("divWSDL2Code"));

    },

    unwrapSelect : function(obj) {
        var uwSelect = document.getElementById('unwrapId');
        uwSelect.options.length = 0;
        var selection = obj.options[obj.selectedIndex].value;
        if (selection == "none" || selection == "xmlbeans") {
            uwSelect.options[0] = new Option('False', 'false');
        } else {
            uwSelect.options[0] = new Option('False', 'false');
            uwSelect.options[1] = new Option('True', 'true');
        }
    },

    generateClient : function(wsdlLocationObj,
                              packageNameObj,
                              invocationStyleObj,
                              generateTestCasesObj,
                              databindingMethodObj,
                              unpackClassesObj,
                              serviceBindingNameObj,
                              serviceBindingPortObj,
                              unwrapObj,
                              wsdlVersionObj) {

        var wsdlLocation = wsdlLocationObj.value;
        if (!wsdlLocation) {
            wso2.wsf.Util.alertWarning("WSDL location is mandatory");
            return false;
        }

        var packageName = packageNameObj.value;
        var invocationStyle = invocationStyleObj[invocationStyleObj.selectedIndex].value;
        var generateTestCases = generateTestCasesObj[generateTestCasesObj.selectedIndex].value;
        var databindingMethod = databindingMethodObj[databindingMethodObj.selectedIndex].value;
        var unpackClasses = unpackClassesObj[unpackClassesObj.selectedIndex].value;
        var serviceBindingPort = serviceBindingPortObj.value;
        var unwrap = unwrapObj[unwrapObj.selectedIndex].value;
        var wsdlVersion = wsdlVersionObj[wsdlVersionObj.selectedIndex].value;
        var serviceName = "genericService";

        var serviceBindingName = serviceBindingNameObj.value;

        var pattern = /^[a-zA-Z](([a-zA-Z_]+)([a-zA-Z0-9_]?)\.?)+[a-z0-9_]$/;
        if (packageName == null || wso2.wsf.Util.trim(packageName) == '') {
            wso2.wsf.Util.alertWarning("Package name is mandatory");
            return false;
        }
        if (!pattern.test(packageName)) {
            wso2.wsf.Util.alertWarning("Package name is not valid under Java package naming conventions");
            return false;
        }

        var buttonObj = document.getElementById('wsdl2codeButtonId');

        if (buttonObj != null) {
            buttonObj.disabled = true;
        }
        var body_xml = ' <req:generateRequest xmlns:req="http://wsdl2code.service.admin.wsas.wso2.org">\n' +
                       ' <service>' + serviceName + '</service>\n' +
                       ' <packageName>' + packageName + '</packageName>\n' +
                       ' <invocationStyle>' + invocationStyle + '</invocationStyle>\n' +
                       ' <generateTestCase>' + generateTestCases + '</generateTestCase>\n' +
                       ' <databindingMethod>' + databindingMethod + '</databindingMethod>\n' +
                       ' <unpackClasses>' + unpackClasses + '</unpackClasses>\n' +
                       ' <serviceBindingName>' + serviceBindingName + '</serviceBindingName>\n' +
                       ' <servicePortName>' + serviceBindingPort + '</servicePortName>\n' +
                       ' <unwrap>' + unwrap + '</unwrap>\n' +
                       ' <wsdlVersion>' + wsdlVersion + '</wsdlVersion>\n' +
                       ' <wsdlLocation>' + wsdlLocation + '</wsdlLocation>\n' +
                       ' </req:generateRequest>\n';

        var callURL = wso2.wsf.Util.getServerURL() + "/" + "JavaClientGeneratorService" ;
        wso2.wsf.Util.cursorWait();
        new wso2.wsf.WSRequest(callURL, "generate", body_xml, generateClientToolsCallback, [buttonObj]);
    }
};

function generateClientToolsCallback() {
    //response will be a link and it will call the download dialog
    var data = this.req.responseXML;
    var responseTextValue = data.getElementsByTagName("return")[0].firstChild.nodeValue;
    var buttonObj = this.params[0];
    if (buttonObj != null) {
        buttonObj.disabled = false;
    }
    window.location = URL + responseTextValue;
}

function wsdl2code2Callback() {
    var divObject = document.getElementById("divWSDL2Code");
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(divObject, this.req.responseXML, "extensions/tools/xslt/wsdl2code2.xsl", true);
    wso2.wsf.Util.showOnlyOneMain(document.getElementById("divWSDL2Code"));

}

function startCodegenCallback() {
    //response will be a link and it will call the download dialog
    var data = this.req.responseXML;
    var responseTextValue = data.getElementsByTagName("return")[0].firstChild.nodeValue;
    var buttonObj = this.params[0];
    if (buttonObj != null) {
        buttonObj.disabled = false;
    }
    var tmpURL = "";
    var proto = wso2.wsf.Util.getProtocol();
    if (proto == "https") {
        tmpURL += URL;
    } else if (proto == "http") {
        tmpURL += GURL;
    }
    window.location = tmpURL + responseTextValue;
}

function codeGenFileUploadeHelper(opt, txtObjId) {
    codegenFileUploadOption = opt;
    codegenParentTextId = txtObjId;
    FileExcutor.execute = exeCodegenFileUpload;
    var tmpTransformationNode;
    /* The checking for the existance for window.XMLHttpRequest to figure out
    the browser and the functionality was dropped since the new version of
    IE has this object. */
    if (wso2.wsf.Util.isIE()) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<codegenFileUpload></codegenFileUpload>";
        tmpTransformationNode.loadXML(sXml);
    } else {
        tmpTransformationNode =
        document.implementation.createDocument("", "codegenFileUpload", null);
    }
    var divObject = document.getElementById("divCodegenFileupload");
    var xsltHelperObj = new wso2.wsf.XSLTHelper();
    xsltHelperObj.transform(divObject, tmpTransformationNode, "codegen_file_upload.xsl", false, "tools");
    var header = "Upload File for Option -" + opt;
    showYUIPanel(header, divObject.innerHTML, "500px", "innerCodegenId", "divCodegenFileupload");
}

function exeCodegenFileUpload(val) {
    var body_xml = '<req:getCodegenOptionsWithValues xmlns:req="http://org.wso2.wsf/tools">\n' +
                   '<codegenOption>' + codegenFileUploadOption + '</codegenOption>' +
                   '<codegenOptionValue>' + val + '</codegenOptionValue>' +
                   '</req:getCodegenOptionsWithValues>\n';

    var callURL = wso2.wsf.Util.getServerURL() + "/WSDL2Code" ;
    new wso2.wsf.WSRequest(callURL, "urn:getCodegenOptionsWithValues", body_xml, function () {
        var divObj = document.getElementById("divCodegenFileupload");
        if (divObj) {
            divObj.innerHTML = "";
            divObj.style.display = "none";
        }
        var responseTextValue = this.req.responseXML.getElementsByTagName("uploadFileValue")[0].firstChild.nodeValue;
        divObj = document.getElementById(codegenParentTextId);
        divObj.value = responseTextValue;
//        divObj.disabled = true;
    });

}

