/*
transports.js will work on the TrasportAdmin related administration
*/

var TRANSPORT_ADMIN = "TransportAdmin";

var HTTPS_PORT;

var KEYSTORE_PASSWORD;
var KEYSTORE_REE_PASSWORD;
var KEYSTORE_TYPE;

function showTransports(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    var body_xml = '<ns1:listTransportsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:listTransportsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "listTransports";
    new wso2.wsf.WSRequest(callURL,"listTransports",body_xml,showTransportsCallback);

}

function addNewTransport_1() {
    var body_xml = '<ns1:getAvailableProtocolsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getAvailableProtocolsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getAvailableProtocols";
    new wso2.wsf.WSRequest(callURL,"getAvailableProtocols",body_xml,addNewTransport_1Callback);

}

function showTransportsCallback() {

    transportOnly = true;

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"list_transport.xsl",document.getElementById("divListTransport"));
}

function addNewTransport_1Callback() {

    wso2.wsf.Util.callbackhelper(this.req.responseXML,"add_new_transport_1.xsl",document.getElementById("divAddNewTransport_1"));
}


function addNewTrasportHTTPSPort() {

    //SOAP Call for get the PORT for the HTTPS Transport
    var body_xml = '<ns1:getAvailablePortRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '</ns1:getAvailablePortRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getAvailablePort";
    new wso2.wsf.WSRequest(callURL,"getAvailablePort",body_xml,addNewTrasportHTTPSPortCallback);

}

function addNewTrasportHTTPSPortCallback() {

    var data = this.req.responseXML;
    var port = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    HTTPS_PORT = port;

    // second view of HTTPS

    addNewTransport_2();

}

function addNewTransport_2() {
    var objDiv = document.getElementById("divAddNewTransport_2");
    /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
                  "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
    var strHTML = "<h2>Transport Management Wizard</h2>"+
                  "<fieldset style='border:none;'>" +
                  "<div id='formset'><form>" +
                  "<fieldset>" +
                  "<legend>Select Https Port - step 2</legend>" +
                  "<div><label>HTTPS Port<font color='red'>*</font></label><input type='text' id='httpsPort'/></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:addNewTransport_1();return false;' value='< Back'/>" +
                  "<input type='button' onclick='javascript:isHTTPSPortAvailable();return false;' value='Next >'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

    // filling the text input httpsPort
    var objInput = document.getElementById('httpsPort');
    objInput.value = HTTPS_PORT;
}

function next_1(objCombo) {
    var transportProtocol = objCombo[objCombo.selectedIndex].text;
    if (transportProtocol == null) {
        transportProtocol = objCombo[objCombo.selectedIndex].value;
    }

    if (transportProtocol == 'HTTPS') {
        // do the http stuff
        addNewTrasportHTTPSPort();
    } else {
        // added new transport on something other
        alert('Do it have to finish it here !');
    }



}

function isHTTPSPortAvailable() {

    var httpsPortObj = document.getElementById('httpsPort');

    var body_xml = '<ns1:isPortAvailableRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<port>' + httpsPortObj.value + '</port>'
                   '</ns1:isPortAvailableRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "isPortAvailable";
    new wso2.wsf.WSRequest(callURL,"isPortAvailable",body_xml,isHTTPSPortAvailableCallback);

}

function isHTTPSPortAvailableCallback() {

    var data = this.req.responseXML;
    var isAvailable = data.getElementsByTagName("return")[0].firstChild.nodeValue;

    if (isAvailable == 'true') {
        // go forward
//        addNewTransportHttps_3();
        getAllkeystoreNames();
    }else {
        wso2.wsf.Util.alertWarning("HTTPS Port Already Exists.\n"+
                     "Please try another port or the System\n"+
                     "generate one.");
        addNewTrasportHTTPSPort();

    }


}

function transportWizardStatus() {
    var objDiv = document.getElementById("divCompleteTransportWizard");

    var strHTML ="<h2>Transport Management Wizard</h2>" +
                 "<fieldset style='border:none;'>" +
                  "<div id='formset'><form>" +
                  "<fieldset>" +
                  "<legend>Transport Selection Status</legend>" +
                  "<div><label>Selected Protocol</label><font color='blue'>HTTPS</font></div>" +  // HTTPS Value being hardcoded
                  "<div><label>Selected Port</label><font color='blue'>"+HTTPS_PORT +"</font></div>" +
                  "<div><label>Selected Keystore</label><font color='blue'>"+ KEYSTORE_FOR_TRANSPORT +"</font></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:addNewTransport_2();return false;' value='< Back'/>" +
                  "<input type='button' onclick='javascript:createHTTPSTransportSOAP();return false;' value='Next >'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);
}



function createHTTPSTransport(objRadio) {
    var checkedRadioObjValue;
    var checkedRadioObj = false;
    for (var i = 0; objRadio.length; i++) {
        if (objRadio[i].checked) {
            checkedRadioObjValue = objRadio[i].value;
            KEYSTORE_FOR_TRANSPORT = checkedRadioObjValue;
            checkedRadioObj = true;
            break;
        }

        if (objRadio[i] == (objRadio.length - 1)) {
            wso2.wsf.Util.alertWarning("Please select a keystore to continue.");
        }
    }
    if (checkedRadioObj) {
        checkedRadioObj = false;
        transportWizardStatus();
    }

}

function createHTTPSTransportSOAP() {
    var body_xml = '<ns1:createHTTPSTransportRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<keyStoreName>'+ KEYSTORE_FOR_TRANSPORT+'</keyStoreName>'+
                   '<port>'+ HTTPS_PORT+'</port>'+
                   '</ns1:createHTTPSTransportRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "createHTTPSTransport";
    new wso2.wsf.WSRequest(callURL,"createHTTPSTransport",body_xml,createHTTPSTransportSOAPCallback);
}

function createHTTPSTransportSOAPCallback() {

    var data = this.req.responseXML;
    var listenerstatus = data.getElementsByTagName("return")[0].firstChild.nodeValue;


    finishTranportSetting(listenerstatus);
}

function finishTranportSetting(datum) {
    var objDiv = document.getElementById("divFinishTransporSetting");
    /*"<h4><a href='#' onClick='javascript:showEndpoints(); return false;'>Endpoint Management</a>"+
  "</a>&nbsp;&gt;&nbsp;Add Endpoint</h4>" +*/
    var strHTML = "<h2>Transport Management Wizard</h2>"+
                  "<fieldset style='border:none;'>" +
                  "<div id='formset'>" +
                  "<form>" +
                  "<fieldset>" +
                  "<legend>Listener Status</legend>" +
                  "<div><h3>"+ datum +"</h3></div>" +
                  "<div class='buttonrow'>" +
                  "<input type='button' onclick='javascript:showTransports();return false;' value='Finish'/>" +
                  "</div>" +
                  "</fieldset>" +
                  "</form>" +
                  "</div>" +
                  "</fieldset>";

    objDiv.innerHTML = strHTML;
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

function getTransportDetails(transportProtocol) {
    
    var body_xml = '<ns1:getTransportDetailsRequest xmlns:ns1="http://org.apache.axis2/xsd">' +
                   '<transportProtocol>'+transportProtocol+'</transportProtocol>'+
                   '</ns1:getTransportDetailsRequest>';

    var callURL = serverURL + "/" + TRANSPORT_ADMIN + "/" + "getTransportDetails";
    new wso2.wsf.WSRequest(callURL,"getTransportDetails",body_xml,showTreeBranch);

}
