/*
statistics.js contains scripts pertaining to handle WSO2 WSAS statistics data
*/

var showDivStatistics = false;

var showDivStatisticsTimeout;

var showDivInterval = 0;

var showGraphDivHome = false;
var showGraphDivInterval = 0;

// Memory
var graphUsedMemoryArrayObj;
var graphTotalMemoryArrayObj;

// Response Times

var graphMaxResponseTimeArrayObj;
var graphMinResponseTimeArrayObj;
var graphAvgResponsetimeArrayObj;


var REFRESH_GRAPHS = 12000;
var SHOW_STATS_REFRESHING_TIME = 6000;

/*initializing the statistics*/

function showStatisticsInitializer() {
    var tmpTransformationNode;

    if (window.XMLHttpRequest && !wso2.wsf.Util.isIE()) {
        tmpTransformationNode =
        document.implementation.createDocument("", "initializeStatistics", null);
    } else if (window.ActiveXObject) {
        tmpTransformationNode = new ActiveXObject("Microsoft.XmlDom");
        var sXml = "<initializeStatistics></initializeStatistics>";
        tmpTransformationNode.loadXML(sXml);
    }
    var objDiv = document.getElementById("divStatistics");
    wso2.wsf.Util.processXML(tmpTransformationNode, "statistics.xsl", objDiv);
    wso2.wsf.Util.showOnlyOneMain(objDiv);

}

function monitorSystemMenu(thisObj,index) {

    if (thisObj && index) {
        renderSelectedMenuItem(thisObj,index);
        gatherHistoryObject(thisObj.id, index);
    }

    showStatisticsInitializer();

    ///////////////////////
    //Buffer in action
    graphUsedMemoryArrayObj = new QueueForGraphs();
    graphTotalMemoryArrayObj = new QueueForGraphs();
    graphUsedMemoryArrayObj.init();
    graphTotalMemoryArrayObj.init();

    graphAvgResponsetimeArrayObj = new QueueForGraphs();

    graphAvgResponsetimeArrayObj.init();


    //////////////////////

    //Initial Firing
    monitorSystem();
    if (showDivInterval == 0) {
        showDivInterval = setInterval('monitorSystem()', SHOW_STATS_REFRESHING_TIME);
    }
    if (showGraphDivInterval == 0) {
        showGraphDivInterval = setInterval('refreshGraphs()', REFRESH_GRAPHS);
    }

}

function refreshGraphs() {
    if (document.getElementById("divStatistics").style.display == 'none') {
        clearInterval(showGraphDivInterval);
        showGraphDivInterval = 0;
        // this is to counter if focus to divHome is vanished.
        return false;

    }

    var graphObj = document.getElementById('divGraphMemUsageInnerFrame');


    graphObj.src = "extensions/core/graphs.html";
}


function monitorSystem(){

    var body_xml = ' <ns1:getStatus  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

    var callURL = serverURL + "/" + SERVER_ADMIN_STRING + "/" + "getStatus";

    if (document.getElementById("divStatistics").style.display == 'none' &&
        showDivStatistics) {
        showDivStatistics = false;
        clearInterval(showDivInterval);
        showDivInterval = 0;
        // this is to counter if focus to divStatistics is vanished.
        return false;

    }

    new wso2.wsf.WSRequest(callURL,"getStatus",body_xml,monitorSystemCallback);
}

function monitorSystemCallback() {

    showDivStatistics = true;

    try {

        transformationWithoutHistory(this.req.responseXML,"statistics.xsl", document.getElementById("showGlobalStatusTable"));

        var data = this.req.responseXML;
        var memoryUsage = data.getElementsByTagName('usedMemory')[0];
        var memoryUsageValue = memoryUsage.getElementsByTagName('value')[0];

        var allocatedMemory = data.getElementsByTagName('totalMemory')[0];

        graphUsedMemoryArrayObj.add(parseInt(memoryUsageValue.firstChild.nodeValue));
        graphTotalMemoryArrayObj.add(parseInt(allocatedMemory.getElementsByTagName('value')[0].firstChild.nodeValue));

        graphAvgResponsetimeArrayObj.add(parseInt(data.getElementsByTagName('avgResponseTime')[0].firstChild.nodeValue));

    } catch(e) {
        // if encounters an error just stop all refreshing methods
        stoppingRefreshingMethodsHook();
    } finally {

    }

}



