/*
 * Copyright 2005,2007 WSO2, Inc. http://wso2.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var serviceGroupId;
var userNameString;
var numDaysToKeepCookie = 2;
var locationString = self.location.href;


/*two variables to hold the width and the height of the
message box*/
var messageBoxWidth = 300;
var messageBoxHeight = 90;
var warningMessageImage = 'images/oops.gif';
var informationMessageImage = 'images/information.gif';
var warningnMessagebackColor = '#FFC';
var informationMessagebackColor = '#BBF';
var runPoleHash = false;

/*constants for Message types*/
var INFORMATION_MESSAGE = 1;
var WARNING_MESSAGE = 2;

/*== URL and Host. Injected the values using AdminUIServletFilter ==*/
var URL;
var GURL;
var serverURL;
var HTTP_PORT;
var HTTPS_PORT;
var HTTP_URL;
var HOST;
var SERVICE_PATH;
var ROOT_CONTEXT;
/*==================*/

var lastHash;

var userName;

var isServerRestarting = false;

var tabcount = 0;

var tabCharactors = " ";

var requestFromServerPending = false;

/*
 mainMenuObject will be used to hold the <a/> objects, that's been used clicked in main
 menu items.
*/
var mainMenuObjectId = null;
var mainMenuObjectIndex = -1;

var sessionCookieValue;

/*
Everything will be related to wso2 namespace. If wso2 object dosenot present create it first
*/
if (typeof(wso2) == "undefined") {
    var wso2 = {};
}

/*
Create the objects with associative style
*/
wso2.namespace = function() {
    var a = arguments, o = null, i, j, d;
    for (i = 0; i < a.length; i = i + 1) {
        d = a[i].split(".");
        o = wso2;

        // wso2 is implied, so it is ignored if it is included
        for (j = (d[0] == "wso2") ? 1 : 0; j < d.length; j = j + 1) {
            o[d[j]] = o[d[j]] || {};
            o = o[d[j]];
        }
    }

    return o;
};

wso2.init = function() {
    this.namespace("wsf");
}
/*Create only wso2.wsf namespace */
wso2.init();

/*Usage of native WSRequest object*/
wso2.wsf.READY_STATE_UNINITIALIZED = 0;
wso2.wsf.READY_STATE_LOADING = 1;
wso2.wsf.READY_STATE_LOADED = 2;
wso2.wsf.READY_STATE_INTERACTIVE = 3;
wso2.wsf.READY_STATE_COMPLETE = 4;

/**
 * wso2.wsf.WSRequest is the stub that wraps the native WSRequest to invoke a web service.
 * If the onLoad method is given, this will communicate with the web service async. Sync invocation is
 * not burned into this stub.
 *
 * If onError method is undefined, default onError will come into play. onError will be invoked if
 * SOAP fault is received.
 *
 * Usage of onLoad :
 * new wso2.wsf.WSRequest("http://my.web.service","urn:myAction","<foo/>",callback);
 *
 * callback = function(){
 * // to get the response xml call
 * this.req.responseXML
 * //to get the response text call
 * this.req.responseText
 * //if an object needs the values of this.req call
 * bar.call(this,x,y,z);
 * this.params;
 *
 * }
 *
 * @url : Endpoint referece  (EPR)
 * @action : WSA Action for the EPR
 * @payLoad : Pay load to be send
 * @onLoad : Function that should be called when onreadystate has been called
 * @params : Will allow to pass parameters to the callback and later can be used
 * @onError : Function that should be called when an error or SOAP fault has been received.
 */
wso2.wsf.WSRequest = function(url, action, payLoad, onLoad, params, onError) {
    this.url = url;
    this.payLoad = payLoad;
    this.params = params;
    this.onLoad = (onLoad) ? onLoad : this.defaultOnLoad;
    this.onError = (onError) ? onError : this.defaultError;
    this.req = null;
    this.options = new Array();
    this.options["useBindng"] = "SOAP 1.1";
    this.options["action"] = this._parseAction(action);
    this.loadXMLDoc();
}

wso2.wsf.WSRequest.prototype = {
    /**
     * Action should be a valid URI
     */
    _parseAction : function(action) {
        if (!action) {
            return '""';
        }

        if (action.indexOf("urn:") > -1 ||
            action.indexOf("URN:") > -1 ||
            action.indexOf("http://") > -1) {
            return action;
        }
        return "urn:" + action;

    },
    defaultError : function() {
        var error = this.req.error;
        if (!error) {
            var reason = "";
            var a = arguments;
            if (a.length > 0) {
                reason = a[0];
            }
            // This is to fix problems encountered in Windows browsers.
            var status = this.req._xmlhttp.status;
            if (status && status == 500) {
                return;
            } else {
                wso2.wsf.Util.alertWarning("Console has received an error. Please refer" +
                                           " to system admin for more details. " +
                                           reason.toString());
            }

            if (typeof(stoppingRefreshingMethodsHook) != "undefined" &&
                typeof(logoutVisual) != "undefined") {
                stoppingRefreshingMethodsHook();
                logoutVisual();
            }
            return;
        }

        if (error.reason != null) {
            if (typeof (error.reason.indexOf) != "undefined") {
                if (error.reason.indexOf("Access Denied. Please login first") > -1) {
                    if (typeof(stoppingRefreshingMethodsHook) != "undefined" &&
                        typeof(logoutVisual) != "undefined") {
                        stoppingRefreshingMethodsHook();
                        logoutVisual();
                    }
                }
            }
        }

        if (error.detail != null) {
            if (typeof (error.detail.indexOf) != "undefined") {
                if (error.detail.indexOf("NS_ERROR_NOT_AVAILABLE") > -1) {
                    if (typeof(stoppingRefreshingMethodsHook) != "undefined" &&
                        typeof(logoutVisual) != "undefined") {
                        stoppingRefreshingMethodsHook();
                        logoutVisual();
                    }
                }
            }
        }

        wso2.wsf.Util.alertWarning(error.reason);

    },

    defaultOnLoad : function() {
        /*default onLoad is reached and do not do anything.*/
    },

    loadXMLDoc : function() {
        try {
            stopWaitAnimation(); /*This will stop the wait animation if consecutive requests are made.*/
            this.req = new WSRequest();
            var loader = this;
            if (this.req) {
                executeWaitAnimation();
                this.req.onreadystatechange = function() {
                    loader.onReadyState.call(loader);
                }
                this.req.open(this.options, this.url, true);
                this.req.send(this.payLoad);
            } else {
                stopWaitAnimation()
                wso2.wsf.Util.alertWarning("Native XMLHttpRequest can not be found.")
            }
        } catch(e) {
            stopWaitAnimation();
            wso2.wsf.Util.alertWarning("Erro occured while communicating with the server " +
                                       e.toString());
        }

    },

    onReadyState : function() {
        try {
            var ready = this.req.readyState;
            if (ready == wso2.wsf.READY_STATE_COMPLETE) {
                wso2.wsf.Util.cursorClear();
                stopWaitAnimation();
                var httpStatus = this.req._xmlhttp.status;
                if (httpStatus == 200 || httpStatus == 202) {
                    this.onLoad.call(this);
                } else if (httpStatus >= 400) {
                    this.onError.call(this);
                }
            }
        } catch(e) {
            wso2.wsf.Util.cursorClear();
            stopWaitAnimation();
            this.onError.call(this,e);
        }
    }
};


/*
Utility class
*/
wso2.wsf.Util = {
    _msxml : [
            'MSXML2.XMLHTTP.3.0',
            'MSXML2.XMLHTTP',
            'Microsoft.XMLHTTP'
            ],

    getBrowser : function() {
        var ua = navigator.userAgent.toLowerCase();
        if (ua.indexOf('opera') != -1) { // Opera (check first in case of spoof)
            return 'opera';
        } else if (ua.indexOf('msie 7') != -1) { // IE7
            return 'ie7';
        } else if (ua.indexOf('msie') != -1) { // IE
            return 'ie';
        } else if (ua.indexOf('safari') !=
                   -1) { // Safari (check before Gecko because it includes "like Gecko")
            return 'safari';
        } else if (ua.indexOf('gecko') != -1) { // Gecko
            return 'gecko';
        } else {
            return false;
        }
    },
    createXMLHttpRequest : function() {
        var xhrObject;

        try {
            xhrObject = new XMLHttpRequest();
        } catch(e) {
            for (var i = 0; i < this._msxml.length; ++i) {
                try
                {
                    // Instantiates XMLHttpRequest for IE and assign to http.
                    xhrObject = new ActiveXObject(this._msxml[i]);
                    break;
                }
                catch(e) {
                    // do nothing
                }
            }
        } finally {
            return xhrObject;
        }
    },

    isIESupported : function() {
        var browser = this.getBrowser();
        if (this.isIEXMLSupported() && (browser == "ie" || browser == "ie7")) {
            return true;
        }

        return false;

    },

    isIEXMLSupported: function() {
        if (!window.ActiveXObject) {
            return false;
        }
        try {
            new ActiveXObject("Microsoft.XMLDOM");
            return true;

        } catch(e) {
            return false;
        }
    },

/*
This function will be used as an xml to html
transformation helper in callback objects. Works only with wso2.wsf.WSRequest.
@param xml : XML document
@param xsltFile : XSLT file
@param objDiv  : Div that trasformation should be applied
@param doNotLoadDiv : flag that store the div in browser history
@param isAbsPath : If xsltFile is absolute, then isAbsPath should be true
*/
    callbackhelper : function(xml, xsltFile, objDiv, doNotLoadDiv, isAbsPath) {
        this.processXML(xml, xsltFile, objDiv, isAbsPath);
        if (!doNotLoadDiv) {
            this.showOnlyOneMain(objDiv);
        }

    },

/*
@parm xml : DOM document that needed to be transformed
@param xslFileName : XSLT file name. This could be foo.xsl, which is reside in /extensions/core/js
                     or bar/car/foo.xsl. If the later version is used, the isAbstPath should be true.
@param objDiv : Div object, the transformed fragment will be append to it.
@param isAbsPath : Used to indicate whether the usr provided is a absolute path.

*/
    processXML : function (xml, xslFileName, objDiv, isAbsPath) {
        var xsltHelperObj = new wso2.wsf.XSLTHelper();
        xsltHelperObj.transform(objDiv, xml, xslFileName, isAbsPath);
    },

/*
Login method
*/
    login :function(userName, password, callbackFunction) {

        if (typeof(callbackFunction) != "function") {
            this.alertWarning("Login can not be continued due to technical errors.");
            return;
        }

        var bodyXML = ' <ns1:login  xmlns:ns1="http://org.apache.axis2/xsd">\n' +
                      ' <arg0>' + userName + '</arg0>\n' +
                      ' <arg1>' + password + '</arg1>\n' +
                      ' </ns1:login>\n';
        var callURL = serverURL + "/" + GLOBAL_SERVICE_STRING + "/" + "login";

        new wso2.wsf.WSRequest(callURL, "urn:login", bodyXML, callbackFunction);

    },
/*
Logout method
*/
    logout : function(callbackFunction) {
        // stopping all refressing methods
        stoppingRefreshingMethodsHook();
        historyStorage.reset();
        var bodyXML = ' <ns1:logout  xmlns:ns1="http://org.apache.axis2/xsd"/>\n';

        var callURL = serverURL + "/" + GLOBAL_SERVICE_STRING + "/" + "logout";
        new wso2.wsf.WSRequest(callURL, "urn:logout", bodyXML, callbackFunction);
    },
/*
This method will store the given the div in the browser history
@param objDiv : Div that needed to be stored.
@param isReloadDiv : div is restored.
*/
    showOnlyOneMain : function(objDiv, isReloadDiv) {
        if (objDiv == null)
            return;

        var par = objDiv.parentNode;

        var len = par.childNodes.length;
        var count;
        for (count = 0; count < len; count++) {
            if (par.childNodes[count].nodeName == "DIV") {
                par.childNodes[count].style.display = 'none';
            }
        }
        objDiv.style.display = 'inline';
        var output = objDiv.attributes;
        var attLen = output.length;
        var c;
        var divNameStr;
        for (c = 0; c < attLen; c++) {
            if (output[c].name == 'id') {
                divNameStr = output[c].value;
            }
        }
        //alert(divNameStr);
        this.setDivTabsToMinus(objDiv);
        this._storeDiv(divNameStr, isReloadDiv)
    },

    _storeDiv : function(divName, isReloadDiv) {
        if (lastHash != "___" + divName) {
            if (!isReloadDiv) {
                lastHash = "___" + divName;
                //alert("Storing div " + lastHash);
                if (mainMenuObjectId != null && mainMenuObjectIndex != -1) {
                    dhtmlHistory.add(lastHash,
                    {menuObj:mainMenuObjectId + ':' + mainMenuObjectIndex});

                } else {
                    dhtmlHistory.add(lastHash, true);
                }
            }
        }
    },

/*
This will set all the tabindexes in all the child divs to -1.
This way no div will get focus  when some one is tabbing around.
@parm objDiv : parent div
*/
    setDivTabsToMinus : function (objDiv) {
        var divs = objDiv.getElementsByTagName("div");
        for (var index = 0; index < divs.length; index++) {
            divs[index].setAttribute("tabindex", "-1");
        }
    },

/*
 Set a cookie.
 @param name : Cookie name
 @param value : Cookie value
 @param expires : Date of expire
 @param secure: If the given cookie should be secure.

*/
    setCookie : function(name, value, expires, secure) {
        document.cookie = name + "=" + escape(value) +
                          ((expires) ? "; expires=" + expires.toGMTString() : "") +
                          ((secure) ? "; secure" : "");
    },

/*
Get Cookie value.
@param name : Cookie name
*/
    getCookie : function (name) {
        var dc = document.cookie;
        var prefix = name + "=";
        var begin = dc.indexOf("; " + prefix);
        if (begin == -1) {
            begin = dc.indexOf(prefix);
            if (begin != 0) return null;
        } else {
            begin += 2;
        }
        var end = document.cookie.indexOf(";", begin);
        if (end == -1) {
            end = dc.length;
        }
        return unescape(dc.substring(begin + prefix.length, end));
    },

/*
Delete a Cookie.
@param name : Cookie name
*/
    deleteCookie : function(name) {
        document.cookie = name + "=" + "; EXPIRES=Thu, 01-Jan-70 00:00:01 GMT";

    },
/*
Given DOM document will be serialized into a String.
@param paylod : DOM payload.
*/
    xmlSerializerToString : function (payload) {
        var browser = this.getBrowser();

        switch (browser) {
            case "gecko":
                var serializer = new XMLSerializer();
                return serializer.serializeToString(payload);
                break;
            case "ie":
                return payload.xml;
                break;
            case "ie7":
                return payload.xml;
                break;
            case "opera":
                var xmlSerializer = document.implementation.createLSSerializer();
                return xmlSerializer.writeToString(payload);
                break;
            case "safari":
            // use the safari method
                throw new Error("Not implemented");
            case "undefined":
                throw new Error("XMLHttp object could not be created");
        }
    },

/*
Check if the give the brower is IE
*/
    isIE : function() {
        return this.isIESupported();
    },

/*
   This method will restart the server.
*/
    restartServer : function (callbackFunction) {
        var msgStat = confirm("Do you want to restart the server?");
        if(!msgStat){
            return;
        }

        var bodyXML = '<req:restartRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

        var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
        if (callbackFunction && (typeof(callbackFunction) == "function")) {
            new wso2.wsf.WSRequest(callURL, "urn:restart", bodyXML, callbackFunction);
        } else {
            new wso2.wsf.WSRequest(callURL, "urn:restart", bodyXML, wso2.wsf.Util.restartServer["callback"]);
        }
    },

/*
   This method will restart the server gracefully.
*/
    restartServerGracefully : function (callbackFunction) {
        var msgStat = confirm("Do you want to gracefully restart the server?");
        if(!msgStat){
            return;
        }
        var bodyXML = '<req:restartGracefullyRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

        var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
        if (callbackFunction && (typeof(callbackFunction) == "function")) {
            new wso2.wsf.WSRequest(callURL, "urn:restartGracefully", bodyXML, callbackFunction);
        } else {
            new wso2.wsf.WSRequest(callURL, "urn:restartGracefully", bodyXML, wso2.wsf.Util.restartServerGracefully["callback"]);
        }
    },

/*
   This method will shutdown the server gracefully.
*/
    shutdownServerGracefully : function (callbackFunction) {
        var msgStat = confirm("Do you want to gracefully shutdown the server?");
        if(!msgStat){
            return;
        }
        var bodyXML = '<req:shutdownGracefullyRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

        var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
        if (callbackFunction && (typeof(callbackFunction) == "function")) {
            new wso2.wsf.WSRequest(callURL, "urn:shutdownGracefully", bodyXML, callbackFunction);
        } else {
            new wso2.wsf.WSRequest(callURL, "urn:shutdownGracefully", bodyXML, wso2.wsf.Util.shutdownServerGracefully["callback"]);
        }
    },

/*
   This method will shutdown the server immediately.
*/
    shutdownServer : function (callbackFunction) {
        var msgStat = confirm("Do you want to shutdown the server?");
        if(!msgStat){
            return;
        }
        var bodyXML = '<req:shutdownRequest xmlns:req="http://org.apache.axis2/xsd"/>\n';

        var callURL = serverURL + "/" + ADMIN_SERVER_URL ;
        if (callbackFunction && (typeof(callbackFunction) == "function")) {
            new wso2.wsf.WSRequest(callURL, "urn:shutdown", bodyXML, callbackFunction);
        } else {
            new wso2.wsf.WSRequest(callURL, "urn:shutdown", bodyXML, wso2.wsf.Util.shutdownServer["callback"]);
        }
    },

/*
Trim the give string
*/
    trim: function (strToTrim) {
        return(strToTrim.replace(/^\s+|\s+$/g, ''));
    },

/*
Busy cursor
*/
    cursorWait : function () {
        document.body.style.cursor = 'wait';
    },

/*
Normal cursor
*/
    cursorClear : function() {
        document.body.style.cursor = 'default';
    },

/*
Open a new window and show the results
*/
    openWindow : function(value) {
        // This will return a String of foo/bar/ OR foo/bar/Foo
        window.open(serviceURL + '/' + value);
    },

/*
Propmpt a prompt box
*/
    getUserInput : function() {
        return this.getUserInputCustum("Please enter the parameter name", "Please enter the parameter value for ", true);
    },

/*
Will use the promt provided by the user prompting for parameters. If the
useParamNameInPrompt is true then the param value prompt will be appended
the paramName to the back of the paramValuePrompt value.
*/

    getUserInputCustum : function (paramNamePrompt, paramValuePrompt, useParamNameInPrompt) {
        var returnArray = new Array();
        var tempValue = window.prompt(paramNamePrompt);
        if (tempValue == '' || tempValue == null) {
            return null;
        }
        returnArray[0] = tempValue;
        if (useParamNameInPrompt) {
            tempValue = window.prompt(paramValuePrompt + returnArray[0]);
        } else {
            tempValue = window.prompt(paramValuePrompt);
        }
        if (tempValue == '' || tempValue == null) {
            return null;
        }
        returnArray[1] = tempValue;
        return returnArray;
    },

/*
Show Response
*/
    showResponseMessage : function (response) {
        var returnStore = response.getElementsByTagName("return")[0];
        this.alertMessage(returnStore.firstChild.nodeValue);
    },

/*shows the a custom alert box public*/
    alertInternal : function (message, style) {

        var messageBox = document.getElementById('alertMessageBox');
        var messageBoxTextArea = document.getElementById('alertMessageBoxMessageArea');
        //var messageBoxImage = document.getElementById('alertMessageBoxImg');alertMessageBox
        //set the left and top positions

        var theWidth;
        if (window.innerWidth)
        {
            theWidth = window.innerWidth
        }
        else if (document.documentElement && document.documentElement.clientWidth)
        {
            theWidth = document.documentElement.clientWidth
        }
        else if (document.body)
        {
            theWidth = document.body.clientWidth
        }

        var theHeight;
        if (window.innerHeight)
        {
            theHeight = window.innerHeight
        }
        else if (document.documentElement && document.documentElement.clientHeight)
        {
            theHeight = document.documentElement.clientHeight
        }
        else if (document.body)
        {
            theHeight = document.body.clientHeight
        }

        var leftPosition = theWidth / 2 - messageBoxWidth / 2 ;
        var topPosition = theHeight / 2 - messageBoxHeight / 2;
        var bkgr;
        messageBox.style.left = leftPosition + 'px';
        messageBox.style.top = topPosition + 'px';
        //set the width and height
        messageBox.style.width = messageBoxWidth + 'px';
        //    messageBox.style.height = messageBoxHeight+ 'px';

        //set the pictures depending on the style
        if (style == WARNING_MESSAGE) {
            bkgr =
            "url(" + warningMessageImage + ") " + warningnMessagebackColor + " no-repeat 15px 17px";
        } else if (style == INFORMATION_MESSAGE) {
            bkgr = "url(" + informationMessageImage + ") " + informationMessagebackColor +
                   " no-repeat 15px 17px";
        }
        messageBox.style.background = bkgr;
        //set the message
        messageBoxTextArea.innerHTML = message;
        messageBox.style.display = 'inline';
        document.getElementById('alertBoxButton').focus();
        return false;
    },

/*
Convenience methods that call the alertInternal
show a information message
*/
    alertMessage : function (message) {
        this.alertInternal(message, INFORMATION_MESSAGE);
    },

/*
Show a warning message
*/
    alertWarning : function (message) {
        var indexOfExceptionMsg = message.indexOf('; nested exception is: ');
        if (indexOfExceptionMsg != -1) {
            message = message.substring(0, indexOfExceptionMsg);
        }
        this.alertInternal(message, WARNING_MESSAGE);
    },

/*
Find the host and assingend it to HOST
*/
    initURLs : function() {
        var locationHref = self.location.href;

        var tmp1 = locationHref.indexOf("://");
        var tmp2 = locationHref.substring(tmp1 + 3);
        var tmp3 = tmp2.indexOf(":");
        if (tmp3 > -1) {
            HOST = tmp2.substring(0, tmp3);
        } else {
            tmp3 = tmp2.indexOf("/");
            HOST = tmp2.substring(0, tmp3);
        }

        URL = "https://" + HOST +
              (HTTPS_PORT != 443 ? (":" + HTTPS_PORT + ROOT_CONTEXT)  : ROOT_CONTEXT);
        GURL = "http://" + HOST +
              (HTTP_PORT != 80 ? (":" + HTTP_PORT + ROOT_CONTEXT)  : ROOT_CONTEXT);

        HTTP_URL = "http://" + HOST +
                   (HTTP_PORT != 80 ? (":" + HTTP_PORT + ROOT_CONTEXT)  : ROOT_CONTEXT) +
                   "/" + SERVICE_PATH;
        serverURL = "https://" + HOST +
                    (HTTPS_PORT != 443 ? (":" + HTTPS_PORT + ROOT_CONTEXT)  : ROOT_CONTEXT) +
                    "/" + SERVICE_PATH;

    },

    getProtocol : function() {
        var _tmpURL = locationString.substring(0, locationString.lastIndexOf('/'));
        if (_tmpURL.indexOf('https') > -1) {
            return 'https';
        } else if (_tmpURL.indexOf('http') > -1) {
            return 'http';
        } else {
            return null;
        }
    },

    getServerURL : function() {
        var _tmpURL = locationString.substring(0, locationString.lastIndexOf('/'));
        if (_tmpURL.indexOf('https') == -1) {
            return HTTP_URL;
        }
        return serverURL;
    }
};


/*
XSLT helper will be used to communicate with a server and aquire XSLT resource. The communication will
be sync. This will quire the resource with reference to the brower it will be injected.

XSLT helper caches the loaded XSLT documents. In order to initiate, Used has to first call the,
wso2.wsf.XSLTHelper.init() method in window.onLoad.

*/
wso2.wsf.XSLTHelper = function() {
    this.req = null;
}
/*
 xslName is add to the array
*/
wso2.wsf.XSLTHelper.xsltCache = null;

wso2.wsf.XSLTHelper.init = function() {
    wso2.wsf.XSLTHelper.xsltCache = new Array();
}

wso2.wsf.XSLTHelper.add = function(xslName, xslObj) {
    wso2.wsf.XSLTHelper.xsltCache[xslName] = xslObj;
}
wso2.wsf.XSLTHelper.get = function(xslName) {
    return wso2.wsf.XSLTHelper.xsltCache[xslName];
}

wso2.wsf.XSLTHelper.prototype = {
    load : function(url, fileName, params) {
        try {
            if (window.XMLHttpRequest && window.XSLTProcessor) {
                this.req = new XMLHttpRequest();
                this.req.open("GET", url, false);
                //Sync call
                this.req.send(null);
                var httpStatus = this.req.status;
                if (httpStatus == 200) {
                    wso2.wsf.XSLTHelper.add(fileName, this.req.responseXML);
                } else {
                    this.defaultError.call(this);
                }

            } else if (window.ActiveXObject) {
                try {
                    this.req = new ActiveXObject("Microsoft.XMLDOM");
                    this.req.async = false;
                    this.req.load(url);
                    wso2.wsf.XSLTHelper.add(fileName, this.req);
                } catch(e) {
                    wso2.wsf.Util.alertWarning("Encounterd an error  : " + e);
                }
            }

        } catch(e) {
            this.defaultError.call(this);
        }

    },

    defaultError : function() {
        wso2.wsf.Util.alertWarning("Error Fetching XSLT file.")
    },

    transformMozilla : function(container, xmlDoc, fileName, isAbsPath, xslExtension, params) {
        var xslStyleSheet = wso2.wsf.XSLTHelper.get(fileName);
        if (xslStyleSheet == undefined) {
            var url = this.calculateURL(fileName, isAbsPath, xslExtension);
            this.load(url, fileName, params);
        }
        xslStyleSheet = wso2.wsf.XSLTHelper.get(fileName);
        if (xslStyleSheet == undefined || xslStyleSheet == null) {
            wso2.wsf.Util.alertWarning("XSL Style Sheet is not available");
            return;
        }

        try {
            var xsltProcessor = new XSLTProcessor();

            if (params) {
                var len = params.length;
                for (var i = 0; i < len; i++) {
                    xsltProcessor.setParameter(null, params[i][0], params[i][1]);
                }

            }
            xsltProcessor.importStylesheet(xslStyleSheet);
            var fragment = xsltProcessor.transformToFragment(xmlDoc, document);

            container.innerHTML = "";
            container.appendChild(fragment);
        } catch(e) {
          //  wso2.wsf.Util.alertWarning("Encounterd an error  : " + e.toString());
        }
    },

    transformIE : function(container, xmlDoc, fileName, isAbsPath, xslExtension, params) {
        try {
            if (params) {
                var url = this.calculateURL(fileName, isAbsPath, xslExtension);
                // declare the local variables
                var xslDoc, docProcessor, docCache, docFragment;
                // instantiate and load the xsl document
                xslDoc = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
                xslDoc.async = false;
                xslDoc.load(url);

                // prepare the xsl document for transformation
                docCache = new ActiveXObject("MSXML2.XSLTemplate");
                docCache.stylesheet = xslDoc;
                // instantiate the document processor and submit the xml document
                docProcessor = docCache.createProcessor();
                docProcessor.input = xmlDoc;
                // add parameters to the xsl document
                var len = params.length;
                for (var i = 0; i < len; i++) {
                    docProcessor.addParameter(params[i][0], params[i][1], "");
                }
                // process the documents into html and submit to the passed div to the HMTL page
                docProcessor.transform();
                // divID.innerHTML = docProcessor.output;
                container.innerHTML = "<div>" + docProcessor.output + "</div>";

            } else {
                var xslStyleSheet = wso2.wsf.XSLTHelper.get(fileName);
                if (xslStyleSheet == undefined) {
                    var url = this.calculateURL(fileName, isAbsPath, xslExtension);
                    this.load(url, fileName);
                }
                xslStyleSheet = wso2.wsf.XSLTHelper.get(fileName);
                if (xslStyleSheet == undefined || xslStyleSheet == null) {
                    wso2.wsf.Util.alertWarning("XSL Style Sheet is not available");
                    return;
                }
                var fragment = xmlDoc.transformNode(xslStyleSheet);
                container.innerHTML = "<div>" + fragment + "</div>";
            }
        } catch(e) {
            wso2.wsf.Util.alertWarning("Encounterd an error  : " + e.toString());
        }

    },

    calculateURL : function (fileName, isAbsPath, xslExtension) {
        var fullPath;

        if (!xslExtension) {
            xslExtension = 'core';
        }

        if (isAbsPath) {
            fullPath = fileName;
            return fullPath;
        }

        //        fullPath = URL + "/extensions/" + xslExtension + "/xslt/" + fileName;
        /*Using the relative paths to obtain XSLT*/
        fullPath = "extensions/" + xslExtension + "/xslt/" + fileName;

        return fullPath;

    },

/**
 * @param container : DIV object. After transformation generated HTML will be injected to this location.
 * @param xmlDoc    : XML DOM Document.
 * @param fileName  : XSL file name. Make sure this being unique
 * @param isAbsPath : Used to indicate whether the usr provided is a absolute path. This is needed to reuse this
 method from outside the admin service.
 * @param xslExtension : Extension location
 * @param params : An array containing params that needed to be injected when doing transformation.
 ex: var param = new Array(["fooKey","fooValue"]);
 thus, "fooKey" will be used for find the parameter name and fooValue will be set
 as the parameter value.
 */
    transform : function(container, xmlDoc, fileName, isAbsPath, xslExtension, params) {
        if (!this.isXSLTSupported()) {
            wso2.wsf.Util.alertWarning("This browser does not support XSLT");
            return;
        }

        if (window.XMLHttpRequest && window.XSLTProcessor) {
            this.transformMozilla(container, xmlDoc, fileName, isAbsPath, xslExtension, params);

        } else if (window.ActiveXObject) {
            this.transformIE(container, xmlDoc, fileName, isAbsPath, xslExtension, params);
        }


    },
    isXSLTSupported : function() {
        return (window.XMLHttpRequest && window.XSLTProcessor) || wso2.wsf.Util.isIEXMLSupported();

    }

};


///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
/*
All the inline function found after this point onwards are titly bound with
the index.html template and users are not encourage to use them. If users want
to use them, they should do it with their own risk.
*/


/*public */
function finishLogin() {
    //new one;
    userNameString = "<nobr>Signed in as <strong>" + userName +
                     "</strong>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='about.html' target='_blank'>About</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='docs/index_docs.html' target='_blank'>Docs</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a id='logOutA' href='#' onclick='javascript:wso2.wsf.Util.logout(wso2.wsf.Util.logout[\"callback\"]); return false;'>Sign Out</a></nobr>";
    document.getElementById("meta").innerHTML = userNameString;
    document.getElementById("navigation_general").style.display = "none";
    document.getElementById("navigation_logged_in").style.display = "inline";
    document.getElementById("content").style.display = "inline";
    updateRegisterLink();
}

/*private*/
function updateRegisterLink() {


    var bodyXML = ' <ns1:isServerRegistered xmlns:ns1="http://org.apache.axis2/xsd"/>';
    var callURL = serverURL + "/" + GLOBAL_SERVICE_STRING ;
    new wso2.wsf.WSRequest(callURL, "urn:isServerRegistered", bodyXML, updateRegisterLink["callback"]);
}

updateRegisterLink["callback"] = function() {
    if (this.req.responseXML.getElementsByTagName("return")[0].firstChild.nodeValue != "true") {
        document.getElementById("meta").innerHTML +=
        "&nbsp;&nbsp;|&nbsp;&nbsp;<a href='#' onclick='javascript:registerProduct(); return false;'>Register</a>";
    }
    runPoleHash = true;
//    initialize();
    showHomeMenu();

}

/*private*/
function loginFail() {
    wso2.wsf.Util.alertWarning("Login failed. Please recheck the user name and password and try again.");
}

/*public*/
function registerProduct() {
    var bodyXML = ' <ns1:getServerData xmlns:ns1="http://org.apache.axis2/xsd"/>';

    var callURL = serverURL + "/" + SERVER_ADMIN_STRING ;
    new wso2.wsf.WSRequest(callURL, "urn:getServerData", bodyXML, registerProductCallback);
}


wso2.wsf.Util.login["callback"] = function() {
    var isLogInDone = this.req.responseXML.getElementsByTagName("return")[0].firstChild.nodeValue;
    if (isLogInDone != "true") {
        loginFail();
        return;
    }
    userName = document.formLogin.txtUserName.value;
    if (userName) {
        wso2.wsf.Util.setCookie("userName", userName);
    }
    finishLogin();
}


/*private*/
wso2.wsf.Util.logout["callback"] = function() {
    runPoleHash = false;
    logoutVisual();

}

wso2.wsf.Util.restartServer["callback"] = function() {
    logoutVisual();
    stopWaitAnimation();
    wso2.wsf.Util.alertMessage("The server is being restarted. <br/> This will take a few seconds. ");
    // stopping all refressing methods
    stoppingRefreshingMethodsHook();

}

wso2.wsf.Util.restartServerGracefully["callback"] = function() {
    logoutVisual();
    stopWaitAnimation();
    wso2.wsf.Util.alertMessage("The server is being gracefully restarted. <br/> This will take a few seconds. ");
    // stopping all refressing methods
    stoppingRefreshingMethodsHook();

}

wso2.wsf.Util.shutdownServerGracefully["callback"] = function() {
    logoutVisual();
    stopWaitAnimation();
    wso2.wsf.Util.alertMessage("The server is being gracefully shutdown. <br/> This will take a few seconds. ");
    // stopping all refressing methods
    stoppingRefreshingMethodsHook();

}

wso2.wsf.Util.shutdownServer["callback"] = function() {
    logoutVisual();
    stopWaitAnimation();
    wso2.wsf.Util.alertMessage("The server is being shutdown.");
    // stopping all refressing methods
    stoppingRefreshingMethodsHook();

}

/*private*/
function logoutVisual() {
    serviceGroupId = "";
    //    deleteCookie("serviceGroupId");
    //    deleteCookie("userName");

    wso2.wsf.Util.deleteCookie("JSESSIONID");

    document.formLogin.txtUserName.value = "";
    document.formLogin.txtPassword.value = "";
    //document.getElementById("container").style.display = "none";
    //document.getElementById("userGreeting").style.display = "none";
    document.getElementById("navigation_general").style.display = "inline";
    document.getElementById("navigation_logged_in").style.display = "none";
    document.getElementById("meta").innerHTML = "<nobr><a href='about.html' target='_blank'>About</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='docs/index_docs.html' target='_blank'>Docs</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a id='logInA' href='#' onclick='javascript:wsasLogin(); return false;'>Sign In</a></nobr>";
    if (typeof(showGeneralHome) != "undefined" && typeof(showGeneralHome) == "function") {
        showLoginPage();
        historyStorage.reset();
    }
}


var waitAnimationInterval;
var waitCount = 0;
/*private*/
function executeWaitAnimation() {
    waitAnimationInterval = setInterval(function() {
        updateWaitAnimation();
    }, 200);

}
/*private*/
function stopWaitAnimation() {
    clearInterval(waitAnimationInterval);
    waitCount = 4;
    //document.getElementById("waitAnimationDiv").style.display = "none";
    var divObj = document.getElementById("waitAnimationDiv");
    if (divObj) {
        divObj.style.background = "url(images/orange_circles.gif) transparent no-repeat left top;";
        divObj.style.padding = "0;";
    }
}

/*private*/
function startWaitAnimation() {
    var divToUpdate = document.getElementById("waitAnimationDiv");
    //alert("startWaitAnimation" + divToUpdate);
    if (divToUpdate != null) {
        divToUpdate.style.display = "inline";
        waitAnimationTimeout();
    }
}

/*private */
function updateWaitAnimation() {
    var divToUpdate = document.getElementById("waitAnimationDiv");
    if (divToUpdate != null) {
        if (waitCount == 8) {
            waitCount = 1;
        } else {
            waitCount++;
        }
        divToUpdate.style.background =
        "url(images/waiting_ani_" + waitCount + ".gif) transparent no-repeat left top;";
        document.getElementById("waitAnimationDiv").style.padding = "0;";
    }
}
/* History tracking code
   Underline project has to implement handleHistoryChange function.
*/
/*private*/
function initialize() {
    // initialize our DHTML history
    dhtmlHistory.initialize();
    historyStorage.reset();
    // subscribe to DHTML history change
    // events
    dhtmlHistory.addListener(
            handleHistoryChange);
}

/*public*/
function openExtraWindow(firstValue, lastValue) {
    window.open(firstValue + serviceURL + "/" + lastValue);
}

/*
	All functions of this nature will return the first value it finds. So do now use when you know that
	there can be more than one item that match (elementName + attName + attValue).
*/
/*public*/
function getElementWithAttribute(elementName, attName, attValue, parentObj) {
    var objList = parentObj.getElementsByTagName(elementName);
    if (objList.length > 0) {
        for (var d = 0; d < objList.length; d++) {
            if (attValue == getAttbute(attName, objList[d])) {
                return objList[d];
            }
        }
    } else {
        return null;
    }
}
/*
 * Will return the attribute values of the named attribute from the
 * object that is passed in.
 */
/*public*/
function getAttbute(attrName, objRef) {
    var attObj = getAttbuteObject(attrName, objRef);
    if (attObj != null) {
        return attObj.value;
    } else {
        return null;
    }
}

/*
 * Will return the attribute object of the named attribute from the
 * object[objRef] that is passed in.
 */
/*publc*/
function getAttbuteObject(attrName, objRef) {
    var output = objRef.attributes;

    if (output == null) return null;
    var attLen = output.length;
    var c;
    var divNameStr;
    for (c = 0; c < attLen; c++) {
        if (output[c].name == attrName) {
            return output[c];
        }
    }
}

/*
 * Will return a string with all the attributes in a name="value" format
 * seperated with a space.
 */
/*public*/
function getAttributeText(node) {
    var text_attributes = "";
    var output = node.attributes;
    if (output == null) return "";
    var attLen = output.length;
    var c;
    var divNameStr;
    for (c = 0; c < attLen; c++) {
        // Skiping the special attribute set by us.
        if (output[c].name != "truedomnodename") {
            text_attributes += " " + output[c].name + '="' + output[c].value + '"';
        }
    }
    return text_attributes;
}

/*
 * Will print out the DOM node that is passed into the method.
 * It will also add tabs.
 * If convertToLower is true all tagnames will be converted to lower case.
 */
/*public*/
function prettyPrintDOMNode(domNode, nonFirst, tabToUse, convertToLower) {
    if (!nonFirst) {
        tabcount = 0;
        if (tabToUse == null) {
            tabCharactors = "\t";
        } else {
            tabCharactors = tabToUse;
        }
    }
    if (domNode == null) {
        return "";
    }
    var dom_text = "";
    var dom_node_value = "";
    var len = domNode.childNodes.length;
    if (len > 0) {
        if (domNode.nodeName != "#document") {
            if (nonFirst) {
                dom_text += "\n";
            }
            dom_text += getCurTabs();
            dom_text +=
            "<" + getTrueDOMNodeNameFromNode(domNode, convertToLower) + getAttributeText(domNode) +
            ">";
            tabcount++;
        }
        for (var i = 0; i < len; i++) {
            if (i == 0) {
                dom_text += prettyPrintDOMNode(domNode.childNodes[i], true, "", convertToLower);
            } else {
                dom_text += prettyPrintDOMNode(domNode.childNodes[i], true, "", convertToLower);
            }
        }
        if (domNode.nodeName != "#document") {
            tabcount--;
            if (!(domNode.childNodes.length == 1 && domNode.childNodes[0].nodeName == "#text")) {
                dom_text += "\n" + getCurTabs();
            }
            dom_text += "</" + getTrueDOMNodeNameFromNode(domNode, convertToLower) + ">";
        }

    } else {
        if (domNode.nodeName == "#text") {
            dom_text += domNode.nodeValue;
        }else if (domNode.nodeName == "#comment") {
            dom_text += "\n" + getCurTabs() + "<!--" + domNode.nodeValue + "-->";
        }else {
            dom_text += "\n" +
                        getCurTabs() + "<" + getTrueDOMNodeNameFromNode(domNode, convertToLower) +
                        getAttributeText(domNode) +
                        "/>";
        }
    }
    return dom_text;
}
// This will serialize the first node only.
/*public*/
function nodeStartToText(domNode) {
    if (domNode == null) {
        return "";
    }
    var dom_text = "";
    var len = domNode.childNodes.length;
    if (len > 0) {
        if (domNode.nodeName != "#document") {
            dom_text +=
            "<" + getTrueDOMNodeNameFromNode(domNode) + getAttributeText(domNode) + ">\n";
        }
    } else {
        if (domNode.nodeName == "#text") {
            dom_text += domNode.nodeValue;
        } else {
            dom_text +=
            "<" + getTrueDOMNodeNameFromNode(domNode) + getAttributeText(domNode) + "/>\n";
        }
    }
    return dom_text;
}

/*
 * When creating a new node using document.createElement the new node that
 * is created will have a all capital value when you get the nodeName
 * so to get the correct serialization we set a new attribute named "trueDOMNodeName" on the
 * new elements that are created. This method will check whether there is an attribute set
 * and will return the nodeName accordingly.
 * If convertToLower is true then the node name will be converted into lower case and returned.
 */
/*public*/
function getTrueDOMNodeNameFromNode(objNode, convertToLower) {
    var trueNodeName = getAttbute("truedomnodename", objNode);
    if (trueNodeName == null) {
        trueNodeName = objNode.nodeName;
    }
    if (convertToLower) {
        return trueNodeName.toLowerCase();
    } else {
        return trueNodeName;
    }
}

/*
 * Will return the number of tabs to print for the current node being passed.
 */
/*public*/
function getCurTabs() {
    var tabs_text = "";
    for (var a = 0; a < tabcount; a++) {
        tabs_text += tabCharactors;
    }
    return tabs_text;
}

/*
 * Use to get a node from within an object hierarchy where there are objects
 * with the same name at different levels.
 */
/*public*/
function getNodeFromPath(pathString, domParent) {
    var items = pathString.split("/");
    var restOfThem = "";
    var lastStep = (items.length == 1);

    if (!lastStep) {
        for (var r = 1; r < items.length; r++) {
            restOfThem += items[r] + "/";
        }
        restOfThem = restOfThem.substring(0, restOfThem.length - 1);
    }
    var temp = domParent.getElementsByTagName(items[0]);
    if (temp == null) {
        return null;
    }
    if (temp.length < 1) {
        return null;
    }
    for (var u = 0; u < temp.length; u++) {
        var retEle;
        if (!lastStep) {
            retEle = getNodeFromPath(restOfThem, temp[u]);
        } else {
            retEle = temp[u];
        }
        if (retEle != null) {
            return retEle;
        }
    }
    return null;
}
/** 
   Copyright (c) 2005, Brad Neuberg, bkn3@columbia.edu
   http://codinginparadise.org
   
   Permission is hereby granted, free of charge, to any person obtaining 
   a copy of this software and associated documentation files (the "Software"), 
   to deal in the Software without restriction, including without limitation 
   the rights to use, copy, modify, merge, publish, distribute, sublicense, 
   and/or sell copies of the Software, and to permit persons to whom the 
   Software is furnished to do so, subject to the following conditions:
   
   The above copyright notice and this permission notice shall be 
   included in all copies or substantial portions of the Software.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
   OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR 
   THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   
   The JSON class near the end of this file is
   Copyright 2005, JSON.org
*/

/** An object that provides DHTML history, history data, and bookmarking 
    for AJAX applications. */
window.dhtmlHistory = {
   /** Initializes our DHTML history. You should
       call this after the page is finished loading. */
   /** public */ initialize: function() {
      // only Internet Explorer needs to be explicitly initialized;
      // other browsers don't have its particular behaviors.
      // Basicly, IE doesn't autofill form data until the page
      // is finished loading, which means historyStorage won't
      // work until onload has been fired.
      if (this.isInternetExplorer() == false) {
         return;
      }
         
      // if this is the first time this page has loaded...
      if (historyStorage.hasKey("DhtmlHistory_pageLoaded") == false) {
         this.fireOnNewListener = false;
         this.firstLoad = true;
         historyStorage.put("DhtmlHistory_pageLoaded", true);
      }
      // else if this is a fake onload event
      else {
         this.fireOnNewListener = true;
         this.firstLoad = false;   
      }
   },
             
   /** Adds a history change listener. Note that
       only one listener is supported at this
       time. */
   /** public */ addListener: function(callback) {
      this.listener = callback;
      
      // if the page was just loaded and we
      // should not ignore it, fire an event
      // to our new listener now
      if (this.fireOnNewListener == true) {
         this.fireHistoryEvent(this.currentLocation);
         this.fireOnNewListener = false;
      }
   },
   
   /** public */ add: function(newLocation, historyData) {
      // most browsers require that we wait a certain amount of time before changing the
      // location, such as 200 milliseconds; rather than forcing external callers to use
      // window.setTimeout to account for this to prevent bugs, we internally handle this
      // detail by using a 'currentWaitTime' variable and have requests wait in line
      var self = this;
      var addImpl = function() {
         // indicate that the current wait time is now less
         if (self.currentWaitTime > 0)
            self.currentWaitTime = self.currentWaitTime - self.WAIT_TIME;
            
         // remove any leading hash symbols on newLocation
         newLocation = self.removeHash(newLocation);
         
         // IE has a strange bug; if the newLocation
         // is the same as _any_ preexisting id in the
         // document, then the history action gets recorded
         // twice; throw a programmer exception if there is
         // an element with this ID
         var idCheck = document.getElementById(newLocation);
         if (idCheck != undefined || idCheck != null) {
            var message = 
               "Exception: History locations can not have "
               + "the same value as _any_ id's "
               + "that might be in the document, "
               + "due to a bug in Internet "
               + "Explorer; please ask the "
               + "developer to choose a history "
               + "location that does not match "
               + "any HTML id's in this "
               + "document. The following ID "
               + "is already taken and can not "
               + "be a location: " 
               + newLocation;
               
            throw message; 
         }
         
         // store the history data into history storage
         historyStorage.put(newLocation, historyData);
         
         // indicate to the browser to ignore this upcomming 
         // location change
         self.ignoreLocationChange = true;
 
         // indicate to IE that this is an atomic location change
         // block
         this.ieAtomicLocationChange = true;
                 
         // save this as our current location
         self.currentLocation = newLocation;
         
         // change the browser location
         window.location.hash = newLocation;
         
         // change the hidden iframe's location if on IE
         if (self.isInternetExplorer())
            self.iframe.src = "blank.html?" + newLocation;
            
         // end of atomic location change block
         // for IE
         this.ieAtomicLocationChange = false;
      };

      // now execute this add request after waiting a certain amount of time, so as to
      // queue up requests
      window.setTimeout(addImpl, this.currentWaitTime);
   
      // indicate that the next request will have to wait for awhile
      this.currentWaitTime = this.currentWaitTime + this.WAIT_TIME;
   },
   
   /** public */ isFirstLoad: function() {
      if (this.firstLoad == true) {
         return true;
      }
      else {
         return false;
      }
   },
   
   /** public */ isInternational: function() {
      return false;
   },
   
   /** public */ getVersion: function() {
      return "0.05";
   },
   
   /** Gets the current hash value that is in the browser's
       location bar, removing leading # symbols if they are present. */
   /** public */ getCurrentLocation: function() {
      var currentLocation = this.removeHash(window.location.hash);
         
      return currentLocation;
   },
   
   
   
   
   
   /** Our current hash location, without the "#" symbol. */
   /** private */ currentLocation: null,
   
   /** Our history change listener. */
   /** private */ listener: null,
   
   /** A hidden IFrame we use in Internet Explorer to detect history
       changes. */
   /** private */ iframe: null,
   
   /** Indicates to the browser whether to ignore location changes. */
   /** private */ ignoreLocationChange: null,
 
   /** The amount of time in milliseconds that we should wait between add requests. 
       Firefox is okay with 200 ms, but Internet Explorer needs 400. */
   /** private */ WAIT_TIME: 200,

   /** The amount of time in milliseconds an add request has to wait in line before being
       run on a window.setTimeout. */
   /** private */ currentWaitTime: 0,
   
   /** A flag that indicates that we should fire a history change event
       when we are ready, i.e. after we are initialized and
       we have a history change listener. This is needed due to 
       an edge case in browsers other than Internet Explorer; if
       you leave a page entirely then return, we must fire this
       as a history change event. Unfortunately, we have lost
       all references to listeners from earlier, because JavaScript
       clears out. */
   /** private */ fireOnNewListener: null,
   
   /** A variable that indicates whether this is the first time
       this page has been loaded. If you go to a web page, leave
       it for another one, and then return, the page's onload
       listener fires again. We need a way to differentiate
       between the first page load and subsequent ones.
       This variable works hand in hand with the pageLoaded
       variable we store into historyStorage.*/
   /** private */ firstLoad: null,
   
   /** A variable to handle an important edge case in Internet
       Explorer. In IE, if a user manually types an address into
       their browser's location bar, we must intercept this by
       continiously checking the location bar with an timer 
       interval. However, if we manually change the location
       bar ourselves programmatically, when using our hidden
       iframe, we need to ignore these changes. Unfortunately,
       these changes are not atomic, so we surround them with
       the variable 'ieAtomicLocationChange', that if true,
       means we are programmatically setting the location and
       should ignore this atomic chunked change. */
   /** private */ ieAtomicLocationChange: null,          
   
   /** Creates the DHTML history infrastructure. */
   /** private */ create: function() {
      // get our initial location
      var initialHash = this.getCurrentLocation();
      
      // save this as our current location
      this.currentLocation = initialHash;
      
      // write out a hidden iframe for IE and
      // set the amount of time to wait between add() requests
      if (this.isInternetExplorer()) {
         document.write("<iframe style='border: 0px; width: 1px; "
                               + "height: 1px; position: absolute; bottom: 0px; "
                               + "right: 0px; visibility: visible;' "
                               + "name='DhtmlHistoryFrame' id='DhtmlHistoryFrame' "
                               + "src='blank.html?" + initialHash + "'>"
                               + "</iframe>");
         // wait 400 milliseconds between history
         // updates on IE, versus 200 on Firefox
         this.WAIT_TIME = 400;
      }
      
      // add an unload listener for the page; this is
      // needed for Firefox 1.5+ because this browser caches all
      // dynamic updates to the page, which can break some of our 
      // logic related to testing whether this is the first instance
      // a page has loaded or whether it is being pulled from the cache
      var self = this;
      window.onunload = function() {
         self.firstLoad = null;
      };
      
      // determine if this is our first page load;
      // for Internet Explorer, we do this in 
      // this.iframeLoaded(), which is fired on
      // page load. We do it there because
      // we have no historyStorage at this point
      // in IE, which only exists after the page
      // is finished loading for that browser
      if (this.isInternetExplorer() == false) {
         if (historyStorage.hasKey("DhtmlHistory_pageLoaded") == false) {
            this.ignoreLocationChange = true;
            this.firstLoad = true;
            historyStorage.put("DhtmlHistory_pageLoaded", true);
         }
         else {
            // indicate that we want to pay attention
            // to this location change
            this.ignoreLocationChange = false;
            // For browser's other than IE, fire
            // a history change event; on IE,
            // the event will be thrown automatically
            // when it's hidden iframe reloads
            // on page load.
            // Unfortunately, we don't have any 
            // listeners yet; indicate that we want
            // to fire an event when a listener
            // is added.
            this.fireOnNewListener = true;
         }
      }
      else { // Internet Explorer
         // the iframe will get loaded on page
         // load, and we want to ignore this fact
         this.ignoreLocationChange = true;
      }
      
      if (this.isInternetExplorer()) {
            this.iframe = document.getElementById("DhtmlHistoryFrame");
      }                                                              

      // other browsers can use a location handler that checks
      // at regular intervals as their primary mechanism;
      // we use it for Internet Explorer as well to handle
      // an important edge case; see checkLocation() for
      // details
      var self = this;
      var locationHandler = function() {
         self.checkLocation();
      };
      setInterval(locationHandler, 100);
   },
   
   /** Notify the listener of new history changes. */
   /** private */ fireHistoryEvent: function(newHash) {
      // extract the value from our history storage for
      // this hash
      var historyData = historyStorage.get(newHash);

      // call our listener      
      this.listener.call(null, newHash, historyData);
   },
   
   /** Sees if the browsers has changed location.  This is the primary history mechanism
       for Firefox. For Internet Explorer, we use this to handle an important edge case:
       if a user manually types in a new hash value into their Internet Explorer location
       bar and press enter, we want to intercept this and notify any history listener. */
   /** private */ checkLocation: function() {
      // ignore any location changes that we made ourselves
      // for browsers other than Internet Explorer
      if (this.isInternetExplorer() == false
         && this.ignoreLocationChange == true) {
         this.ignoreLocationChange = false;
         return;
      }
      
      // if we are dealing with Internet Explorer
      // and we are in the middle of making a location
      // change from an iframe, ignore it
      if (this.isInternetExplorer() == false
          && this.ieAtomicLocationChange == true) {
         return;
      }
      
      // get hash location
      var hash = this.getCurrentLocation();
      
      // see if there has been a change
      if (hash == this.currentLocation)
         return;
         
      // on Internet Explorer, we need to intercept users manually
      // entering locations into the browser; we do this by comparing
      // the browsers location against the iframes location; if they
      // differ, we are dealing with a manual event and need to
      // place it inside our history, otherwise we can return
      this.ieAtomicLocationChange = true;
      
      if (this.isInternetExplorer()
          && this.getIFrameHash() != hash) {
         this.iframe.src = "blank.html?" + hash;
      }
      else if (this.isInternetExplorer()) {
         // the iframe is unchanged
         return;
      }
         
      // save this new location
      this.currentLocation = hash;
      
      this.ieAtomicLocationChange = false;
      
      // notify listeners of the change
      this.fireHistoryEvent(hash);
   },  

   /** Gets the current location of the hidden IFrames
       that is stored as history. For Internet Explorer. */
   /** private */ getIFrameHash: function() {
      // get the new location
      var historyFrame = document.getElementById("DhtmlHistoryFrame");
      var doc = historyFrame.contentWindow.document;
      var hash = new String(doc.location.search);

      if (hash.length == 1 && hash.charAt(0) == "?")
         hash = "";
      else if (hash.length >= 2 && hash.charAt(0) == "?")
         hash = hash.substring(1); 
    
    
      return hash;
   },          
   
   /** Removes any leading hash that might be on a location. */
   /** private */ removeHash: function(hashValue) {
      if (hashValue == null || hashValue == undefined)
         return null;
      else if (hashValue == "")
         return "";
      else if (hashValue.length == 1 && hashValue.charAt(0) == "#")
         return "";
      else if (hashValue.length > 1 && hashValue.charAt(0) == "#")
         return hashValue.substring(1);
      else
         return hashValue;     
   },          
   
   /** For IE, says when the hidden iframe has finished loading. */
   /** private */ iframeLoaded: function(newLocation) {
      // ignore any location changes that we made ourselves
      if (this.ignoreLocationChange == true) {
         this.ignoreLocationChange = false;
         return;
      }
      
      // get the new location
      var hash = new String(newLocation.search);
      if (hash.length == 1 && hash.charAt(0) == "?")
         hash = "";
      else if (hash.length >= 2 && hash.charAt(0) == "?")
         hash = hash.substring(1);
      
      // move to this location in the browser location bar
      // if we are not dealing with a page load event
      if (this.pageLoadEvent != true) {
         window.location.hash = hash;
      }

      // notify listeners of the change
      this.fireHistoryEvent(hash);
   },
   
   /** Determines if this is Internet Explorer. */
   /** private */ isInternetExplorer: function() {
      var userAgent = navigator.userAgent.toLowerCase();
      if (document.all && userAgent.indexOf('msie')!=-1) {
         return true;
      }
      else {
         return false;
      }
   }
};












/** An object that uses a hidden form to store history state 
    across page loads. The chief mechanism for doing so is using
    the fact that browser's save the text in form data for the
    life of the browser and cache, which means the text is still
    there when the user navigates back to the page. See
    http://codinginparadise.org/weblog/2005/08/ajax-tutorial-saving-session-across.html
    for full details. */
window.historyStorage = {
   /** If true, we are debugging and show the storage textfield. */
   /** public */ debugging: false,
   
   /** Our hash of key name/values. */
   /** private */ storageHash: new Object(),
   
   /** If true, we have loaded our hash table out of the storage form. */
   /** private */ hashLoaded: false, 
   
   /** public */ put: function(key, value) {
       this.assertValidKey(key);
       
       // if we already have a value for this,
       // remove the value before adding the
       // new one
       if (this.hasKey(key)) {
         this.remove(key);
       }
       
       // store this new key
       this.storageHash[key] = value;
       
       // save and serialize the hashtable into the form
       this.saveHashTable(); 
   },
   
   /** public */ get: function(key) {
      this.assertValidKey(key);
      
      // make sure the hash table has been loaded
      // from the form
      this.loadHashTable();
      
      var value = this.storageHash[key];

      if (value == undefined)
         return null;
      else
         return value; 
   },
   
   /** public */ remove: function(key) {
      this.assertValidKey(key);
      
      // make sure the hash table has been loaded
      // from the form
      this.loadHashTable();
      
      // delete the value
      delete this.storageHash[key];
      
      // serialize and save the hash table into the 
      // form
      this.saveHashTable();
   },
   
   /** Clears out all saved data. */
   /** public */ reset: function() {
      this.storageField.value = "";
      this.storageHash = new Object();
   },
   
   /** public */ hasKey: function(key) {
      this.assertValidKey(key);
      
      // make sure the hash table has been loaded
      // from the form
      this.loadHashTable();
      
      if (typeof this.storageHash[key] == "undefined")
         return false;
      else
         return true;
   },
   
   /** Determines whether the key given is valid;
       keys can only have letters, numbers, the dash,
       underscore, spaces, or one of the 
       following characters:
       !@#$%^&*()+=:;,./?|\~{}[] */
   /** public */ isValidKey: function(key) {
      // allow all strings, since we don't use XML serialization
      // format anymore
      return (typeof key == "string");
      
      /*
      if (typeof key != "string")
         key = key.toString();
      
      
      var matcher = 
         /^[a-zA-Z0-9_ \!\@\#\$\%\^\&\*\(\)\+\=\:\;\,\.\/\?\|\\\~\{\}\[\]]*$/;
                     
      return matcher.test(key);*/
   },
   
   
   
   
   /** A reference to our textarea field. */
   /** private */ storageField: null,
   
   /** private */ init: function() {
      // write a hidden form into the page
      var styleValue = "position: absolute; top: -1000px; left: -1000px;";
      if (this.debugging == true) {
         styleValue = "width: 30em; height: 30em;";
      }   
      
      var newContent =
         "<form id='historyStorageForm' " 
               + "method='GET' "
               + "style='" + styleValue + "'>"
            + "<textarea id='historyStorageField' "
                      + "style='" + styleValue + "'"
                              + "left: -1000px;' "
                      + "name='historyStorageField'></textarea>"
         + "</form>";
      document.write(newContent);
      
      this.storageField = document.getElementById("historyStorageField");
   },
   
   /** Asserts that a key is valid, throwing
       an exception if it is not. */
   /** private */ assertValidKey: function(key) {
      if (this.isValidKey(key) == false) {
         throw "Please provide a valid key for "
               + "window.historyStorage, key= "
               + key;
       }
   },
   
   /** Loads the hash table up from the form. */
   /** private */ loadHashTable: function() {
      if (this.hashLoaded == false) {
         // get the hash table as a serialized
         // string
         var serializedHashTable = this.storageField.value;
         
         if (serializedHashTable != "" &&
             serializedHashTable != null) {
            // destringify the content back into a 
            // real JavaScript object
            this.storageHash = eval('(' + serializedHashTable + ')');  
         }
         
         this.hashLoaded = true;
      }
   },
   
   /** Saves the hash table into the form. */
   /** private */ saveHashTable: function() {
      this.loadHashTable();
      
      // serialized the hash table
      var serializedHashTable = JSON.stringify(this.storageHash);
      
      // save this value
      this.storageField.value = serializedHashTable;
   }   
};










/** The JSON class is copyright 2005 JSON.org. */
Array.prototype.______array = '______array';

var JSON = {
    org: 'http://www.JSON.org',
    copyright: '(c)2005 JSON.org',
    license: 'http://www.crockford.com/JSON/license.html',

    stringify: function (arg) {
        var c, i, l, s = '', v;

        switch (typeof arg) {
        case 'object':
            if (arg) {
                if (arg.______array == '______array') {
                    for (i = 0; i < arg.length; ++i) {
                        v = this.stringify(arg[i]);
                        if (s) {
                            s += ',';
                        }
                        s += v;
                    }
                    return '[' + s + ']';
                } else if (typeof arg.toString != 'undefined') {
                    for (i in arg) {
                        v = arg[i];
                        if (typeof v != 'undefined' && typeof v != 'function') {
                            v = this.stringify(v);
                            if (s) {
                                s += ',';
                            }
                            s += this.stringify(i) + ':' + v;
                        }
                    }
                    return '{' + s + '}';
                }
            }
            return 'null';
        case 'number':
            return isFinite(arg) ? String(arg) : 'null';
        case 'string':
            l = arg.length;
            s = '"';
            for (i = 0; i < l; i += 1) {
                c = arg.charAt(i);
                if (c >= ' ') {
                    if (c == '\\' || c == '"') {
                        s += '\\';
                    }
                    s += c;
                } else {
                    switch (c) {
                        case '\b':
                            s += '\\b';
                            break;
                        case '\f':
                            s += '\\f';
                            break;
                        case '\n':
                            s += '\\n';
                            break;
                        case '\r':
                            s += '\\r';
                            break;
                        case '\t':
                            s += '\\t';
                            break;
                        default:
                            c = c.charCodeAt();
                            s += '\\u00' + Math.floor(c / 16).toString(16) +
                                (c % 16).toString(16);
                    }
                }
            }
            return s + '"';
        case 'boolean':
            return String(arg);
        default:
            return 'null';
        }
    },
    parse: function (text) {
        var at = 0;
        var ch = ' ';

        function error(m) {
            throw {
                name: 'JSONError',
                message: m,
                at: at - 1,
                text: text
            };
        }

        function next() {
            ch = text.charAt(at);
            at += 1;
            return ch;
        }

        function white() {
            while (ch != '' && ch <= ' ') {
                next();
            }
        }

        function str() {
            var i, s = '', t, u;

            if (ch == '"') {
outer:          while (next()) {
                    if (ch == '"') {
                        next();
                        return s;
                    } else if (ch == '\\') {
                        switch (next()) {
                        case 'b':
                            s += '\b';
                            break;
                        case 'f':
                            s += '\f';
                            break;
                        case 'n':
                            s += '\n';
                            break;
                        case 'r':
                            s += '\r';
                            break;
                        case 't':
                            s += '\t';
                            break;
                        case 'u':
                            u = 0;
                            for (i = 0; i < 4; i += 1) {
                                t = parseInt(next(), 16);
                                if (!isFinite(t)) {
                                    break outer;
                                }
                                u = u * 16 + t;
                            }
                            s += String.fromCharCode(u);
                            break;
                        default:
                            s += ch;
                        }
                    } else {
                        s += ch;
                    }
                }
            }
            error("Bad string");
        }

        function arr() {
            var a = [];

            if (ch == '[') {
                next();
                white();
                if (ch == ']') {
                    next();
                    return a;
                }
                while (ch) {
                    a.push(val());
                    white();
                    if (ch == ']') {
                        next();
                        return a;
                    } else if (ch != ',') {
                        break;
                    }
                    next();
                    white();
                }
            }
            error("Bad array");
        }

        function obj() {
            var k, o = {};

            if (ch == '{') {
                next();
                white();
                if (ch == '}') {
                    next();
                    return o;
                }
                while (ch) {
                    k = str();
                    white();
                    if (ch != ':') {
                        break;
                    }
                    next();
                    o[k] = val();
                    white();
                    if (ch == '}') {
                        next();
                        return o;
                    } else if (ch != ',') {
                        break;
                    }
                    next();
                    white();
                }
            }
            error("Bad object");
        }

        function num() {
            var n = '', v;
            if (ch == '-') {
                n = '-';
                next();
            }
            while (ch >= '0' && ch <= '9') {
                n += ch;
                next();
            }
            if (ch == '.') {
                n += '.';
                while (next() && ch >= '0' && ch <= '9') {
                    n += ch;
                }
            }
            if (ch == 'e' || ch == 'E') {
                n += 'e';
                next();
                if (ch == '-' || ch == '+') {
                    n += ch;
                    next();
                }
                while (ch >= '0' && ch <= '9') {
                    n += ch;
                    next();
                }
            }
            v = +n;
            if (!isFinite(v)) {
                error("Bad number");
            } else {
                return v;
            }
        }

        function word() {
            switch (ch) {
                case 't':
                    if (next() == 'r' && next() == 'u' && next() == 'e') {
                        next();
                        return true;
                    }
                    break;
                case 'f':
                    if (next() == 'a' && next() == 'l' && next() == 's' &&
                            next() == 'e') {
                        next();
                        return false;
                    }
                    break;
                case 'n':
                    if (next() == 'u' && next() == 'l' && next() == 'l') {
                        next();
                        return null;
                    }
                    break;
            }
            error("Syntax error");
        }

        function val() {
            white();
            switch (ch) {
                case '{':
                    return obj();
                case '[':
                    return arr();
                case '"':
                    return str();
                case '-':
                    return num();
                default:
                    return ch >= '0' && ch <= '9' ? num() : word();
            }
        }

        return val();
    }
};



/** Initialize all of our objects now. */
window.historyStorage.init();
window.dhtmlHistory.create();
/*
 * Copyright 2007 WSO2, Inc. http://www.wso2.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var WSRequest;

WSRequest = function() {
    this.readyState = 0;
    this.responseText = null;
    this.responseXML = null;
    this.error = null;
    this.onreadystatechange = null;
    this._xmlhttp = WSRequest.util._createXMLHttpRequestObject();
    this._soapVer = null;
};

var WebServiceError = function(reason, detail, code) {
    this.reason = reason;
    this.detail = detail;
    this.code = code;
    this.toString = function() { return this.reason; };
};

WSRequest.prototype._async = true;
WSRequest.prototype._optionSet = null;
WSRequest.prototype._uri = null;
WSRequest.prototype._username = null;
WSRequest.prototype._password = null;

WSRequest.prototype.open = function(options, URL, asnycFlag, userName, passWord) {
    if (arguments.length < 2 || arguments.length > 6)
    {
        throw new WebServiceError("Invalid input argument", "WSRequest.open method requires 2 to 6 arguments, but " + arguments.length + (arguments.length == 1 ? " was" : " were") + " specified.");
    }

    if (typeof(options) == "string") {
        this._optionSet = new Array();
        this._optionSet["HTTPMethod"] = options;
    } else {
        this._optionSet = options;
    }

    this._uri = URL;
    this._async = asnycFlag;
    if (userName != null && passWord == null)
        throw new WebServiceError("User name should have a password", "WSRequest.open invocation specified userName: '" + userName + "' without a corresponding password.");
    else
    {
        this._username = userName;
        this._password = passWord;
    }

    this.readyState = 1;
    if (this.onreadystatechange != null)
        this.onreadystatechange();
    this.responseText = null;
    this.responseXML = null;
    this.error = null;
};

WSRequest.prototype.send = function(payload) {
    if (arguments.length > 1) {
        throw new WebServiceError("Invalid input argument.", "WSRequest.send() only accepts a single argument, " + arguments.length + " were specified.");
    }

    var req = null;
    // string to be sent
    var method;
    if (this._optionSet["HTTPMethod"] != null)
        method = this._optionSet["HTTPMethod"];
    else
        method = "POST";

    this._soapVer = WSRequest.util._bindingVersion(this._optionSet);

    if (payload != null)
    {
        // seralize the dom to string
        var content = WSRequest.util._serializeToString(payload);
        if (typeof(content) == "boolean" && content == false) {
            throw new WebServiceError("Invalid input argument.", "WSRequest.send() unable to serialize XML payload.");
        }

    }
    // formulate the message envelope
    if (this._soapVer == 0) {
        var processed = WSRequest.util._buildHTTPpayload(this._optionSet, this._uri, content);
        req = processed["body"];
        this._uri = processed["url"];
    } else {
        req = WSRequest.util._buildSOAPEnvelope(this._soapVer, this._optionSet, this._uri, content);
    }

    // Note that we infer soapAction from the "action" parameter - also used for wsa:Action.
    //  WS-A recommends keeping these two items in sync.
    var soapAction = this._optionSet["action"];

    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
    } catch(e) {
    }
    this._xmlhttp.open(method, this._uri, this._async);

    switch (this._soapVer) {
        case 1.1:
            soapAction = (soapAction == undefined ? '""' : '"' + soapAction + '"');
            this._xmlhttp.setRequestHeader("SOAPAction", soapAction);
            this._xmlhttp.setRequestHeader("Content-Type", "text/xml; charset=UTF-8");
            break;
        case 1.2:
            this._xmlhttp.setRequestHeader("Content-Type", "application/soap+xml;charset=UTF-8" + (soapAction == undefined ? "" : ";action=" + soapAction));
            break;
        case 0:
            if (this._optionSet["HTTPInputSerialization"] != null) {
                contentType = this._optionSet["HTTPInputSerialization"]
            } else {
                if (method == "GET" | method == "DELETE") {
                    contentType = "application/x-www-form-urlencoded";
                } else {
                    contentType = "application/xml";
                }
            }
            this._xmlhttp.setRequestHeader("Content-Type", contentType);
            break;
    }

    if (this._async) {
        this._xmlhttp.onreadystatechange = WSRequest.util._bind(this._handleReadyState, this);
        this._xmlhttp.send(req);
    } else {
        // sync call
        this.readyState = 2;
        if (this.onreadystatechange != null)
            this.onreadystatechange();

        this._xmlhttp.send(req);

        this._processResult();
        if (this.error != null)
            throw (this.error);

        this.readyState = 4;
        if (this.onreadystatechange != null)
            this.onreadystatechange();
    }
}

/**
 * @description Set responseText, responseXML, and error of WSRequest.
 * @method _processResult
 * @private
 * @static
 */
WSRequest.prototype._processResult = function () {
    var httpstatus;
    if (this._soapVer == 0) {
        this.responseText = this._xmlhttp.responseText;
        this.responseXML = this._xmlhttp.responseXML;

        httpstatus = this._xmlhttp.status;
        if (httpstatus == '200' || httpstatus == '202') {
            this.error = null;
        } else {
            this.error = new WebServiceError(this._xmlhttp.statusText, this.responseText, "HTTP " + this._xmlhttp.status);
        }
    } else {
        var browser = WSRequest.util._getBrowser();

        if (this._xmlhttp.responseText != "") {
            var response;
            var responseXMLdoc;
            if (browser == "ie" || browser == "ie7") {
                if (this._xmlhttp.responseXML.documentElement == null) {
                    // unrecognized media type (probably application/soap+xml)
                    responseXMLdoc = new ActiveXObject("Microsoft.XMLDOM");
                    responseXMLdoc.loadXML(this._xmlhttp.responseText);
                    response = responseXMLdoc.documentElement;
                } else {
                    response = this._xmlhttp.responseXML.documentElement;
                }
            } else {
                var parser = new DOMParser();
                responseXMLdoc = parser.parseFromString(this._xmlhttp.responseText,"text/xml");
                response = responseXMLdoc.documentElement;
                response.normalize();  //fixes data getting truncated at 4096 characters
            }
            var soapNamespace;
            if (this._soapVer == 1.1)
                soapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
            else
                soapNamespace = "http://www.w3.org/2003/05/soap-envelope";

            var soapBody = WSRequest.util._firstElement(response, soapNamespace, "Body");
            if (soapBody != null && soapBody.hasChildNodes()) {
                var newDoc;
                if (browser == "ie" || browser == "ie7") {
                    newDoc = new ActiveXObject("Microsoft.XMLDOM");
                    newDoc.appendChild(soapBody.firstChild);
                } else {
                    newDoc = document.implementation.createDocument("", "", null);
                    newDoc.appendChild(soapBody.firstChild);
                }

                this.responseXML = newDoc;
                this.responseText = WSRequest.util._serializeToString(newDoc);

                fault = WSRequest.util._firstElement(newDoc, soapNamespace, "Fault");
                if (fault != undefined) {
                    this.error = new WebServiceError();
                    if (this._soapVer == 1.2) {
                        this.error.code = WSRequest.util._stringValue(WSRequest.util._firstElement(fault, soapNamespace, "Value"));
                        this.error.reason = WSRequest.util._stringValue(WSRequest.util._firstElement(fault, soapNamespace, "Text"));
                        this.error.detail = WSRequest.util._firstElement(fault, soapNamespace, "Detail");
                    } else {
                        this.error.code = WSRequest.util._stringValue(fault.getElementsByTagName("faultcode")[0]);
                        this.error.reason = WSRequest.util._stringValue(fault.getElementsByTagName("faultstring")[0]);
                        this.error.detail = fault.getElementsByTagName("detail")[0];
                    }
                }
            } else {
                // empty SOAP body - not necessarily an error
                this.responseXML = null;
                this.responseText = "";
                this.error = null;
            }
        } else {
            // If this block being executed; it's due to server connection has falied. 
            this.responseXML = null;
            this.responseText = "";
            try {
                httpstatus = this._xmlhttp.status;
                if (httpstatus == '200' || httpstatus == '202') {
                    this.error = null;
                } else {
                    this.error = new WebServiceError();
                    this.error.code = "HTTP " + this._xmlhttp.status;
                    this.error.reason = "Server connection has failed.";
                    this.error.detail = this._xmlhttp.statusText;
                }
            } catch (e) {
                this.error = new WebServiceError();
                this.error.code = null;
                this.error.reason = "Server connection has failed.";
                this.error.detail = e.toString();
            }
        }
    }
}


WSRequest.prototype._handleReadyState = function() {
    if (this._xmlhttp.readyState == 2) {
        this.readyState = 2;
        if (this.onreadystatechange != null)
            this.onreadystatechange();
    }

    if (this._xmlhttp.readyState == 3) {
        this.readyState = 3;
        if (this.onreadystatechange != null)
            this.onreadystatechange();
    }

    if (this._xmlhttp.readyState == 4) {
        this.readyState = 4;

        this._processResult();

        if (this.onreadystatechange != null)
            this.onreadystatechange();
    }
};


WSRequest.util = {

    _msxml : [
            'MSXML2.XMLHTTP.3.0',
            'MSXML2.XMLHTTP',
            'Microsoft.XMLHTTP'
            ],

/**
 * @description Instantiates a XMLHttpRequest object and returns it.
 * @method _createXMLHttpRequestObject
 * @private
 * @static
 * @return object
 */
    _createXMLHttpRequestObject : function() {
        var xhrObject;

        try {
            xhrObject = new XMLHttpRequest();
        } catch(e) {
            for (var i = 0; i < this._msxml.length; ++i) {
                try
                {
                    // Instantiates XMLHttpRequest for IE and assign to http.
                    xhrObject = new ActiveXObject(this._msxml[i]);
                    break;
                }
                catch(e) {
                    // do nothing
                }
            }
        } finally {
            return xhrObject;
        }
    },

/**
 * @description Serialize payload to string.
 * @method _serializeToString
 * @private
 * @static
 * @param {dom} payload   xml payload
 * @return string
 */
    _serializeToString : function(payload) {
        if (payload == null) return null;
        if (typeof(payload) == "string") {
            return payload;
        } else if (typeof(payload) == "object") {
            var browser = WSRequest.util._getBrowser();
            switch (browser) {
                case "gecko":
                    var serializer = new XMLSerializer();
                    return serializer.serializeToString(payload);
                    break;
                case "ie":
                    return payload.xml;
                    break;
                case "ie7":
                    return payload.xml;
                    break;
                case "opera":
                    var xmlSerializer = document.implementation.createLSSerializer();
                    return xmlSerializer.writeToString(payload);
                    break;
                case "safari":
                // use the safari method
                    throw new WebServiceError("Not implemented", "WSRequest.util._serializeToString doesn't support Safari browser.");
                case "undefined":
                    throw new WebServiceError("Unknown browser", "WSRequest.util._serializeToString doesn't recognize the browser, to invoke browser-specific serialization code.");
            }
        } else {
            return false;
        }
    },


/**
 * @description get the character element children in a browser-independent way.
 * @method _stringValue
 * @private
 * @static
 * @param {dom element} node
 * @return string
 */
    _stringValue : function(node) {
        var browser = WSRequest.util._getBrowser();
        switch (browser) {
            case "ie":
            case "ie7":
                return node.text;
                break;
            case "gecko":
            case "opera":
            case "safari":
            case "undefined":
                value = "";
                if (node.nodeType == 3) value = node.nodeValue;
                else for (c in node.childNodes) value += WSRequest.util._stringValue(node.childNodes[c]);
                return value;
                break;
        }
    },


/**
 * @description Determines which binding to use (SOAP 1.1, SOAP 1.2, or HTTP) from the various options.
 * @method _bindingVersion
 * @private
 * @static
 * @param {Array} options   Options given by user
 * @return string
 */
    _bindingVersion : function(options) {
        switch (options["useBindng"]) {
            case "SOAP 1.2":
                soapVer = 1.2;
                break;
            case "SOAP 1.1":
                soapVer = 1.1;
                break;                                                                                  
            case "HTTP":
                soapVer = 0;
                break;
            case undefined:
                useSOAP = options["useSOAP"];
                switch (useSOAP) {
                    case 1.2:
                        soapVer = 1.2;
                        break;
                    case "1.2":
                        soapVer = 1.2;
                        break;
                    case 1.1:
                        soapVer = 1.1;
                        break;
                    case "1.1":
                        soapVer = 1.1;
                        break;
                    case true:
                        soapVer = 1.2;
                        break;
                    case false:
                        soapVer = 0;
                        break;
                    case undefined:
                        throw("Unspecified binding type: set useBinding = 'SOAP 1.1' | 'SOAP 1.2' | 'HTTP'.");
                        break;
                    default:
                        throw("Unsupported useSOAP value '" + useSOAP + "'; set 'useBinding' option instead.");
                }
                break;
            default:
                throw("Unsupported useBinding value '" + options["useBinding"] + "': must be 'SOAP 1.2' | 'SOAP 1.1' | 'HTTP'.");
        }
        return soapVer;
    },

/**
 * @description Determine which browser we're running.
 * @method _getBrowser
 * @private
 * @static
 * @return string
 */
    _getBrowser : function() {
        var ua = navigator.userAgent.toLowerCase();
        if (ua.indexOf('opera') != -1) { // Opera (check first in case of spoof)
            return 'opera';
        } else if (ua.indexOf('msie 7') != -1) { // IE7
            return 'ie7';
        } else if (ua.indexOf('msie') != -1) { // IE
            return 'ie';
        } else if (ua.indexOf('safari') != -1) { // Safari (check before Gecko because it includes "like Gecko")
            return 'safari';
        } else if (ua.indexOf('gecko') != -1) { // Gecko
            return 'gecko';
        } else {
            return false;
        }
    },


/**
 * @description Build HTTP payload using given parameters.
 * @method _buildHTTPpayload
 * @private
 * @static
 * @param {Array} options Options given by user
 * @param {string} url Address the request will be sent to.
 * @param {string} content SOAP payload in string format.
 * @return {array} Containing the processed URL and request body.
 */
    _buildHTTPpayload : function(options, url, content) {
        // Create array to hold request uri and body.
        var resultValues = new Array();
        resultValues["url"] = "";
        resultValues["body"] = "";
        var paramSeparator = "&";
        var inputSerialization;

        var HTTPQueryParameterSeparator = "HTTPQueryParameterSeparator";
        var HTTPInputSerialization = "HTTPInputSerialization";
        var HTTPLocation = "HTTPLocation";
        var HTTPMethod = "HTTPMethod";

        // If a parameter separator has been identified, use it instead of the default &.
        if (options[HTTPQueryParameterSeparator] != null) {
            paramSeparator = options[HTTPQueryParameterSeparator];
        }

        // If input serialization is not specified, default based on HTTP Method.
        if (options[HTTPInputSerialization] == null) {
            if (options[HTTPMethod] == "GET" | options[HTTPMethod] == "DELETE") {
                inputSerialization = "application/x-www-form-urlencoded";
            } else {
                inputSerialization = "application/xml";
            }
        } else {
            inputSerialization = options[HTTPInputSerialization];
        }

        //create new document from string
        var xmlDoc;

        // Parser is browser specific.
        var browser = WSRequest.util._getBrowser();
        if (browser == "ie" || browser == "ie7") {
            //create a DOM from content string.
            xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
            if (content != null && content != "")
                xmlDoc.loadXML(content);
        } else {
            //create a DOMParser to get DOM from content string.
            var xmlParser = new DOMParser();
            if (content != null && content != "")
                xmlDoc = xmlParser.parseFromString(content, "text/xml");
        }

        // If the payload is to be URL encoded, other options have to be examined.
        if (inputSerialization == "application/x-www-form-urlencoded" || inputSerialization == "application/xml") {

            resultValues["url"] = options[HTTPLocation];

            // If templates are specified and a valid payload is available, process, else just return original URI.
            if (options[HTTPLocation] != null && xmlDoc != null && xmlDoc.hasChildNodes()) {
                // Ideally .documentElement should be used instead of .firstChild, but this does not work.
                var rootNode = xmlDoc.firstChild;

                // Process payload, distributing content across the URL and body as specified.
                resultValues = WSRequest.util._processNode(options, resultValues, rootNode, paramSeparator,
                        inputSerialization);

            }
            // Globally replace any remaining template tags with empty strings.
            var allTemplateRegex = new RegExp("\{.*\}", "ig");
            resultValues["url"] = resultValues["url"].replace(allTemplateRegex, "");

            // Append processed HTTPLocation value to URL.
            resultValues["url"] = WSRequest.util._joinUrlToLocation(url, resultValues["url"]);

            // Sending the XML in the request body.
            if (content != null && inputSerialization == "application/xml") {
                resultValues["body"] = content;
            }
        } else if (inputSerialization == "multipart/form-data") {
            // Just throw an exception for now - will try to use browser features in a later release.
            throw new WebServiceError("Unsupported serialization option.", "WSRequest.util._buildHTTPpayload doesn't yet support multipart/form-data serialization.");
        }
        return resultValues;
    },

/**
 * @description Traverse the DOM tree below a given node, retreiving the content of each node and appending it to the
 *  URL or the body of the request based on the options specified.
 * @method _processNode
 * @private
 * @static
 * @param {Array} options Options given by user.
 * @param {Array} resultValues HTTP Location content and request body.
 * @param {XML} node SOAP payload as an XML object.
 * @param {string} paramSeparator Separator character for URI parameters.
 * @return {array} Containing the processed HTTP Location content and request body.
 */
    _processNode : function(options, resultValues, node, paramSeparator, inputSerialization) {
        var queryStringSep = '?';
        var HTTPLocationIgnoreUncited = "HTTPLocationIgnoreUncited";
        var HTTPMethod = "HTTPMethod";

        // Traverse the XML and add the contents of each node to the URL or body.
        do {

            // Recurse if node has children.
            if (node.hasChildNodes())
            {
                resultValues = WSRequest.util._processNode(options, resultValues, node.firstChild, paramSeparator,
                        inputSerialization);
            }

            // Check for availability of node name and data before processing.
            if (node.nodeValue != null) {
                var tokenName = WSRequest.util._nameForValue(node);

                // Create a regex to look for the token.
                var templateRegex = new RegExp("\{" + tokenName + "\}", "i");
                var unencTmpltRegex = new RegExp("\{!" + tokenName + "\}", "i");
                var tokenLocn;

                // If the token is in the URL - swap tokens with values.
                if ((tokenLocn = resultValues["url"].search(templateRegex)) != -1) {
                    // Replace the token with the URL encoded node value.
                    var isQuery = resultValues["url"].substring(0, tokenLocn).indexOf('?') != -1;
                    resultValues["url"] = resultValues["url"].replace(templateRegex,
                            WSRequest.util._encodeString(node.nodeValue, isQuery));
                } else if (resultValues["url"].search(unencTmpltRegex) != -1) {
                    // Replace the token with the node value, witout encoding.
                    resultValues["url"] = resultValues["url"].replace(templateRegex, node.nodeValue);
                } else {
                    var parameter = "";

                    // If the node has a list, create a bunch of name/value pairs, otherwise a single pair.
                    if (WSRequest.util._attributesContain(node.parentNode, "xsd:list")) {
                        var valueList = new Array();
                        valueList = node.nodeValue.split(' ');
                        for (var valueNum = 0; valueNum < valueList.length; valueNum++) {
                            parameter = parameter + tokenName + "=" + WSRequest.util._encodeString(valueList[valueNum],
                                    true);

                            // Add the parameter separator after each list value except the last.
                            if (valueNum < (valueList.length - 1)) {
                                parameter += paramSeparator;
                            }
                        }
                    } else {
                        parameter = tokenName + "=" + WSRequest.util._encodeString(node.nodeValue, true);
                    }

                    // If ignore uncited option has been set, append parameter to URL else to the body.
                    if (options[HTTPLocationIgnoreUncited] == null && options[HTTPLocationIgnoreUncited] != false) {

                        // If he URL does not contain ? add it and then the parameter.
                        if (resultValues["url"].indexOf(queryStringSep) == -1) {
                            resultValues["url"] = resultValues["url"] + queryStringSep + parameter;
                        } else {
                            // ...otherwise just append the uncited value.
                            resultValues["url"] = resultValues["url"] + paramSeparator + parameter;
                        }
                    } else {
                        // Add to request body if the serialization option and request type allows it.
                        if (inputSerialization == "application/x-www-form-urlencoded" && (options[HTTPMethod] == "POST"
                                || options[HTTPMethod] == "PUT")) {
                            
                            // Assign or append additional parameters.
                            if (resultValues["body"] == "") {
                                resultValues["body"] = parameter;
                            } else {
                                resultValues["body"] = resultValues["body"] + paramSeparator + parameter;
                            }
                        }
                    }
                }
            }
        } while (node = node.nextSibling)

        return resultValues;
    }
    ,

/**
 * @description Build soap message using given parameters.
 * @method _buildSoapEnvelope
 * @private
 * @static
 * @param {string} soapVer SOAP version (1.1 or 1.2)
 * @param {Array} options   Options given by user
 * @param {string} url Address the request will be sent to.
 * @param {string} content SOAP payload
 * @return string
 */
    _buildSOAPEnvelope : function(soapVer, options, url, content) {
        if (soapVer == 1.1)
            ns = "http://schemas.xmlsoap.org/soap/envelope/";
        else
            ns = "http://www.w3.org/2003/05/soap-envelope";

        var headers = "";

        // addressing version/namespace
        var useWSA = options["useWSA"];
        var wsaNs = "";
        var wsaNsDecl = "";
        if (useWSA != undefined && useWSA != false) {
            if (useWSA == "1.0" || useWSA == true) {
                wsaNs = "http://www.w3.org/2005/08/addressing";
                standardversion = true;
            } else if (useWSA == "submission") {
                wsaNs = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                standardversion = false;
            } else throw ("Unknown WS-Addressing version '" + useWSA + "': must be '1.0' | 'submission' | true | false.");
            wsaNsDecl = ' xmlns:wsa="' + wsaNs + '"';
            headers = this._buildWSAHeaders(standardversion, options, url);
        }

        request = '<?xml version="1.0" encoding="UTF-8"?>\n' +
                  '<s:Envelope xmlns:s="' + ns + '"' +
                  wsaNsDecl + '>\n' +
                  '<s:Header>' + headers + '</s:Header>\n' +
                  '<s:Body>' + (content != null ? content : '') + '</s:Body>\n' +
                  '</s:Envelope>';
        return request;
    }
    ,

/**
 * @description Build WS-Addressing headers using given parameters.
 * @method _buildWSAHeaders
 * @private
 * @static
 * @param {boolean} standardversion true for 1.0, false for submission
 * @param {Array} options   Options given by user
 * @param {string} address Address the request will be sent to.
 * @return string
 */
    _buildWSAHeaders : function(standardversion, options, address) {
        if (options['action'] == null)
            throw("'Action' option must be specified when WS-Addressing is engaged.");

        // wsa:To (required)
        var headers = "<wsa:To>" + address + "</wsa:To>\n";

        // wsa:From (optional)
        // Note: reference parameters and metadata aren't supported.
        if (options['from'] != null)
            headers += "<wsa:From><wsa:Address>" + options['From'] + "</wsa:Address></wsa:From>\n";

        // wsa:ReplyTo (optional)
        // Note: reference parameters and metadata aren't supported.
        // Note: No way to specify that wsa:ReplyTo should be omitted (e.g., only in-out MEPs are supported).
        if (options['replyto'] != null) {
            headers += "<wsa:ReplyTo><wsa:Address>" + options['ReplyTo'] + "</wsa:Address></wsa:ReplyTo>\n";
        } else {
            // Note: although wsa:ReplyTo is optional on in-out MEPs in the standard version, we put it in
            //  explicitly for convenience.
            headers += "<wsa:ReplyTo><wsa:Address>" +
                       ( standardversion ?
                         "http://www.w3.org/2005/08/addressing/anonymous" :
                         "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"
                               ) +
                       "</wsa:Address></wsa:ReplyTo>\n";
        }

        // wsa:MessageID (required if a response is expected, e.g. wsa:ReplyTo is specified, which is always for us.)
        // If user doesn't supply an identifier, we'll make one up.
        if (options['messageid'] != null) {
            id = options['messageid'];
        } else {
            // coin a unique identifier based on the time (in milliseconds) and a 10-digit random number.
            now = (new Date()).valueOf();
            randomToken = Math.floor(Math.random() * 10000000000);
            id = "http://identifiers.wso2.com/messageid/" + now + "/" + randomToken;
        }
        headers += "<wsa:MessageID>" + id + "</wsa:MessageID>\n";

        // wsa:FaultTo (optional)
        // Note: reference parameters and metadata aren't supported.
        if (options['faultto'] != null)
            headers += "<wsa:FaultTo><wsa:Address>" + options['FaultTo'] + "</wsa:Address></wsa:FaultTo>\n";

        // wsa:Action (required)
        headers += "<wsa:Action>" + options['action'] + "</wsa:Action>\n"

        return headers;
    }
    ,

    _getRealScope : function(fn) {
        var scope = window;
        if (fn._cscope) scope = fn._cscope;
        return function() {
            return fn.apply(scope, arguments);
        }
    }
    ,

    _bind : function(fn, obj) {
        fn._cscope = obj;
        return this._getRealScope(fn);

    }
    ,

// workaround for the browser-specific differences in getElementsByTagName
    _firstElement : function (node, namespace, localName) {
        if (node == null) return null;
        var browser = WSRequest.util._getBrowser();
        var doc;
        if (browser == "ie" || browser == "ie7") {
            if (node.nodeType == 9)
                doc = node;
            else
                doc = node.ownerDocument;
            doc.setProperty("SelectionNamespaces", "xmlns:soap='" + namespace + "'");
            el = node.selectSingleNode(".//soap:" + localName);
        } else {
            // Some Firefox DOMs recognize namespaces ...
            el = node.getElementsByTagNameNS(namespace, localName)[0];
            if (el == undefined)
            // ... and some don't.
                el = node.getElementsByTagName(localName)[0];
        }
        return el;
    }
    ,

// Returns the name of a given DOM text node, managing browser issues.
    _nameForValue : function(node) {
        var browser = WSRequest.util._getBrowser();
        var nodeNameVal;

        // IE localName property does not work, so extract from node name.
        if (browser == "ie" || browser == "ie7") {
            var fullName = WSRequest.util._isEmpty(node.nodeName) ? node.parentNode.nodeName : node.nodeName;
            nodeNameVal = fullName.substring(fullName.indexOf(":") + 1, fullName.length);
        } else {
            nodeNameVal = WSRequest.util._isEmpty(node.localName) ? node.parentNode.localName : node.localName;
        }
        return nodeNameVal;
    }
    ,

// Returns true if string value is null or empty.
    _isEmpty : function(value) {
        // Regex for determining if a given string is empty.
        var emptyRegEx = /^[\s]*$/;

        // Short circuit if null, otherwise check for empty.
        return (value == null || value == "#text" || emptyRegEx.test(value));
    }
    ,

// Returns true if the attributes of the node contain a given value.
    _attributesContain : function(node, value) {
        var hasValue = false;

        // If node has attributes...
        if (node.attributes.length > 0) {
            // ...cycle through them and check for the value.
            for (var attNum = 0; attNum < node.attributes.length; attNum++) {
                if (node.attributes[attNum].nodeValue == value) {
                    hasValue = true;
                    break;
                }
            }
        }
        return hasValue;
    }
    ,
/**
 * @description Appends the template string to the URI, ensuring that the two are separated by a ? or a /. Performs a
 * merge if the start of the template is the same as the end of the URI, which will resolve at joining until a 
 * full resolution function can be developed.
 * @method _joinUrlToLocation
 * @private
 * @static
 * @param {string} endpointUri Base URI.
 * @param {string} templateString Processed contents of the HTTPLocation option.
 * @return string URI with the template string appended.
 */
    _joinUrlToLocation : function(endpointUri, templateString) {
        var endWithFwdSlash = new RegExp("/$");
        var startsWithFwdSlash = new RegExp("^/");

        if (templateString.indexOf('?') == 0) {
            endpointUri += templateString;
        } else if (endpointUri.search(endWithFwdSlash) != -1) {
            if (templateString.search(startsWithFwdSlash) != -1) {
                endpointUri += templateString.substring(1, templateString.length);
            } else {
                endpointUri += templateString;
            }
        } else {
            if (templateString.search(startsWithFwdSlash) != -1) {
                endpointUri += templateString;
            } else {
                // Extract beginning of HTTPLocation path segment.
                var firstSegment = templateString.substring(0, templateString.indexOf('/'));
                var endsWith = new RegExp("/" + firstSegment + "$");

                // If the end of the URL matches the start of the HTTPLocation's path, merge strings, else append.
                if (firstSegment != "" && firstSegment.indexOf('?') == -1 && endpointUri.search(endsWith) != -1) {
                    endpointUri = endpointUri + templateString.substring(templateString.indexOf('/'),
                            templateString.length);
                } else {
                    endpointUri = endpointUri + "/" + templateString;
                }
            }
        }
        return endpointUri;
    }
    ,

/**
 * @description Encodes a given string in either path or query parameter format.
 * @method _encodeString
 * @private
 * @static
 * @param {string} srcString String to be encoded.
 * @param {boolean} queryParm Indicates that the string is a query parameter and not a part of the path.
 * @return string URL encoded string.
 */
    _encodeString : function (srcString, queryParm) {
        var legalInPath = "-._~!$'()*+,;=:@";
        var legalInQuery = "-._~!$'()*+,;=:@/?";

        var legal = queryParm ? legalInQuery : legalInPath;
        var encodedString = "";
        for (var i = 0; i < srcString.length; i++) {
            var ch = srcString.charAt(i);
            if ((ch >= 'a' && ch <= 'z')
                    || (ch >= 'A' && ch <= 'Z')
                    || (ch >= '0' && ch <= '9')
                    || legal.indexOf(ch) > -1) {
                encodedString += ch;
            } else {
                // Function encodeURIComponent will not encode ~!*()' but they are legal anyway.
                encodedString += encodeURIComponent(ch);
            }
        }
        return encodedString;
    }
}
        ;



