<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">
        <h2>System Logs</h2>
        <div id='formset' style="margin-left: 0px; position: absolute; left: 210px;_left:-15px;">
			  <form>
                <fieldset style="border:none;">
                    <xsl:choose>
                        <xsl:when test="count(//return)!=0">
                            <div id="logtoolbar">
                                <table border="0" style="width:98%;">
                                    <tbody>
                                        <tr>
                                            <td>
                                                <xsl:text>View</xsl:text>
                                            </td>
                                            <td>
                                                <xsl:element name="select">
                                                    <xsl:attribute name="onchange">javascript:viewSingleLogLevel(); return false;</xsl:attribute>
                                                    <xsl:attribute name="id">logLevelID</xsl:attribute>
                                                    <xsl:attribute name="class">log-select</xsl:attribute>
                                                    <xsl:if test="@level">
                                                        <xsl:element name="option">
                                                            <xsl:attribute name="value">
                                                                <xsl:value-of select="@level"/>
                                                            </xsl:attribute>
                                                            <xsl:value-of select="@level"/>
                                                        </xsl:element>
                                                        <xsl:if test="@level='ALL'">
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="TRACE">
                                                                TRACE</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='INFO'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="TRACE">
                                                                TRACE</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='WARN'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="TRACE">
                                                                TRACE</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='ERROR'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="TRACE">
                                                                TRACE</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='DEBUG'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="TRACE">
                                                                TRACE</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='TRACE'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="FATAL">
                                                                FATAL</option>
                                                        </xsl:if>
                                                        <xsl:if test="@level='FATAL'">
                                                            <option value="ALL">
                                                                ALL</option>
                                                            <option value="INFO">
                                                                INFO</option>
                                                            <option value="WARN">
                                                                WARN</option>
                                                            <option value="ERROR">
                                                                ERROR</option>
                                                            <option value="DEBUG">
                                                                DEBUG</option>
                                                            <option value="TRACE">
                                                               TRACE</option>
                                                        </xsl:if>

                                                    </xsl:if>
                                                    <xsl:if test="not(@level)">
                                                    <option value="ALL">ALL</option>
                                                    <option value="INFO">INFO</option>
                                                    <option value="WARN">WARN</option>
                                                    <option value="ERROR">ERROR</option>
                                                    <option value="DEBUG">DEBUG</option>
                                                    <option value="TRACE">TRACE</option>
                                                    <option value="FATAL">FATAL</option>
                                                    </xsl:if>
                                                    </xsl:element>
                                            </td>
                                            <td style="width:440px;"></td>
                                            <td>
                                                <xsl:element name="input">
                                                    <xsl:attribute name="id">logkeyword</xsl:attribute>
                                                    <xsl:attribute name="type">text</xsl:attribute>
                                                    <xsl:attribute name="size">40</xsl:attribute>
                                                    <xsl:attribute name="class">log-select</xsl:attribute>
                                                    <xsl:attribute name="value">
                                                        <xsl:value-of select="@keyword"/>
                                                    </xsl:attribute>
                                                    <xsl:attribute name="onKeyPress">submitenter(event)</xsl:attribute>
                                                </xsl:element>
                                            </td>
                                            <td>
                                                <a href="#" id="search_link">
                                                    <xsl:attribute name="onClick">javascript:searchLog(); return false;</xsl:attribute>
                                                    <xsl:attribute name="title">Search Log</xsl:attribute>
                                                    <xsl:attribute name="alt">Search Log </xsl:attribute>
                                                    &#160;&#160;&#160;&#160;
                                                </a></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id ="logdiv" class="log-panel">
                                <table class="log">
                                    <tbody>
                                        <xsl:call-template name="print-row">
                                            <xsl:with-param name="value">
                                                <xsl:value-of select="count(//return)"/>
                                            </xsl:with-param>
                                            <xsl:with-param name="limit">
                                                <xsl:value-of select="count(//return)"/>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                    </tbody>
                                </table>
                            </div>
                            <div class="clearLog">
                                <input name="clearLogs" type="button"
                                       class="panelbutton_default"
                                       value="Clear All"
                                       onclick="javascript:clearLogEntries();return false;"/>
                            </div>
                        </xsl:when>
                        <xsl:otherwise>
                            <br/>
                            <i>
                                <font style='color: brown'>Currently there are no log messages
                                    present</font>
                            </i>
                            <br/>
                            <br/>
                        </xsl:otherwise>
                    </xsl:choose>
                </fieldset>
            </form>
        </div>
    </xsl:template>
    <xsl:template name="print-row">
        <xsl:param name="value"/>
        <xsl:param name="limit"/>
        <xsl:if test="$value != 0">
            <xsl:if test="$value mod 2 = 0">
                <tr>
                    <xsl:call-template name="print-logs">
                        <xsl:with-param name="index" select="($limit +1) - $value"/>
                    </xsl:call-template>
                </tr>
                <xsl:call-template name="print-row">
                    <xsl:with-param name="value" select="$value - 1"/>
                    <xsl:with-param name="limit" select="$limit"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="$value mod 2 = 1">
                <tr bgcolor="#EEEFFB">
                    <xsl:call-template name="print-logs">
                        <xsl:with-param name="index" select="($limit +1) - $value"/>
                    </xsl:call-template>
                </tr>
                <xsl:call-template name="print-row">
                    <xsl:with-param name="value" select="$value - 1"/>
                    <xsl:with-param name="limit" select="$limit"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template name="print-logs">
        <xsl:param name="index"/>
        <xsl:variable name="logStr" select="substring(//return[$index]/child::text(),0,6)"/>
        <xsl:variable name="returnStr" select="//return[$index]"/>
        <xsl:if test="$returnStr!='true'">
            <td border-bottom="gray">
                <xsl:if test="$logStr='ERROR'">
                    <img src="extensions/core/images/error.png"/>
                </xsl:if>
                <xsl:if test="$logStr=' INFO'">
                    <img src="extensions/core/images/information.gif"/>
                </xsl:if>
                <xsl:if test="$logStr='TRACE'">
                    <img src="extensions/core/images/trace.png"/>
                </xsl:if>
                <xsl:if test="$logStr=' WARN'">
                    <img src="extensions/core/images/warn.png"/>
                </xsl:if>
                <xsl:if test="$logStr='DEBUG'">
                    <img src="extensions/core/images/debug.png"/>
                </xsl:if>
                <xsl:if test="$logStr='FATAL'">
                    <img src="extensions/core/images/fatal.png"/>
                </xsl:if>
                &#160;&#160;
                <xsl:value-of select="//return[$index]"/>
            </td>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
