<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="ns1:getUserNamesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <h4><a href="#" onclick="javascript:manageUsers(); return false;">Users</a>&#160;&gt;&#160;User Management</h4>
        <div id="formset">
        <fieldset style="border:none;">
	        <table class="styled">
				<thead>
					<tr>
						<th>User Name</th>
	                    <th>User Description</th>
	                    <th>User Actions</th>
	                    <th>User Role</th>
	                    <th>User Role Actions</th>
	                </tr>
				</thead>
	            <xsl:for-each select="return">
	                <xsl:variable name="name_value">
	                    <xsl:value-of select="userName"/>
	                </xsl:variable>
	                <xsl:variable name="apos">
	                    <xsl:text>'</xsl:text>
	                </xsl:variable>
	                <xsl:variable name="r_apos">
	                    <xsl:text>§</xsl:text>
	                </xsl:variable>
	
	                <xsl:variable name="user_name"><xsl:value-of select="translate($name_value,$apos,$r_apos)"/></xsl:variable>
	
	                <tr>
						<td>
	                        <xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        <xsl:value-of select="userName"/>
	                    </td>
	                    <td>
	                        <xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        <xsl:value-of select="description"/>
	                    </td>
	                    <td>
	                        <xsl:attribute name="rowspan"><xsl:value-of select = "count(roles) + 1" /></xsl:attribute>
	                        &#160;&#160;
	                        <a id="edit_link">
								<xsl:attribute name="href">#</xsl:attribute>
								<xsl:attribute name="onClick">javascript:editUsers('<xsl:value-of select="$user_name"/>','<xsl:value-of select="role"/>'); return false;</xsl:attribute>
								<xsl:attribute name="title">Edit User</xsl:attribute>
								&#160;&#160;&#160;&#160;
							</a>
	                        &#160;&#160;&#160;&#160;
	                        <a id="cancel_link">
								<xsl:attribute name="href">#</xsl:attribute>
								<xsl:attribute name="onClick">javascript:deleteUser('<xsl:value-of select="$user_name"/>'); return false;</xsl:attribute>
								<xsl:attribute name="title">Delete User</xsl:attribute>
								&#160;&#160;&#160;&#160;
							</a>
	                        &#160;&#160;
	                    </td>
	                </tr>
	
	                <xsl:for-each select="roles">
	                    <tr>
	                        <xsl:variable name="role_value">
	                            <xsl:value-of select="role"/>
	                        </xsl:variable>
	                        <xsl:variable name="user_role"><xsl:value-of select="translate($role_value,$apos,$r_apos)"/></xsl:variable>
	                        <td><xsl:value-of select="role"/></td>
	
	                        <td>
	                            &#160;&#160;&#160;&#160;&#160;&#160;
	                           <a id="cancel_link">
								<xsl:attribute name="href">#</xsl:attribute>
								<xsl:attribute name="onClick">javascript:deleteRole('<xsl:value-of select="$user_name"/>','<xsl:value-of select="$user_role"/>'); return false;</xsl:attribute>
								<xsl:attribute name="title">Delete Role</xsl:attribute>
								&#160;&#160;&#160;&#160;
							   </a>
	                        </td>
	                    </tr>
	                </xsl:for-each>
	            </xsl:for-each>
	        </table>
        	<p>&#160;</p>
			<form>
				<fieldset>
					<legend>Add New User</legend>
					<div>
						<label>User Name<font color='red'>*</font></label><input type="text" id="userName" tabindex="1" maxlength="15"/>
					</div>
					<div>
						<label>Password<font color='red'>*</font></label><input type="password" id="password" tabindex="2" maxlength="15"/>
					</div>
					<div>
						<label>Retype Password<font color='red'>*</font></label><input type="password" id="password_re" tabindex="3" maxlength="15"/>
					</div>
					<div>
						<label>Role</label><select id="roleSelectBox" tabindex="4"></select>
					</div>

                    <!--<script><![CDATA[loadUserListComboBox();]]></script>-->
                    <div>
						<label>Description</label><input type="text" id="userDescription" tabindex="5" maxlength="50"/>
					</div>
                    <div class="buttonrow">
						<input type="button" onclick="javascript:addUser(document.getElementById('userName'),document.getElementById('password'),document.getElementById('password_re'),document.getElementById('roleSelectBox'),document.getElementById('userDescription'));" value="Add" tabindex="6"/>
					</div>
                    <iframe src="_blank.html" onload="javascript:loadUserListComboBox();"
                        scrolling="no" style="visibility:hidden"
                        width="0" height="0"/>
                </fieldset>
			</form>
        </fieldset>
        </div>
    </xsl:template>
</xsl:stylesheet>
