<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="ns:getMessagesResponse | ns:setMonitoringResponse" xmlns:ns="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">
            <h2>SOAP Tracer</h2>
            <div id="formset">
                <xsl:apply-templates select="return/flag" mode="flagSetting"/>
                <xsl:apply-templates select="return/flag" mode="filterSetting"/>
                <xsl:apply-templates select="return/flag" mode="information"/>

            </div>

        </fieldset>

    </xsl:template>

    <xsl:template match="flag" mode="flagSetting">
        <xsl:variable name="flagv" select="."/>
        <form>
            <fieldset>
                <legend>SOAP Tracing</legend>
                <div>
                    <label>SOAP Tracing</label>
                    <select>
                        <xsl:attribute name="id">monitorSettingCombo</xsl:attribute>
                        <xsl:attribute name="onchange">javascript:setMonitoring(this);return false;</xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="$flagv='ON'">
                                <option value='ON'>ON</option>
                                <option value='OFF'>OFF</option>
                            </xsl:when>
                            <xsl:otherwise>
                                <option value='OFF'>OFF</option>
                                <option value='ON'>ON</option>
                            </xsl:otherwise>
                        </xsl:choose>
                    </select>
                </div>
                <div>
                    <label>Tracer Persister</label>
                    <label><i><xsl:value-of select="../tracePersister"/></i></label>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template match="flag" mode="filterSetting">
        <xsl:variable name="flagv" select="."/>
        <xsl:variable name="filterStringv" select="../filterString"/>
        <xsl:variable name="filterv" select="../filter"/>
        <xsl:variable name="emptyv" select="../empty"/>
        <xsl:variable name="messageInfoCount" select="count(../messageInfo)"/>
        <xsl:comment><xsl:value-of select="$messageInfoCount"/></xsl:comment>
        <xsl:comment><xsl:value-of select="$flagv"/></xsl:comment>
        <xsl:comment><xsl:value-of select="$filterv"/></xsl:comment>
        <xsl:comment><xsl:value-of select="$emptyv"/></xsl:comment>
        <xsl:comment><xsl:value-of select="$filterStringv"/></xsl:comment>

        <xsl:call-template name="filterAreaSetting">
            <xsl:with-param name="filterStringv" select="$filterStringv"/>
        </xsl:call-template>

    </xsl:template>

    <xsl:template match="flag" mode="information">
        <xsl:variable name="flagv" select="."/>
        <xsl:variable name="emptyv" select="../empty"/>
        <xsl:variable name="filterv" select="../filter"/>
        <form>
            <fieldset>
                <legend>Information</legend>
                <div>
                    <xsl:attribute name="id">informationMainDivId</xsl:attribute>

                    <xsl:choose>
                        <xsl:when test="$flagv='ON'">
                            <xsl:choose>
                                <xsl:when test="$emptyv='true'">
                                    <xsl:choose>
                                        <xsl:when test="$filterv='true'">
                                            <div>
                                                <table>
                                                    <tr>
                                                        <td>&#160;&#160;&#160;&#160;</td>
                                                        <td>
                                                            <h4>No message found after applying the filter</h4>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <div>
                                                <table>
                                                    <tr>
                                                        <td>&#160;&#160;&#160;&#160;</td>
                                                        <td>
                                                            <span>
                                                                <ol>
                                                                    <li><h4>SOAP tracing turned on</h4></li>
                                                                    <li><h4>No SOAP messages in the Tracer's buffer.</h4></li>
                                                                    <li><h4>Use 'Filter' to mask messages on simple string comparison on request.<br/>
                                                                            Check the mask to enable Filtering.
                                                                         </h4></li>
                                                                    <li><b>WARNING:</b> <br/>
                                                                        <h5>
                                                                            Turning this ON will have a performance hit since all SOAP messages will be always completely built <br/>
                                                                            (i.e. deferred building will not be done) and stored in the database by WSO2 WSAS hence this option <br/>
                                                                            should be used with caution.
                                                                        </h5>
                                                                    </li>
                                                                </ol>
                                                            </span>

                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                    <div>
                                        <table>
                                            <tr>
                                                <td>
                                                    <div>
                                                        <b>Select SOAP Message To View</b>
                                                    </div>
                                                    <div>
                                                        <select id="tracerSelectBox">
                                                            <xsl:attribute name="onChange">javascript:traceMessage(this); return false;</xsl:attribute>
                                                            <xsl:attribute name="size">10</xsl:attribute>
                                                            <xsl:attribute name="multiple">false</xsl:attribute>
                                                            <xsl:apply-templates select="../messageInfo"/>
                                                        </select>
                                                    </div>

                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div>
                                        <xsl:attribute name="id">informationMainTableDivId</xsl:attribute>
                                        <xsl:call-template name="showMessage">
                                            <xsl:with-param name="requestv" select="../lastMessage/request"/>
                                            <xsl:with-param name="responsev" select="../lastMessage/response"/>
                                        </xsl:call-template>
                                    </div>
                                </xsl:otherwise>
                            </xsl:choose>

                        </xsl:when>
                        <xsl:otherwise>
                            <!-- OFF -->
                            <div>
                                <table>
                                    <tr>
                                        <td>&#160;&#160;&#160;&#160;</td>
                                        <td>
                                            <h4>SOAP Tracer has been turned off.</h4>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="filterAreaSetting">
        <xsl:param name="filterStringv"/>
        <form>
            <fieldset>
                <legend>Filter</legend>
                <table>
                    <tr>
                        <td>
                            <div>
                                <span>
                                    <input>
                                        <xsl:attribute name="type">text</xsl:attribute>
                                        <xsl:attribute name="id">filterTextId</xsl:attribute>
                                        <xsl:attribute name="size">50</xsl:attribute>
                                        <xsl:if test="$filterStringv">
                                            <xsl:attribute name="value"><xsl:value-of select="$filterStringv"/></xsl:attribute>
                                        </xsl:if>
                                        <xsl:comment><xsl:value-of select="$filterStringv"/></xsl:comment>
                                    </input>
                                    <input>
                                        <xsl:attribute name="type">submit</xsl:attribute>
                                        <xsl:attribute name="value">Find</xsl:attribute>
                                        <xsl:attribute name="id">filterFindId</xsl:attribute>
                                        <xsl:attribute name="onClick">javascript:findMaskedObjects(document.getElementById("filterTextId").value);return false;</xsl:attribute>
                                    </input>
                                    <input>
                                        <xsl:attribute name="type">submit</xsl:attribute>
                                        <xsl:attribute name="value">Clear</xsl:attribute>
                                        <xsl:attribute name="id">clearButtonId</xsl:attribute>
                                        <xsl:attribute name="onClick">javascript:viewTracer();return false;</xsl:attribute>
                                    </input>
                                </span>
                            </div>
                        </td>
                    </tr>
                </table>
            </fieldset>
        </form>

    </xsl:template>


    <xsl:template name="showMessage">
        <xsl:param name="requestv"/>
        <xsl:param name="responsev"/>

        <table>
            <tr>
                <td>
                    <div>
                        <b>SOAP Message - Request</b>
                    </div>
                    <div>
                        <textarea>
                            <xsl:attribute name="id">txtAreaReceive</xsl:attribute>
                            <xsl:attribute name="cols">80</xsl:attribute>
                            <xsl:attribute name="rows">15</xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="not($requestv)">
                                     Request SOAP message does not exists
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$requestv"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </textarea>
                        <img>
                            <xsl:attribute name="id">tracer_zoom_out_link_1</xsl:attribute>
                            <xsl:attribute name="onClick">javascript:shrinkRequestTextBox();return false;</xsl:attribute>
                            <xsl:attribute name="title">Reduce observable space</xsl:attribute>
                            <xsl:attribute name="class">.cornerCollapse</xsl:attribute>
                            <xsl:attribute name="src">extensions/core/images/collapse.gif</xsl:attribute>
                        </img>
                    </div>
                </td>

            </tr>
            <tr>
                <td>
                    <div>
                        <b>SOAP Message - Response</b>
                    </div>
                    <div>
                        <textarea>
                            <xsl:attribute name="id">txtAreaSend</xsl:attribute>
                            <xsl:attribute name="cols">80</xsl:attribute>
                            <xsl:attribute name="rows">15</xsl:attribute>
                            <xsl:choose>
                                <xsl:when test="not($responsev)">
                                    Response SOAP message dose not exists
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:value-of select="$responsev"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </textarea>
                        <img>
                            <xsl:attribute name="id">tracer_zoom_out_link_2</xsl:attribute>
                            <xsl:attribute name="onClick">javascript:shrinkResponseTextBox();return false;</xsl:attribute>
                            <xsl:attribute name="title">Reduce observable space</xsl:attribute>
                            <xsl:attribute name="class">.cornerCollapse</xsl:attribute>
                            <xsl:attribute name="src">extensions/core/images/collapse.gif</xsl:attribute>
                        </img>
                    </div>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="messageInfo">
        <xsl:variable name="value"><xsl:value-of select="serviceId"/>-<xsl:value-of select="operationName"/>-<xsl:value-of select="messageSequence"/></xsl:variable>
        <xsl:variable name="textv">[<xsl:value-of select="timestamp"/>]<xsl:value-of select="serviceId"/>#<xsl:value-of select="operationName"/>&lt;<xsl:value-of select="messageSequence"/>&gt;</xsl:variable>
        <option value='OFF'>
            <xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
            <xsl:if test="position()=1">
                <xsl:attribute name="selected">true</xsl:attribute>
            </xsl:if>

            <xsl:value-of select="$textv"/>
        </option>

    </xsl:template>

    <xsl:template match="ns:getMessageResponse" xmlns:ns="http://org.apache.axis2/xsd">
        <xsl:call-template name="showMessage">
            <xsl:with-param name="requestv" select="return/request"/>
            <xsl:with-param name="responsev" select="return/response"/>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
