<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="ns1:enableTimestampResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <span>
                        <input id="outflow_checkbox" tabindex="1">
                            <xsl:attribute name="type">checkbox</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,2);</xsl:attribute>
                            <xsl:if test="$isEnabled='true'">
                                <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>
                        </input>
                        Timestamp
                        <br/>
                    </span>
                </div>
                <xsl:if test="$isEnabled='true'">
                    <div id='outflow_timestamp'>
                       <input type="radio" name="outflowGroup" tabindex="2">
                            <xsl:attribute name="value">true</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,this.value,2,showTSOutflowConfigurationDivCallback);return true;</xsl:attribute>
                            <xsl:if test="$istimestampFirst='true'">
                                 <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>

                        </input>
                        First
                        <br/>
                        <input type="radio" name="outflowGroup" tabindex="3">
                            <xsl:attribute name="value">false</xsl:attribute>
                            <xsl:if test="$istimestampFirst='false'">
                                 <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>
                            <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,this.value,2,showTSOutflowConfigurationDivCallback);return true;</xsl:attribute>
                        </input>
                        Last
                        <br/>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Timestamp Oufflow Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ns1:disableTimestampResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <span>
                        <input id="outflow_checkbox" tabindex="4">
                            <xsl:attribute name="type">checkbox</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,2);</xsl:attribute>
                            <xsl:if test="$isEnabled='true'">
                                <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>
                        </input>
                        Timestamp
                        <br/>
                    </span>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Timestamp Oufflow Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="ns1:setTimestampOrderResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="isEnabled"><xsl:value-of select="return/enabled" /></xsl:variable>
                <xsl:variable name="istimestampFirst"><xsl:value-of select="return/timestampFirst" /></xsl:variable>
                <div>
                    <span>
                        <input id="outflow_checkbox" tabindex="5">
                            <xsl:attribute name="type">checkbox</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:timestampFlowConfig(this,2);</xsl:attribute>
                            <xsl:if test="$isEnabled='true'">
                                <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>
                        </input>
                        Timestamp
                        <br/>
                    </span>
                </div>
                <xsl:if test="$isEnabled='true'">
                    <div id='outflow_timestamp'>
                       <input type="radio" name="outflowGroup" tabindex="6">
                            <xsl:attribute name="value">true</xsl:attribute>
                            <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,this.value,2,showTSOutflowConfigurationDivCallback);return true;</xsl:attribute>
                            <xsl:if test="$istimestampFirst='true'">
                                 <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>

                        </input>
                        First
                        <br/>
                        <input type="radio" name="outflowGroup" tabindex="7">
                            <xsl:attribute name="value">false</xsl:attribute>
                            <xsl:if test="$istimestampFirst='false'">
                                 <xsl:attribute name="checked">true</xsl:attribute>
                            </xsl:if>
                            <xsl:attribute name="onclick">javascript:setTimestampOrder(RAMPART_OUTFLOW_CONFIG_ADMIN_STRING,this.value,2,showTSOutflowConfigurationDivCallback);return true;</xsl:attribute>
                        </input>
                        Last
                        <br/>
                    </div>
                </xsl:if>
            </xsl:when>
            <xsl:otherwise>
                <div>Problem encountered displaying Timestamp Oufflow Configuration</div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
