<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">

    <xsl:template match="ns1:getServerDataResponse">
        <h2>System Information</h2>
        <fieldset style="border:none;">
             <xsl:apply-templates select="return"/>
        </fieldset>
    </xsl:template>

    <xsl:template match="return">
        <table class="styledLeft">
            <thead>
                <tr>
                    <th colspan="2">WSO2 Web Services Application Server</th>
                </tr>
            </thead>
            <tr>
                <td>
                    <strong>Version</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(wso2wsasVersion)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Repository&#160;Location</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(repoLocation)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Axis2&#160;Location</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(axis2Location)"/>
                </td>
            </tr>
            <thead>
                <tr>
                    <th colspan="2">Java VM</th>
                </tr>
            </thead>
            <tr>
                <td>
                    <strong>Java&#160;Home</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(javaHome)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Java&#160;Runtime&#160;Name</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(javaRuntimeName)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Java&#160;Version</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(javaVersion)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Java&#160;Vendor</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(javaVMVendor)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Java&#160;VM&#160;Version</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(javaVMVersion)"/>
                </td>
            </tr>
            <thead>
                <tr>
                    <th colspan="2">Server</th>
                </tr>
            </thead>
            <tr>
                <td>
                    <strong>OS&#160;Name</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(osName)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>OS&#160;Version</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(osVersion)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Server&#160;Name</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(serverName)"/>
                </td>
            </tr>
            <thead>
                <tr>
                    <th colspan="2">User</th>
                </tr>
            </thead>
            <tr>
                <td>
                    <strong>User&#160;Country</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(userCountry)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>User&#160;Home</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(userHome)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>User&#160;Name</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(userName)"/>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>User&#160;Timezone</strong>
                </td>
                <td>
                    <xsl:value-of select="normalize-space(userTimezone)"/>
                </td>
            </tr>
        </table>

    </xsl:template>
</xsl:stylesheet>
