<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://org.apache.axis2/xsd"
                exclude-result-prefixes="ns1">
    
    <xsl:output method="html"/>

    <xsl:template match="ns1:listServicesAndPortsResponse">
        <!--  Link header to be populated by java script -->
        <div id="stubGenMetaInfo"></div>
        <div id="formset">
            <form>
                <fieldset>
                    <legend>Stub Generation options</legend>

                    <xsl:variable name="serviceName"><xsl:value-of select="return/serviceEndpointsData/serviceName"/></xsl:variable>
                    <xsl:variable name="wv" select="return/wsdlVersion"/>
                    <table>

                        <xsl:apply-templates select="return">
                            <xsl:with-param name="wv" select="$wv"/>
                        </xsl:apply-templates>


                        <tr>
                            <td>
                                <label>Package Name <font color='red'>*</font></label>
                            </td>
                            <td>
                                <input>
                                    <xsl:attribute name="type">text</xsl:attribute>
                                    <xsl:attribute name="id">pakageName</xsl:attribute>
                                    <xsl:attribute name="size">40</xsl:attribute>
                                    <xsl:attribute name="value">org.wso2.wsas.client</xsl:attribute>
                                    <xsl:attribute name="tabindex">3</xsl:attribute>
                                 </input>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>Invocation Style</label>
                            </td>
                            <td>
                                <select>
                                    <xsl:attribute name="id">invocationStyle</xsl:attribute>
                                    <xsl:attribute name="tabindex">4</xsl:attribute>
                                    <option value='both'>Both</option>
                                    <option value='a'>Asynchronous</option>
                                    <option value='s'>Synchronous</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>Databinding</label>
                            </td>
                            <td>
                                <select id='databindingMethod' tabindex="5">
                                    <xsl:attribute name="onchange">javascript:codegenUnwrappingSelectorHelper(this);return false;</xsl:attribute>
                                    <option value='adb'>ADB</option>
                                    <option value='xmlbeans'>XMLBeans</option>
                                    <option value='none'>NONE</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>Unpack Classes</label>
                            </td>
                            <td>
                                <select id='unpackClasses' tabindex="6">
                                    <option value='true'>True</option>
                                    <option value='false'>False</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>Unwrap</label>
                            </td>
                            <td>
                                <select id='unwrap' tabindex="7">
                                    <option value='false'>False</option>
                                    <option value='true'>True</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label>Generate Testcase</label>
                            </td>
                            <td>
                                <select id='generateTestCases' tabindex="8">
                                    <option value='false'>False</option>
                                    <option value='true'>True</option>
                                </select>
                            </td>
                        </tr>


                        <tr>
                            <td/>
                            <td>
                                <div>
                                    <input type='button' value='Generate' tabindex="9">
                                        <xsl:attribute name="onClick">javascript:stubGenerationSOAPRequest(document.getElementById('pakageName'),document.getElementById('invocationStyle'),document.getElementById('generateTestCases'),document.getElementById('databindingMethod'),document.getElementById('unpackClasses'),'<xsl:value-of select="$serviceName"/>',document.getElementById('portSelectBox'),document.getElementById('unwrap'),document.getElementById('wsdlVersion'));return false;</xsl:attribute>
                                        <xsl:attribute name="id">dynamicClientButtonId</xsl:attribute>
                                    </input>
                                </div>
                            </td>
                        </tr>
                    </table>

                </fieldset>
            </form>
        </div>
    </xsl:template>

    <xsl:template match="return">
        <xsl:param name="wv"/>
        <xsl:if test="$wv='1.1'">
            <tr>
                <td>
                    <label>Information from</label>
                </td>
                <td>WSDL-1.1</td>
            </tr>
        </xsl:if>

        <xsl:if test="$wv='2.0'">
            <tr>
                <td>
                    <label>Information from</label>
                </td>
                <td>WSDL-2.0</td>
            </tr>
        </xsl:if>

        <xsl:apply-templates select="serviceEndpointsData">
            <xsl:with-param name="wv" select="$wv"/>
        </xsl:apply-templates>


    </xsl:template>

    <xsl:template match="serviceEndpointsData">
        <xsl:param name="wv"/>

        <tr>
            <td>
                <label>Service Binding</label>
            </td>
            <td>
                <xsl:value-of select="serviceName"/>
            </td>
        </tr>

        <tr>
            <td>
                <label>WSDL Version</label>
            </td>
            <td>
                <select id='wsdlVersion' tabindex="1">
                    <xsl:attribute name="onchange">javascript:stubGenerationMetaInfo(this[this.selectedIndex].value);return false;</xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="$wv='1.1'">
                            <option value='1.1'>1.1</option>
                            <option value='2.0'>2.0</option>
                        </xsl:when>
                        <xsl:otherwise>
                            <option value='2.0'>2.0</option>
                            <option value='1.1'>1.1</option>
                        </xsl:otherwise>
                    </xsl:choose>
                </select>
            </td>
        </tr>

        <xsl:if test="$wv='1.1'">
            <tr>
                <td>
                    <label>Port</label>
                </td>
                <td>
                    <select id="portSelectBox" tabindex="2">
                        <xsl:for-each select="endpointNames">
                            <option>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="."/>
                                </xsl:attribute>
                                <xsl:value-of select="."/>
                            </option>
                        </xsl:for-each>
                    </select>
                </td>
            </tr>
        </xsl:if>

        <xsl:if test="$wv='2.0'">
           <tr>
               <td>
                   <label>Endpoints</label>
               </td>
               <td>
                   <select id="portSelectBox" tabindex="2">
                       <xsl:for-each select="endpointNames">
                           <option>
                               <xsl:attribute name="value">
                                   <xsl:value-of select="."/>
                               </xsl:attribute>
                               <xsl:value-of select="."/>
                           </option>
                       </xsl:for-each>
                   </select>
               </td>
            </tr>
        </xsl:if>
    </xsl:template>


</xsl:stylesheet>
