<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />

    <xsl:template match="ns1:getStatusResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <h2>System Statistics</h2>

		<table class="styledLeft">
			<xsl:for-each select="return">
                <thead><tr><th colspan="2">Service Summary</th></tr></thead>
                <tr>
				<td><strong>Average Response Time</strong></td>
				<td><xsl:value-of select = "format-number(avgResponseTime,'#.##')" />  ms</td>
				</tr>
				<tr>
				<td><strong>Minimum Response Time</strong></td>
				<td>
                    <xsl:choose>
                        <xsl:when test="minResponseTime=0">
                            &lt; 1.00 ms
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="format-number(minResponseTime,'0.00')"/> ms
                        </xsl:otherwise>
                    </xsl:choose>
                </td>
				</tr>
				<tr>
				<td><strong>Maximum Response Time</strong></td>
				<td><xsl:value-of select="format-number(maxResponseTime,'0.00')"/> ms</td>
				</tr>
                <tr>
				<td><strong>Total Request Count</strong></td>
				<td><xsl:value-of select="requestCount"/></td>
				</tr>
                <tr>
				<td><strong>Total Response Count</strong></td>
				<td><xsl:value-of select="responseCount"/></td>
				</tr>
                <tr>
				<td><strong>Total Fault Count</strong></td>
				<td><xsl:value-of select="faultCount"/></td>
				</tr>
                <tr>
                <td><strong>Active Services</strong></td>
				<td><xsl:value-of select="services"/></td>
				</tr>

                <thead><tr><th colspan="2">Server</th></tr></thead>
                <tr>
				<td><strong>Server Name</strong></td>
				<td><xsl:value-of select="serverName"/></td>
				</tr>
				<tr>
				<td><strong>Server Start Time</strong></td>
				<td><xsl:value-of select="serverStartTime"/></td>
				</tr>
				<tr>
				<td><strong>System Up Time</strong></td>
				<td><xsl:value-of select="systemUpTime"/></td>
				</tr>

                <thead><tr><th colspan="2">Memory</th></tr></thead>
                <tr>
                    <td><strong>Memory Allocated</strong></td>
				<td><xsl:value-of select="totalMemory/value"/><xsl:value-of select="totalMemory/unit"/></td>
				</tr>
                <tr>
				<td><strong>Memory Usage</strong></td>
				<td><xsl:value-of select="usedMemory/value"/><xsl:value-of select="usedMemory/unit"/></td>
				</tr>
			</xsl:for-each>
		</table>

    </xsl:template>

    <xsl:template match="initializeStatistics">
            <div id="formset">
                <div id="showGlobalStatusTable"></div>
                <form>
                    <iframe>
                        <xsl:attribute name="id">divGraphMemUsageInnerFrame</xsl:attribute>
                        <xsl:attribute name="frameborder">0</xsl:attribute>
                        <xsl:attribute name="style">width:650px;height:600px;position:relative;</xsl:attribute>
                        <xsl:attribute name="scrolling">no</xsl:attribute>
                        <xsl:attribute name="src">extensions/core/graphs.html</xsl:attribute>
                    </iframe>
              </form>

            </div>
    </xsl:template>

</xsl:stylesheet>
