<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="ns1:getSpringBeanNamesResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <h4><a href="#" onClick="javascript:showServiceInitializer(); return false;">Services</a>&#160;&gt;&#160;Service Archive Generation/Spring</h4>
                <!-- end of link header block -->
                <!-- Div handling starts from here-->
        <fieldset style="border:none;">
        <xsl:choose>
            <xsl:when test="return">
                <xsl:variable name="springContextUUID"><xsl:value-of select="return/springContext"/></xsl:variable>
                <div id="formset">
					<form>
						<fieldset>
							<legend>Select Spring Beans to be exposed as Web services</legend>
                            <div class="buttonrowTop">
                                <input type="button" value="Generate" tabindex="1">
                                    <xsl:attribute name="onclick">generateBeansForAARSelectClasses('<xsl:value-of select="$springContextUUID"/>');</xsl:attribute>
                                </input>
                                &#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkBeans'), true);"
                                       value="Select All" tabindex="2"/>&#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkBeans'), false);"
                                       value="Select None" tabindex="3"/>
					        </div>
                            <br/>
                            <xsl:choose>
                                <xsl:when test="return/beans">
                                    <table class="styled">
                                        <thead>
                                            <tr>
                                                <th>Bean Name</th>
                                                <th>Include</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="return/beans">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="."/>
                                                    </td>
                                                    <td>
                                                        <input type="checkbox">
                                                        <xsl:attribute name="name">chkBeans</xsl:attribute>
                                                        <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
                                                        <xsl:attribute name="tabindex">
                                                             <xsl:value-of select="position() + 3"/>
                                                        </xsl:attribute>
                                                        </input>
                                                    </td>
                                                </tr>

                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:when>
                                <xsl:otherwise>
                                     <table>
                                         <tr>
                                             <td>No beans available in the uploaded spring xml.</td>
                                         </tr>
                                    </table>
                                </xsl:otherwise>
                            </xsl:choose>
                            <br/>
                            <div class="buttonrowBottom">
                                <input type="button" value="Generate">
                                    <xsl:attribute name="onclick">generateBeansForAARSelectClasses('<xsl:value-of select="$springContextUUID"/>');</xsl:attribute>
                                </input>
                                &#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkBeans'), true);"
                                       value="Select All"/>&#160;&#160;&#160;&#160;&#160;
                                <input type="button" onclick="selectAll(document.getElementsByName('chkBeans'), false);"
                                       value="Select None"/>
					        </div>
                        </fieldset>
					</form>
				</div>
            </xsl:when>
            <xsl:otherwise>
				<table>
					 <tr>
						 <td>Error Encounterd Listing Available Spring Beans</td>
					 </tr>
				</table>
            </xsl:otherwise>
        </xsl:choose>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>


