<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <xsl:template match="*">

        <!--  Link header to be populated by java script -->
		<div id="listFaultyServices"></div>
        
		<!-- end of link header block -->
        <table class="styled">
            <thead>
                 <tr>
                     <th>Faulty Service</th>
                     <th>Action</th>
                 </tr>
            </thead>
            <tbody>
            <xsl:for-each select="return">
				<tr>
					<td><xsl:value-of select="serviceName"/></td>
                    <td>
                        <nobr>
                                &#160;&#160;
                            <a href="#" id="cancel_link">
                                <xsl:attribute name="onClick">javascript:deleteFaultyService('<xsl:value-of select="serviceName"/>'); return false;</xsl:attribute>
                                <xsl:attribute name="title">Delete Faulty Service</xsl:attribute>
                                <xsl:attribute name="alt">Remove</xsl:attribute>
                                &#160;&#160;&#160;&#160;
                            </a>
                            </nobr>
                    </td>
                </tr>
                <tr>
                     <td colspan="2">
                          <xsl:value-of select="fault"/>
                     </td>
                </tr>
             </xsl:for-each>
            </tbody>
         </table>
         <iframe src="_blank.html" onload="javascript:showlistFaultyServices(document.getElementById('listFaultyServices'));"
                        scrolling="no" style="visibility:hidden"
                        width="0" height="0"/>
    </xsl:template>
</xsl:stylesheet>


