<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
    	<div>
	        <fieldset style="border:none;">
	        	<div id="divAxisFlowChainTextHeaderPerService"></div>
	        	<div style="top:15px;right:20px;position: absolute;"><a href="#" onclick="javascript:listEngagedOperationHandlers()" style="font-size:85%;">Graphical View</a></div>
	         	<div id="axisConfPerServiceText">
					<xsl:call-template name="axisConfiguration"/>
				</div>
			</fieldset>
        </div>
    </xsl:template>
    <xsl:template name="phaseTemplate">
    	<thead><tr><th colspan="2" style="text-align:left">&#160;&#160;<xsl:value-of select="name"/></th></tr></thead>
    	<tbody>
		<xsl:choose>
		<xsl:when test="handlers">
			<xsl:for-each select="handlers">
				<tr>
                    <xsl:if test="position() mod 2 = 1">
                        <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                    </xsl:if>
                    <td>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="name"/></td>
					<td><xsl:value-of select="className"/></td>
				</tr>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<tr><td colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;No handlers present.</td></tr>
		</xsl:otherwise>
		</xsl:choose>
		</tbody>
    </xsl:template>
    
    <xsl:template name="flowTemplate">
	   <xsl:for-each select="phases">
			<xsl:call-template name="phaseTemplate"/>
			<tr><td colspan="2"></td></tr>
		</xsl:for-each>
    </xsl:template>
    <xsl:template name="axisConfiguration">
    	<div id="formset">
    		<fieldset style="border:none;">
			<form>
				<div>
				   <table class="styled">
					   <thead><tr><th colspan="2" style="text-align: left;background-color: #fff; color:#000;border: 0px;"><h3 style="font-size: 130%;">In Flow</h3></th></tr></thead>
					   <xsl:for-each select="return/inflowPhaseOrder">
						   <xsl:call-template name="flowTemplate">
								<xsl:with-param name="flowName">In Flow</xsl:with-param>
						   </xsl:call-template>
					   </xsl:for-each>
					   <thead>
					   		<tr><td colspan="2">&#160;</td></tr>
							<tr><th colspan="2" style="text-align: left;background-color: #fff; color:#000;border: 0px;"><h3 style="font-size: 130%;">Out Flow</h3></th></tr>
						</thead>
					   <xsl:for-each select="return/outflowPhaseOrder">
						   <xsl:call-template name="flowTemplate">
								<xsl:with-param name="flowName">Out Flow</xsl:with-param>
						   </xsl:call-template>
					   </xsl:for-each>
						<thead>
							<tr><td colspan="2">&#160;</td></tr>
							<tr><th colspan="2" style="text-align: left;background-color: #fff; color:#000;border: 0px;"><h3 style="font-size: 130%;">In Fault Flow</h3></th></tr>
						</thead>
					   <xsl:for-each select="return/infaultflowPhaseOrder">
							<xsl:call-template name="flowTemplate">
								<xsl:with-param name="flowName">In Fault Flow</xsl:with-param>
						   </xsl:call-template>
					   </xsl:for-each>
						<thead>
							<tr><td colspan="2">&#160;</td></tr>
							<tr><th colspan="2" style="text-align: left;background-color: #fff; color:#000;border: 0px;"><h3 style="font-size: 130%;">Out Fault Flow</h3></th></tr>
						</thead>
					   <xsl:for-each select="return/outfaultPhaseOrder">
						   <xsl:call-template name="flowTemplate">
								<xsl:with-param name="flowName">Out Fault Flow</xsl:with-param>
						   </xsl:call-template>
					   </xsl:for-each>
				   </table>
				</div>
			</form>
			</fieldset>
        </div>
    </xsl:template>

</xsl:stylesheet>