<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="*">
    	<div style="top: 110px; left: 220px; position: absolute;">
    	<fieldset style="border: 0px">
        	<div id="divAxisFlowChainGraphicPerServiceHeader"></div>
            <div style="top:15px;right:20px;position: absolute;"><a href="#" onclick="javascript:axisConfigTextPerSerivce();" style="font-size:85%;">Text View</a></div>
            <div id="axisConf">
                <xsl:call-template name="axisConfiguration"/>
            </div>
        </fieldset>
        </div>
    </xsl:template>
    <xsl:template name="phaseTemplate">
		<xsl:param name="handlerColor"/>
		<xsl:param name="positionNumber"/>
		<xsl:param name="flowNodeNameToPhase"/>
		<xsl:param name="flowNameToPhase"/>
	   		<xsl:if test="($positionNumber!=1)">
			<td>
				<img>
					<xsl:attribute name="src">extensions/core/images/<xsl:value-of select="$handlerColor"/>_left.gif</xsl:attribute>
					<xsl:attribute name="border">0px</xsl:attribute>
				</img>
			</td>
			</xsl:if>
			<td>
				<xsl:attribute name="id"><xsl:value-of select="$handlerColor"/>_BG</xsl:attribute>
				<a>
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:axisConfigHandlersPerService('<xsl:value-of select="$flowNameToPhase"/>', '<xsl:value-of select="$flowNodeNameToPhase"/>', '<xsl:value-of select="name"/>');return false;</xsl:attribute>
					<xsl:value-of select="name"/>
				</a>
			</td>
			<td>
				<img>
					<xsl:attribute name="src">extensions/core/images/<xsl:value-of select="$handlerColor"/>_right.gif</xsl:attribute>
					<xsl:attribute name="border">0px</xsl:attribute>
				</img>
			</td>
    </xsl:template>
    
    <xsl:template name="flowTemplate">
    		<xsl:param name="flowNodeName"/>
    		<xsl:param name="flowName"/>
    		<xsl:param name="flowImg"/>
                            <tr><td>
			<table border="0" cellspacing="0" cellpadding="0" width="100px" id="flowChain">
				<tr>
					<td><img>
							<xsl:attribute name="src">extensions/core/images/handlerChain_leftmost_<xsl:value-of select="$flowImg"/>.gif</xsl:attribute>
						</img>
					</td>
                       <xsl:for-each select="phases">
							<xsl:if test="(position() mod 2)=1">
	                       		<xsl:call-template name="phaseTemplate">
									<xsl:with-param name="handlerColor">handler_01</xsl:with-param>
									<xsl:with-param name="positionNumber"><xsl:value-of select="position()"/></xsl:with-param>
									<xsl:with-param name="flowNodeNameToPhase"><xsl:value-of select="$flowNodeName"/></xsl:with-param>
									<xsl:with-param name="flowNameToPhase"><xsl:value-of select="$flowName"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
							<xsl:if test="(position() mod 2)=0">
	                       		<xsl:call-template name="phaseTemplate">
									<xsl:with-param name="handlerColor">handler_02</xsl:with-param>
									<xsl:with-param name="positionNumber"><xsl:value-of select="position()"/></xsl:with-param>
									<xsl:with-param name="flowNodeNameToPhase"><xsl:value-of select="$flowNodeName"/></xsl:with-param>
									<xsl:with-param name="flowNameToPhase"><xsl:value-of select="$flowName"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
                        </xsl:for-each>
					<td><img>
							<xsl:attribute name="src">extensions/core/images/handlerChain_rightmost_<xsl:value-of select="$flowImg"/>.gif</xsl:attribute>
						</img>
					</td>
				</tr>
				
			</table>
                           </td></tr>
    </xsl:template>
    <xsl:template name="axisConfiguration">
        <form>
                <div>
                   <table id="flowChain">
                       <tr><td>In Flow</td></tr>
                       <xsl:for-each select="return/inflowPhaseOrder">
	                       <xsl:call-template name="flowTemplate">
	                       		<xsl:with-param name="flowNodeName">inflowPhaseOrder</xsl:with-param>
	                       		<xsl:with-param name="flowName">In Flow</xsl:with-param>
	                       		<xsl:with-param name="flowImg">inflow</xsl:with-param>
	                       </xsl:call-template>
                       </xsl:for-each>
                       </table>
                       <table id="flowChain" >
                       <tr><td>Out Flow</td></tr>
                       <xsl:for-each select="return/outflowPhaseOrder">
	                       <xsl:call-template name="flowTemplate">
	                       		<xsl:with-param name="flowNodeName">outflowPhaseOrder</xsl:with-param>
	                       		<xsl:with-param name="flowName">Out Flow</xsl:with-param>
	                       		<xsl:with-param name="flowImg">outflow</xsl:with-param>
	                       </xsl:call-template>
                       </xsl:for-each>
						</table><table id="flowChain">
                       <tr><td>In Fault Flow</td></tr>
                       <xsl:for-each select="return/infaultflowPhaseOrder">
	                       	<xsl:call-template name="flowTemplate">
	                       		<xsl:with-param name="flowNodeName">infaultflowPhaseOrder</xsl:with-param>
	                       		<xsl:with-param name="flowName">In Fault Flow</xsl:with-param>
	                       		<xsl:with-param name="flowImg">inflow</xsl:with-param>
	                       </xsl:call-template>
                       </xsl:for-each>
                        </table><table id="flowChain">
                       <tr><td>Out Fault Flow</td></tr>
                       <xsl:for-each select="return/outfaultPhaseOrder">
	                       <xsl:call-template name="flowTemplate">
	                       		<xsl:with-param name="flowNodeName">outfaultPhaseOrder</xsl:with-param>
								<xsl:with-param name="flowName">Out Fault Flow</xsl:with-param>
								<xsl:with-param name="flowImg">outflow</xsl:with-param>
	                       </xsl:call-template>
                       </xsl:for-each>
                   </table>
                </div>
        </form>
    </xsl:template>

</xsl:stylesheet>