<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>
    <!-- template for processing the module name list -->

    <xsl:template match="ns1:listModulesResponse" xmlns:ns1="http://org.apache.axis2/xsd">

        <h2 id="moduleHeader">Module Management</h2>
        <fieldset style="border:none;">
            <div id='formset'>
        <table class="styled">
        	<thead>
            <tr>
            	<th>Name</th>
            	<th>Version</th>
            	<th>Description</th>
            	<th>Actions</th>
			</tr>
			</thead>
			<tbody>
            <xsl:for-each select="return">
            	<xsl:variable name="engaged"><xsl:value-of select="engaged"/></xsl:variable>
                <tr>
                    <xsl:if test="position() mod 2 = 1">
                        <xsl:attribute name="bgcolor">#EEEFFB</xsl:attribute>
                    </xsl:if>
                    <td>
                        <a>
                            <xsl:attribute name="href">#</xsl:attribute>
                            <xsl:attribute name="onClick">javascript:getModuleInfo('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
                            <!--  the description about the service - shown in mouse over -->
                            <xsl:attribute name="title">Configure <xsl:value-of select="modulename"/> module</xsl:attribute>
                            <xsl:value-of select="modulename"/>
                        </a>
					</td>
					<td><xsl:value-of select="moduleVersion"/></td>
					<td>
                        <xsl:value-of select="description"/>
                	</td>
					<td>
						<nobr>
                            <a href="#" id="cancel_link">
                                <xsl:attribute name="onClick">javascript:removeModule('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
                                <xsl:attribute name="title">Remove <xsl:value-of select="modulename"/> module</xsl:attribute>
                                <xsl:attribute name="alt">Remove</xsl:attribute>
                                &#160;&#160;&#160;&#160;
                            </a>
							<xsl:if test="$engaged='true'">
								<a href="#" id="module_dis-engage_link">
									<xsl:attribute name="onClick">javascript:disengageModuleForSystem('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
									<xsl:attribute name="title">Globally disengage <xsl:value-of select="modulename"/> module</xsl:attribute>
									<xsl:attribute name="alt">GLobally disengage <xsl:value-of select="modulename"/> module</xsl:attribute>
									&#160;&#160;&#160;&#160;
								</a>
							</xsl:if>
							<xsl:if test="$engaged='false'">
								<a href="#" id="module_engage_link">
									<xsl:attribute name="onClick">javascript:engageModuleForSystem('<xsl:value-of select="moduleId"/>','<xsl:value-of select="moduleVersion"/>'); return false;</xsl:attribute>
									<xsl:attribute name="title">Globally engage <xsl:value-of select="modulename"/> module</xsl:attribute>
									<xsl:attribute name="alt">Globally engage <xsl:value-of select="modulename"/> module</xsl:attribute>
									&#160;&#160;&#160;&#160;
								</a>
							</xsl:if>
                        </nobr>
                    </td>
				</tr>
            </xsl:for-each>
        </tbody>
		</table>         
            <div id="listGloballyEngageModulesForObserve"/>
            </div>

            <div id="formset">
			<form method="post"  name="Axis2upload" action="fileupload/module" enctype="multipart/form-data" target="globalIFrame">
				<fieldset>
					<legend>Upload a New Module</legend>
					<div>
						<label for="module_a">Module archive (.mar) :</label><input type="file" name="filename" id="filename" size="50"/>
					</div>
					<div class="buttonrow">
						<input name="upload" type="submit" value=" Upload ">
							<xsl:attribute name="onclick">javascript: if (document.Axis2upload.filename.value == '') { wso2.wsf.Util.alertWarning('Please select a file before clicking upload.'); return false;}</xsl:attribute>
						</input>
					</div>
				</fieldset>
			 </form>
		</div>
        </fieldset>
    </xsl:template>

    <!-- Tempalte for processing a single module parameter information set-->
    <xsl:template match="ns1:getModuleParametersResponse" xmlns:ns1="http://org.apache.axis2/xsd">
        <fieldset style="border:none;">
            <div id="getModuleParameterHeader"></div>

        <xsl:choose>
            <xsl:when test="return">
                <!--  Link header to be populated by java script -->
                <!--<div id="getModuleParameterHeader"></div>-->
                <!--<script>-->
                   <!--<![CDATA[-->
                   <!--var tempStringHeader = "<h3 id='pageHeader'><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&#160;&gt;&#160;" +-->
                                           <!--"Module Information for "+ getLastUsedModuleId() + "</h3>";-->
                   <!--document.getElementById('getModuleParameterHeader').innerHTML = tempStringHeader;-->
                   <!--]]>-->
                <!--</script>-->
                <!-- end of link header block -->

                <table class="semi">
                    <tr>
                    	<td><strong>Parameter Name</strong></td>
                        <td><strong>Parameter Value</strong></td>
					</tr>
                    <xsl:for-each select="return">
                        <tr>
                        	<td><xsl:value-of select="parameter/@name"/></td>
							<td>
								<xsl:choose>
									<xsl:when test="parameter=''">
										[Empty]
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="parameter"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
                    </xsl:for-each>
                </table>
            </xsl:when>
            <xsl:otherwise>
                 <!--  Link header to be populated by java script -->
                <!--<div id="getModuleParameterHeader"></div>-->
                <!--<script>-->
                   <!--<![CDATA[-->
                   <!--var tempStringHeader = "<h3 id='pageHeader'><a href=\"#\" onClick=\"javascript:listModules(); return false;\">Modules</a>&#160;&gt;&#160;" +-->
                                           <!--"Module Information for " + getLastUsedModuleId() + "</h3>";-->
                   <!--document.getElementById('getModuleParameterHeader').innerHTML = tempStringHeader;-->
                   <!--]]>-->
                <!--</script>-->
                <!-- end of link header block -->

                <h2>There are no configurable parameters for this module</h2>
            </xsl:otherwise>
        </xsl:choose>
        </fieldset>
    </xsl:template>
</xsl:stylesheet>
